<?php

if (!is_admin()) {
	die ("Unauthorized.");
}


function cd_ad_make_excluded_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['aid']) && $_REQUEST['aid'] ) {
		$cd_aid = (int)$_REQUEST['aid'];
	} else {
		$cd_aid = 0;
	}
	$op = $_GET['op'];
	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Excluded IP', 'cd_ad_sponsor').'</h2>';

	switch ($op) {
		case "add":
			if ($_POST['action'] == "addexcluded") {
				$cd_aid = $wpdb->escape($_POST['aid']);
				$cd_exclude_ip = $wpdb->escape($_POST['excluded_ip']);
				$cd_description = $wpdb->escape($_POST['ip_description']);
				$iquery = "INSERT INTO cd_ad_sponsor_excluded (aid,excludeIP,blog_id,description) VALUES (null,'$cd_exclude_ip','$blog_id','$cd_description')";
				$result = $wpdb->query($iquery);
				if ($result == 1) {
					echo '<div id="message" class="updated fade"><p>IP Address &quot;'.$cd_exclude_ip.'&quot; created.</p></div>';
					cd_ad_excluded_render();
					break;
				} else {
					echo '<div id="message" class="updated fade"><p>Error creating IP Address.</p></div>';
					cd_ad_excluded_render();
				}
			}
			echo '<h3>'.__('Add Excluded IP', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to add a new excluded IP.</p>';
			echo '<form action="" method="post" name="addexcluded" id="addexcluded">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="excluded_ip">Excluded IP Address</label>
			<input name="action" type="hidden" id="action" value="addexcluded" />
			<input name="op" type="hidden" id="op" value="add" />
			<input name="aid" type="hidden" id="aid" value="'.$cd_aid.'" /></th>';

			echo '<td><input name="excluded_ip" type="text" id="excluded_ip" value="'.$cd_exclude_ip.'" style="width:200px;" /><br /><span class="description">Enter the IP Address to Exclude.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="ip_description">Description</label></th>
		<td><input name="ip_description" type="text" id="ip_description" value="'.$cd_description.'" style="width:200px;" /><br /><span class="description">Enter the Description of this IP Address.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="addexcluded" type="submit" id="addexcluded" class="button" value="Save Changes" />
			</p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editexcluded") {
				$cd_aid = $wpdb->escape($_POST['aid']);
				$cd_exclude_ip = $wpdb->escape($_POST['excluded_ip']);
				$cd_description = $wpdb->escape($_POST['ip_description']);
				$iquery = "UPDATE cd_ad_sponsor_excluded SET excludeIP='$cd_exclude_ip',blog_id='$blog_id',description='$cd_description' WHERE aid=$cd_aid";
				$result = $wpdb->query($iquery);
				if ($result == 1) {
					echo '<div id="message" class="updated fade"><p>Excluded IP Address &quot;'.$cd_exclude_ip.'&quot; updated.</p></div>';
					cd_ad_excluded_render();
					break;
				} elseif ( $result == 0 ) {
					echo '<div id="message" class="updated fade"><p>No Update required.</p></div>';
					cd_ad_excluded_render();
					break;
				} else {
					echo '<div id="message" class="updated fade"><p>Error editing IP Address.</p></div>';
					cd_ad_excluded_render();
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_excluded WHERE aid='$cd_aid'");
				$cd_exclude_ip = stripslashes($result->excludeIP);
				$cd_description = stripslashes($result->description);
			}
			echo '<h3>'.__('Edit Excluded IP', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the excluded IP.</p>';
			echo '<form action="" method="post" name="editexcluded" id="editexcluded">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="excluded_id">Excluded IP Address</label>
			<input name="action" type="hidden" id="action" value="editexcluded" />
			<input name="op" type="hidden" id="op" value="edit" />
			<input name="aid" type="hidden" id="aid" value="'.$cd_aid.'" /></th>';

			echo '<td><input name="excluded_ip" type="text" id="excluded_ip" value="'.$cd_exclude_ip.'" style="width:200px;" /><br /><span class="description">Enter the IP Address to exclude.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="ip_description">Description</label></th>
		<td><input name="ip_description" type="text" id="ip_description" value="'.$cd_description.'" style="width:400px;" /><br /><span class="description">Enter the Description of this Excluded IP.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="editexcluded" type="submit" id="editexcluded" class="button" value="Save Changes" />
			</p></form>';
			break;

		case "delete":
			$vip = $wpdb->get_var("SELECT excludeIP FROM cd_ad_sponsor_excluded WHERE aid=$cd_aid");
			if ($wpdb->query("DELETE FROM cd_ad_sponsor_excluded WHERE aid=$cd_aid")) {
				echo '<div id="message" class="updated fade"><p>IP '.$vip.' deleted.</p></div>';
			} else {
				echo '<div id="message" class="updated fade"><p>Error deleting IP '.$vip.'.</p></div>';
			}
			cd_ad_excluded_render();
			break;

		case "clear":
			$cd_clear_list = $wpdb->get_results("SELECT excludeIP FROM cd_ad_sponsor_excluded WHERE blog_id=$blog_id", OBJECT);
			if ($cd_clear_list) {
				foreach($cd_clear_list as $result) {
					$wpdb->query("DELETE FROM cd_ad_sponsor_clickthrough WHERE blog_id=$blog_id AND visitorIP='".$result->excludeIP."'");
				}
			}
			echo '<div id="message" class="updated fade"><p>Clickthrough counts have been cleared.</p></div>';
			cd_ad_excluded_render();
			break;

		default:
			cd_ad_excluded_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}

function cd_ad_excluded_render() {
	global $wpdb,$blog_id;
	ob_start();
	echo '<p>The following table lists all currently Excluded IP addresses for blog, <b><i>';
	echo bloginfo('name').'</i></b>.</p>';
	echo '<div class="submit">
	<a class="button" href="admin.php?page=cd_ad_excluded_menu&op=add" title="Add Excluded IP">Add Excluded IP
	</a>&nbsp;&nbsp;<a class="button" href="admin.php?page=cd_ad_excluded_menu&op=clear" title="Clear SE Clickthrough Counts">Clear Counts</a></div>'."\n";
	echo '<div class="cd_render">';
	echo '<table class="widefat" width="99%">
	<thead><tr>
	<th scope="col">'.__('Excluded IP', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Host', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Description', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Delete', 'cd_ad_sponsor').'</th>
	</tr></thead>
	<tbody>';
	$cd_excluded_list = $wpdb->get_results("SELECT aid,excludeIP,description FROM cd_ad_sponsor_excluded WHERE blog_id=$blog_id ORDER BY excludeIP ASC", OBJECT);
	if ($cd_excluded_list) {
		foreach($cd_excluded_list as $result) {
			echo '<tr>';
			echo '<td><a href="admin.php?page=cd_ad_excluded_menu&op=edit&aid='.$result->aid.'" title="Edit '.$result->excludeIP.' IP.">'.$result->excludeIP.'</a></td>';
			echo '<td>'.gethostbyaddr($result->excludeIP).'</td>';
			echo '<td>'.stripslashes($result->description).'</td>';
			echo '<td><a href="admin.php?page=cd_ad_excluded_menu&op=delete&aid='.$result->aid.'" title="Delete '.$result->excludeIP.' from Excluded IP table."><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_clear.png" alt="Delete '.$result->excludeIP.' from Excluded IP table." /></a></td>';
			echo '</tr>'."\n";
		}
	} else {
		echo '<tr colspan="4"><td><b>No Excluded IPs Found.</b></td>';
	}
	echo '</tbody></table></div><br />';

	echo '<div style="border-top:1px solid #E0E0FF;"><p>Excluded IP are compared to the user IP address to determine whether a click-through is registered for a Sponsor Ad. This exclusion is necessary to prevent false clicks, such as when the site administrator tests a displayed ad link. This feature is provided to accurately track CPC and CPM statistics in the cd_ad_sponsor plugin only.</p>
	<p><b>Notes:</b><ol><li> Excluded IPs have no bearing on those sponsor programs that also acquire the source IP. This means that programs, such as Google AdSense will still register your IP and may determine that a specific click is not valid.</li>
	<li>Some search engine crawlers, such as googlebot, trigger a clickthrough count. You can Clear these counts for all listed Excluded IP addresses for the current blog.</li>
	<li>If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Excluded IPs apply to the currently active blog only.</li></ol></p>';
	cd_ad_admin_footer();
	echo '</div>';

}

?>
