<?php

function cd_ad_zone( $cd_zone = 0, $e = true ) {
	global $wpdb, $blog_id;

	if ($cd_zone == 0) { return; }

	$zresult = $wpdb->get_row( "SELECT rows*cols as slots,def_ad FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id AND zid=$cd_zone", OBJECT );
	$z_def_ad = $zresult->def_ad;
	$ad_limit = $zresult->slots;

	$squery = "SELECT b.bid, b.cid, b.zone_id, b.name, b.link, b.b_url, b.alt, b.s_link, c.enddate, c.cid AS sched FROM cd_ad_sponsor_banners AS b LEFT JOIN cd_ad_sponsor_schedule AS c ON b.bid = c.bid WHERE b.zone_id = $cd_zone AND b.blog_id = $blog_id AND now( ) >= c.startdate AND now( ) <= c.enddate AND b.rev_id IN (SELECT r.rev_id FROM cd_ad_sponsor_revenue AS r WHERE";

	$ad_return = array();
	$ad_count = 0;

	if ( $ad_count < $ad_limit ) {
		$squery_cpd = " r.name = 'CPD') ORDER BY c.enddate";
		$sched_result = $wpdb->get_results( $squery.$squery_cpd, OBJECT );
		if (!empty($sched_result)) {
			$ad_count += cd_ad_get_banners( $sched_result, &$ad_return, $ad_limit);
		}
	}
	if ( $ad_count < $ad_limit ) {
		$squery_cpd = " r.name <> 'CPD') ORDER BY RAND( NOW( ) )";
		$sched_result = $wpdb->get_results( $squery.$squery_cpd, OBJECT );
		if (!empty($sched_result)) {
			$ad_count += cd_ad_get_banners( $sched_result, &$ad_return, $ad_limit );
		}
	}

	if ( $ad_count < $ad_limit ) {
		for ( $ad_num = 1; $ad_num <= $ad_limit - $ad_count; $ad_num++ ) {
			$ad_return[$ad_count + $ad_num] = '<span class="cd_ad_slot"><a class="cd_ad_link" href="'.get_option('cd_ad_sponsor_link_default').'" title="'.get_option('cd_ad_sponsor_alt_default').'" rel="nofollow"><img class="cd_ad_img" src="'.$z_def_ad.'" alt="'.get_option('cd_ad_sponsor_alt_default').'" /></a></span>';
		}
	}

	$ret_value = '<div class="cd_ad_wrap"><div class="cd_ad_slots">';
	foreach( $ad_return as $key=>$value ) {
		$ret_value .= $value;
	}
	$ret_value .= '</div></div>';
	if ( $e ) {
		echo $ret_value;
	} else {
		return $ret_value;
	}
}

function cd_ad_get_banners( $resultset, &$banners, $adlimit ) {
	global $wpdb,$blog_id;
	$ad_count = count($banners);
	$ad_expire = array();
	foreach ($resultset as $result) {
		if ( ( is_home() || is_front_page() ) || ( ( is_singular() || is_category() || is_archive() || is_search() ) && cd_ad_in_category( $result->bid ) ) ) {
			$cd_bid = $result->bid;
			$cd_zid = $result->zone_id;
			$cd_cid = $result->sched;
			if ( cd_ad_in_rotation( $cd_zid, $cd_bid ) == 0 ) {
				if ( $result->b_url != '' ) {
					$banners[$ad_count] = '<span class="cd_ad_slot"><a class="cd_ad_link" href="'.get_option('blogurl').'index.php?bid='.$cd_bid.'&cid='.$cd_cid.'&type='.$cd_zid.'" title="'.$result->alt.'" target="_blank" rel="nofollow"><img class="cd_ad_img" src="'.$result->b_url.'" alt="'.$result->alt.'"></a></span>';
				} else {
					$banners[$ad_count] = '<span class="cd_ad_slot">'.stripslashes($result->s_link).'</span>';
				}
				cd_ad_impressions( $cd_cid );
				$ad_count++;
			}
			$cd_exp = $result->enddate;
			$cd_offset = get_option('cd_ad_sponsor_expiration');
			if ($cd_offset >= 1) {
			} else {
				$cd_offset = 0;
			}
			$d = mktime(0, 0, 0, date("m"), date("d") + $cd_offset, date("Y"));
			if ( $d >= strtotime($cd_exp) ) {
				$cd_notice = $wpdb->get_var("SELECT sent FROM cd_ad_sponsor_schedule WHERE cid=$cd_cid");
				if ( $cd_notice == '0' ) {
					$cd_banner = $wpdb->get_var("SELECT name FROM cd_ad_sponsor_banners WHERE bid=$cd_bid AND blog_id=$blog_id");
					$cd_sponsor = $wpdb->get_var("SELECT name FROM cd_ad_sponsor WHERE sid = (SELECT sid FROM cd_ad_sponsor_schedule WHERE cid=$cd_cid)");
					$msg = "Ad: ".$cd_banner."\r\nSponsor: ".$cd_sponsor."\r\nExpiring: ".$cd_exp.".\r\n\r\n";
					$ae = get_option('admin_email');
					$sbj = "Expiring Sponsor Ad";
					$hdr = 'Reply-To: '.$ae."\r\n";
					$hdr .= 'From: '.$ae."\r\n";
					@mail($ae, $sbj, $msg, $hdr);
					$cd_sent = $wpdb->query("UPDATE cd_ad_sponsor_schedule SET sent='1' WHERE cid='$cd_cid'");
				}
			}
		}
		if ($ad_count == $adlimit) {break;}
	}
	return $ad_count;
}

function cd_ad_in_category($bid) {
	global $wpdb,$blog_id;
	$cquery = "SELECT cid FROM cd_ad_sponsor_banners WHERE bid=$bid AND blog_id=$blog_id";
	$cresults = $wpdb->get_row($cquery);
	$cresults = explode(",", $cresults->cid);
	$result = in_category($cresults);
	return $result;
}

add_action('init', 'cd_ad_clickthrough');

function cd_ad_clickthrough() {
	if ( isset( $_GET['bid'] ) && isset( $_GET['cid'] ) && isset( $_GET['type'] ) ) {
		global $wpdb,$blog_id;
		$ip1=$_SERVER['REMOTE_ADDR'];
		$ip2=$_SERVER['HTTP_X_FORWARDED_FOR'];
		if (($ip2!='') && (ip2long($ip2)!=-1)) { $vip=$ip2; }else{ $vip=$ip1; }
		$vip=substr($vip,0,15);
		$result = $wpdb->query("SELECT * FROM cd_ad_sponsor_excluded WHERE excludeIP=$vip AND blog_id=$blog_id", OBJECT);
		if ( $result == 0 ) {
			$bid = $_GET['bid'];
			$cid = $_GET['cid'];
			$tstamp = date("Y-m-d H:i:s");
			if ( isset( $_GET['type'] ) ) {
				$result = $wpdb->query("INSERT INTO cd_ad_sponsor_clickthrough (mid,cid,blog_id,timestamp,visitorIP) VALUES (null,'$cid','$blog_id','$tstamp','$vip')");
				$redir = $wpdb->get_var("SELECT link FROM cd_ad_sponsor_banners WHERE bid=$bid");
				if ( $redir != '' ) {
					header( "Location: $redir", true, 302 );
					exit;
				}
			}
		}
	}
}

function cd_ad_impressions( $cid ) {
	global $wpdb,$blog_id;
	$result = $wpdb->query("UPDATE cd_ad_sponsor_schedule SET impressions = impressions + 1 WHERE blog_id = $blog_id AND cid = $cid");
	return $result;
}

function cd_ad_in_rotation( $zid, $bid ) {
	global $wpdb,$blog_id;
	$rquery = "SELECT zid,bid FROM cd_ad_sponsor_rotation WHERE zid=$zid AND bid=$bid AND blog_id=$blog_id";
	$result = $wpdb->query($rquery);
	if ( $result == 0 ) {
		$wpdb->query("INSERT INTO cd_ad_sponsor_rotation (zid,bid,blog_id) VALUES ('$zid','$bid','$blog_id')");
	} else {
		$result = true;
	}
	return $result;
}

add_action('wp_footer', 'cd_ad_clear_rotation');
function cd_ad_clear_rotation() {
	global $wpdb,$blog_id;
	$wpdb->query("DELETE FROM cd_ad_sponsor_rotation WHERE blog_id=$blog_id");
	if (get_option('cd_ad_sponsor_clear_default')) {
		$cd_clear_list = $wpdb->get_results("SELECT excludeIP FROM cd_ad_sponsor_excluded WHERE blog_id=$blog_id", OBJECT);
		if ($cd_clear_list) {
			foreach($cd_clear_list as $result) {
				$wpdb->query("DELETE FROM cd_ad_sponsor_clickthrough WHERE blog_id=$blog_id AND visitorIP='".$result->excludeIP."'");
			}
		}
	}
}

add_filter('the_content', 'cd_ad_embed_post', 11);

function cd_ad_embed_post($content) {
	global $wpdb,$post,$blog_id;

	if ( is_singular() ) {
		$cd_copy = $content;
		$cd_eof = false;
		$cd_count = 0;
		$new_pos = 0;

		if ( strpos($cd_copy, "<!--cd_ad_none-->") !== false) {
			$cd_copy = str_replace("<!--cd_ad_none-->", "", $cd_copy);
			return $cd_copy;
		}

		$zresults = $wpdb->get_row("SELECT zone_id, freq FROM cd_ad_sponsor_zones WHERE blog_id =$blog_id AND freq > 0",OBJECT);
		if ($zresults) {
			$ad_freq = $zresults->freq;
			$ad_zone = $zresults->zone_id;
			while ( !$cd_eof ) {
				$cd_count++;
				$new_pos = stripos( $cd_copy, '</p>', $new_pos );
				if ( $new_pos !== false ) {
					if ( $cd_count == $ad_freq ) {
						$cd_ad = cd_ad_zone( $ad_zone, false );
						$cd_count = 0;
						$prefix = substr($cd_copy, 0, $new_pos+4);
						$suffix = substr($cd_copy, $new_pos+4);
						$new_pos = strlen($prefix.$cd_ad);
						$cd_copy = $prefix.$cd_ad.$suffix;
					} else {
						$new_pos += 4;
					}
				} else {
					$cd_eof = true;
				}
			}
		}
		return $cd_copy;
	}
	return $content;
}


?>
