<?php


function register_cd_ad_settings() {
	register_setting( 'cd-ad-group', 'cd_ad_sponsor_link_default' );
	register_setting( 'cd-ad-group', 'cd_ad_sponsor_alt_default' );
	register_setting( 'cd-ad-group', 'cd_ad_sponsor_clear_default' );
	register_setting( 'cd-ad-group', 'cd_ad_sponsor_expiration' );
}


function cd_ad_make_options_menu() {
	ob_start();
?>

<div class="wrap">
<div class="icon32"><img src="<?php echo cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png'; ?>" width="30px" height="31px" border="0" /></div>
<h2>Manage Sponsor Options</h2>
<h3>Add/Edit Options</h3>
<p>Complete the following form to create or edit the default banner ad options for this blog.</p>
<form method="post" action="options.php">

<?php settings_fields( 'cd-ad-group' ); ?>

<table class="form-table">

<tr class="form-field">
<th scope="row">
<label for="cd_ad_sponsor_link_default">Default Purchase Ad URI</label></th>
<td><input type="text" id="cd_ad_sponsor_link_default" name="cd_ad_sponsor_link_default" style="width:300px;" value="<?php echo get_option('cd_ad_sponsor_link_default'); ?>" />
<br /><span class="description">Enter the default purchase URI.<br /><b>Note:</b> This is the page where your customer may purchase ads.</span></td>
</tr>

<tr class="form-field">
<th scope="row">
<label for="cd_ad_sponsor_alt_default">Default Alt/Title Tag</label></th>
<td><input type="text" id="cd_ad_sponsor_alt_default" name="cd_ad_sponsor_alt_default" style="width:300px;" value="<?php echo get_option('cd_ad_sponsor_alt_default'); ?>" />
<br /><span class="description">Enter the default Alt/Title text. E.g., Advertise with us.<br /><b>Note:</b> This value will be used for all default banner images.</span></td>
</tr>

<tr class="form-field">
<th scope="row">
<label for="cd_ad_sponsor_clear_default">Clear Clickthrough Counts</label></th>
<td><input type="checkbox" id="cd_ad_sponsor_clear_default" name="cd_ad_sponsor_clear_default" style="width:20px;" <?php if (get_option('cd_ad_sponsor_clear_default')) {echo 'checked';} ?> />
<br /><span class="description">Check to automatically clear SE crawler clickthrough counts.</span></td>
</tr>

<tr class="form-field">
<th scope="row">
<label for="cd_ad_sponsor_expiration">Days to notify before Ad expiration</label></th>
<td><input type="text" id="cd_ad_sponsor_expiration" name="cd_ad_sponsor_expiration" style="width:30px;" value="
<?php
if (get_option('cd_ad_sponsor_expiration') >= 1) {
	echo get_option('cd_ad_sponsor_expiration');
} else {
	echo '0';
}
?>" />
<br /><span class="description">Enter the number of days prior to Ad expiration.<br /><b>Note:</b> An Ad Expiration email is sent to the administrator email account.</span></td>
</tr>

</table>

<p class="submit">
<input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
</p>

</form>
</div>

<?php
}
?>
