<?php

if (!is_admin()) {
	die ("Unauthorized.");
}


function cd_ad_make_programs_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['sid']) && $_REQUEST['sid'] ) {
		$cd_sid = (int)$_REQUEST['sid'];
	} else {
		$cd_sid = 0;
	}
	if ( isset($_REQUEST['pid']) && $_REQUEST['pid'] ) {
		$cd_pid = (int)$_REQUEST['pid'];
	} else {
		$cd_pid = 0;
	}
	$op = $_GET['op'];
	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Sponsor Programs', 'cd_ad_sponsor').'</h2>';

	switch ($op) {
		case "add":
			if ($_POST['action'] == "addprogram") {
				$cd_sid = $wpdb->escape($_POST['sid']);
				$cd_program_site = $wpdb->escape($_POST['program_site']);
				$cd_program_type = $wpdb->escape($_POST['program_type']);
				$cd_program_name = $wpdb->escape($_POST['program_name']);
				$cd_program_description = $wpdb->escape($_POST['program_description']);
				if ($cd_program_site != "" && $cd_program_type != "" && $cd_program_name != "") {
					$result = $wpdb->query("INSERT INTO cd_ad_sponsor_program (pid,sid,site,type,name,description) VALUES (null,'$cd_sid','$cd_program_site','$cd_program_type','$cd_program_name','$cd_program_description')");
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Sponsor program &quot;'.$cd_program_name.'&quot; created.</p></div>';
						cd_ad_program_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error creating sponsor program.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Program Site, Type, and Name are Required.</p></div>';
				}
			}
			$savestatus='';
			echo '<h3>'.__('Add Sponsor Program', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to create a new sponsor program. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="addprogram" id="addprogram">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="sid">Sponsor Name<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="addprogram" />
			<input name="op" type="hidden" id="op" value="add" /></th>';

			echo '<td><select name="sid" id="sid" style="width:200px;">';
			$result = cd_get_sponsor_select($cd_sid);
			if ($result == false) {
				$savestatus = 'disabled';
				echo '<option value="">None Defined</option>';
			} else {
				echo $result;
			}
			echo '</select>';
			echo '<br /><span class="description">';
			if ($result == false) {
				echo '<b>You must first define a Sponsor.</b>';
			} else {
				echo 'Select the sponsor associated with this program.';
			}
			echo '</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_name">Program Name<sup class="req">*</sup></label></th>
		<td><input name="program_name" type="text" id="program_name" value="'.$cd_program_name.'" style="width:200px;" /><br /><span class="description">Enter the Program Type name. Ex., AdSense, Affiliate, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_site">Program Site<sup class="req">*</sup></label></th>
		<td><input name="program_site" type="text" id="program_site" value="'.$cd_program_site.'" style="width:200px;" /><br /><span class="description">Enter the Sponsor Site name. Ex., Home Page, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_type">Program Type<sup class="req">*</sup></label></th>
		<td><input name="program_type" type="text" id="program_type" value="'.$cd_program_type.'" style="width:100px;" /><br /><span class="description">Enter the Sponsor program type. Ex., PPS, REV, REF, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_description">Description</label></th>
		<td><input name="program_description" type="text" id="program_description" value="'.$cd_program_description.'" style="width:400px;" /><br /><span class="description">Enter the description of this program type. Ex., 30% With Coupon, etc.</span></td></tr>'."\n";
			echo '</table>
			<p class="submit">
			<input name="addprogram" type="submit" id="addprogram" class="button" value="Save Changes" '.$savestatus.' />
			</p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editprogram") {
				$cd_sid = $wpdb->escape($_POST['sid']);
				$cd_program_site = $wpdb->escape($_POST['program_site']);
				$cd_program_type = $wpdb->escape($_POST['program_type']);
			$cd_program_name = $wpdb->escape($_POST['program_name']);
				$cd_program_description = $wpdb->escape($_POST['program_description']);
				if ($cd_program_site != "" && $cd_program_type != "" && $cd_program_name != "") {
					$result = $wpdb->query("UPDATE cd_ad_sponsor_program SET sid='$cd_sid',site='$cd_program_site',type='$cd_program_type',name='$cd_program_name',description='$cd_program_description' WHERE pid=$cd_pid");
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Sponsor program &quot;'.$cd_program_name.'&quot; updated.</p></div>';
						cd_ad_program_render();
						break;
					} elseif ( $result == 0 ) {
						echo '<div id="message" class="updated fade"><p>No Update required.</p></div>';
						cd_ad_program_render();
						break;

					} else {
						echo '<div id="message" class="error fade"><p>Error editing sponsor program.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Program Site, Type, and Name are Required.</p></div>';
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_program WHERE pid='$cd_pid'");
				$cd_sid = stripslashes($result->sid);
				$cd_program_site = stripslashes($result->site);
				$cd_program_type = stripslashes($result->type);
				$cd_program_name = stripslashes($result->name);
				$cd_program_description = stripslashes($result->description);
			}
			$sponsor_name = $wpdb->get_var("SELECT name FROM cd_ad_sponsor WHERE sid=$cd_sid");
			echo '<h3>'.__('Edit Program Details', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the program details for sponsor, <b>'.$sponsor_name.'</b>. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="editprogram" id="editprogram">';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="program_name">Program Name<sup class="req">*</sup></label></th>
		<td><input name="program_name" type="text" id="program_name" value="'.$cd_program_name.'" style="width:200px;" /><br /><span class="description">Enter the Program Type name. Ex., AdSense, Affiliate, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_site">Program Site<sup class="req">*</sup></label></th>
		<td><input name="program_site" type="text" id="program_site" value="'.$cd_program_site.'" style="width:200px;" /><br /><span class="description">Enter the Sponsor Site name. Ex., Home Page, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_type">Program Type<sup class="req">*</sup></label></th>
		<td><input name="program_type" type="text" id="program_type" value="'.$cd_program_type.'" style="width:100px;" /><br /><span class="description">Enter the Sponsor program type. Ex., PPS, REV, REF, etc.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="program_description">Description</label></th>
		<td><input name="program_description" type="text" id="program_description" value="'.$cd_program_description.'" style="width:400px;" /><br /><span class="description">Enter the description of this program type. Ex., 30% With Coupon, etc.</span></td></tr>'."\n";
			echo '</table>
			<p class="submit">
			<input name="sid" type="hidden" id="sid" value="'.$cd_sid.'" />
			<input name="action" type="hidden" id="action" value="editprogram" />
			<input name="op" type="hidden" id="op" value="edit" /></th>
			<input name="editprogram" type="submit" id="editprogram" class="button" value="Save Changes" />
			</p></form>';
			break;

		default:
			cd_ad_program_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}

function cd_ad_program_render() {
	global $wpdb,$blog_id;
	ob_start();

	echo '<p>The following table lists all currently defined programs grouped by sponsor.</p>';
	echo '<div class="submit">
	<a class="button" href="admin.php?page=cd_ad_programs_menu&op=add&pid=0" title="Add Sponsor Program">Add Sponsor Program
	</a></div>'."\n";
	echo '<div class="cd_render">';

	echo '<table class="widefat" width="99%">
		<colgroup span="2" width="15%"><colgroup span="1" width="30%"><colgroup span="1" width="40%"><thead><tr>
		<th scope="col">'.__('Program Name', 'cd_ad_sponsor').'</th>
		<th scope="col">'.__('Program Site', 'cd_ad_sponsor').'</th>
		<th scope="col">'.__('Program Type', 'cd_ad_sponsor').'</th>
		<th scope="col">'.__('Description', 'cd_ad_sponsor').'</th>
		</tr></thead><tbody>';

	$cd_sponsor_list = $wpdb->get_results("SELECT sid,name FROM cd_ad_sponsor ORDER BY name ASC", OBJECT);

	if ($cd_sponsor_list) {
		foreach($cd_sponsor_list as $result) {
			$row_id='row'.$result->sid;
			echo '<tr style="background-color:#FDFFBB;" class="parent" id="'.$row_id.'"><td colspan="4" style="font-size:12px;"><b><i>'.$result->name.'</i></b></td></tr>';
			$cd_program_list = $wpdb->get_results("SELECT pid, site, type, name, description FROM cd_ad_sponsor_program WHERE sid=$result->sid ORDER BY site,name,type", OBJECT);
			if ($cd_program_list) {
				foreach($cd_program_list as $programs) {
					echo '<tr class="child-'.$row_id.'">';
					echo '<td><a href="admin.php?page=cd_ad_programs_menu&op=edit&pid='.$programs->pid.'&sid='.$result->sid.'" title="Edit sponsor '.$result->name.' program '.$programs->name.' details.">'.$programs->name.'</a></td>';
					echo '<td>'.$programs->site.'</td>';
					echo '<td>'.$programs->type.'</td>';
					echo '<td>'.stripslashes($programs->description).'</td>';
					echo '</tr>';
				}
			} else {
				echo '<tr><td colspan="4"><b>No Sponsor Programs Found.</b></td></tr>';
			}
		}
	} else {
		echo '<tr><td colspan="4"><b>No Sponsor Programs Found.</b></td></tr>';
	}
	echo '</tbody></table></div><br />'."\n";

	echo '<div style="border-top:1px solid #E0E0FF;"><p>Sponsor Programs represent the various payment program types for a specific site or product offered by a sponsor. Program types include Pay Per Sign up (PPS), Revenue Sharing (REV), a referral program (REF), commission (COM), a flat fee (FEE), etc. Some sponsors offer more than one option for each program type, such as with or without a trial period. You should define each Program Type you wish to use for each Sponsor. Each Program Type you define is later assigned to one or more Banner Ads.</p>
	<p><b>Note:</b> If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Program Types are &quot;Sponsor specific&quot; and, therefore, apply across all blogs. It is recommended that you define all Program Types in which you have elected to participate for each of your sponsors.</p>';
	cd_ad_admin_footer();
	echo '</div>';


}

?>
