<?php

if (!is_admin()) {
	die ("Unauthorized.");
}


function cd_ad_make_revenue_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['revid']) && $_REQUEST['revid'] ) {
		$cd_revid = (int)$_REQUEST['revid'];
	} else {
		$cd_revid = 0;
	}
	$op = $_GET['op'];
	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Revenue Types', 'cd_ad_sponsor').'</h2>';

	switch ($op) {
		case "add":
			if ($_POST['action'] == "addrevenue") {
				$cd_rid = $wpdb->escape($_POST['rid']);
				$cd_rate = $wpdb->escape($_POST['rate']);
				$cd_name = $wpdb->escape($_POST['name']);
				$cd_description = $wpdb->escape($_POST['description']);
				if ($cd_rid != "" && $cd_name != "") {
					$iquery = "INSERT INTO cd_ad_sponsor_revenue (rev_id,rid,name,description,rate) VALUES (null,'$cd_rid','$cd_name','$cd_description','$cd_rate')";
					$result = $wpdb->query($iquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Revenue Type &quot;'.$cd_name.'&quot; created.</p></div>';
						cd_ad_revenue_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error creating Revenue Type.</p></div>';
						cd_ad_revenue_render();
					}
				} else {
					echo '<div id="message" class="error fade"><p>Revenue Type and Name are Required.</p></div>';
				}
			}
			echo '<h3>'.__('Add Revenue Type', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to add a new Revenue Type. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="addrevenue" id="addrevenue">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="rid">Revenue ID<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="addrevenue" />
			<input name="op" type="hidden" id="op" value="add" /></th>';

			echo '<td><input name="rid" type="text" id="rid" value="'.$cd_rid.'" style="width:50px;" /><br /><span class="description">Enter a numeric Revenue Type ID.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="name">Revenue Type Name<sup class="req">*</sup></label></th>
		<td><input name="name" type="text" id="name" value="'.$cd_name.'" style="width:50px;" /><br /><span class="description">Enter the 3-character Name of this Revenue Type.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="description">Description</label></th>
		<td><input name="description" type="text" id="description" value="'.$cd_description.'" style="width:400px;" /><br /><span class="description">Enter the Description of this Revenue Type.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="rate">Rate</label></th>
		<td><input name="rate" type="text" id="rate" value="'.$cd_rate.'" style="width:100px;" /><br /><span class="description">Enter the Rate for this Revenue Type.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="addrevenue" type="submit" id="addrevenue" class="button" value="Save Changes" />
			</p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editrevenue") {
				$cd_rid = $wpdb->escape($_POST['rid']);
				$cd_rate = $wpdb->escape($_POST['rate']);
				$cd_name = $wpdb->escape($_POST['name']);
				$cd_description = $wpdb->escape($_POST['description']);
				if ($cd_rid != "" && $cd_name != "") {
					$iquery = "UPDATE cd_ad_sponsor_revenue SET rid='$cd_rid',name='$cd_name', description='$cd_description',rate='$cd_rate' WHERE rev_id=$cd_revid";
					$result = $wpdb->query($iquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Revenue Type &quot;'.$cd_name.'&quot; updated.</p></div>';
						cd_ad_revenue_render();
						break;
					} elseif ($result == 0 ) {
						echo '<div id="message" class="updated fade"><p>No Update required.</p></div>';
						cd_ad_revenue_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error editing Revenue Type.</p></div>';
						cd_ad_revenue_render();
					}
				} else {
					echo '<div id="message" class="error fade"><p>Revenue Type and Name are Required.</p></div>';
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_revenue WHERE rev_id='$cd_revid'");
				$cd_rid = stripslashes($result->rid);
				$cd_rate = stripslashes($result->rate);
				$cd_name = stripslashes($result->name);
				$cd_description = stripslashes($result->description);
			}
			echo '<h3>'.__('Edit Revenue Type', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the Revenue Type. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="c" id="editrevenue">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="rid">Revenue ID<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="editrevenue" />
			<input name="op" type="hidden" id="op" value="edit" />
			<input name="revid" type="hidden" id="revid" value="'.$cd_revid.'" /></th>';

			echo '<td><input name="rid" type="text" id="rid" value="'.$cd_rid.'" style="width:50px;" /><br /><span class="description">Enter the Revenue ID.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="name">Revenue Type Name<sup class="req">*</sup></label></th>
		<td><input name="name" type="text" id="name" value="'.$cd_name.'" style="width:50px;" /><br /><span class="description">Enter the 3-character Name of this Revenue Type.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="description">Description</label></th>
		<td><input name="description" type="text" id="description" value="'.$cd_description.'" style="width:400px;" /><br /><span class="description">Enter the Description of this Revenue Type.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="rate">Rate</label></th>
		<td><input name="rate" type="text" id="rate" value="'.$cd_rate.'" style="width:100px;" /><br /><span class="description">Enter the Rate for this Revenue Type.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="editrevenue" type="submit" id="editrevenue" class="button" value="Save Changes" />
			</p></form>';
			break;

		default:
			cd_ad_revenue_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}

function cd_ad_revenue_render() {
	global $wpdb,$blog_id;
	ob_start();
	echo '<p>The following table lists all currently defined Revenue Types.</p>';
	echo '<div class="submit">
	<a class="button" href="admin.php?page=cd_ad_revenue_menu&op=add" title="Add Revenue Type">Add Revenue Type</a></div>'."\n";
	echo '<div class="cd_render">';
	echo '<table class="widefat" width="99%">
	<colgroup><col width="15%"><colgroup><col width="20%"><colgroup><col width="55%"><colgroup><col width="10%" align="char" char="."><thead><tr>
	<th scope="col">'.__('Revenue ID', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Name', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Description', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Rate', 'cd_ad_sponsor').'</th>
	</tr></thead>
	<tbody>';
	$cd_revenue_list = $wpdb->get_results("SELECT * FROM cd_ad_sponsor_revenue ORDER BY rid,name ASC", OBJECT);
	if ($cd_revenue_list) {
		foreach($cd_revenue_list as $result) {
			echo '<tr>';
			echo '<td><a href="admin.php?page=cd_ad_revenue_menu&op=edit&revid='.$result->rev_id.'" title="Edit Revenue '.$result->name.' details.">'.$result->rid.'</a></td>';
			echo '<td>'.stripslashes($result->name).'</td>';
			echo '<td>'.stripslashes($result->description).'</td>';
			echo '<td style="text-align:right;">'.stripslashes($result->rate).'</td>';
			echo '</tr>'."\n";
		}
	} else {
		echo '<tr><td colspan="4"><b>No Revenue Types Found.</b></td>';
	}
	echo '</tbody></table></div><br />';

	echo '<div style="border-top:1px solid #E0E0FF;"><p>Revenue Types describe the monetary method of an ad. You  sell ad spots to sponsors based on a revenue type, such as CPC (Cost Per Click), CPM (Cost Per 1000 Impressions), etc. You should specify the rate you charge your sponsors for the specific Revenue Type you create. For example, you may charge $0.05 per click for a CPC Revenue Type, or $10.00 per day for a CPD Revenue Type. Revenue Type Rates are used to calculate sponsor billing amounts as shown on the Banner Reports page.</p>
	<p>The Revenue Type, CPD (Cost Per Day), is used to denote an exclusive Sponsor Ad. That is, a CPD ad is selected before any other ad with a different revenue type. It is recommended that you define a CPD revenue type so that a quaified sponsor ad is permanently placed for the duration of the corresponding schedule.</p>
	<p><b>Note:</b> If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Revenue IDs apply across all blogs. </p>';
	cd_ad_admin_footer();
	echo '</div>';

}

?>
