<?php

if (!is_admin()) {
	die ("Unauthorized.");
}

$cd_js = cd_get_plugin_dir()."/cd_ad_sponsor/js";
$cd_css = cd_get_plugin_dir()."/cd_ad_sponsor/css";

wp_register_script('cd_ad_schedule', $cd_js . '/cd_ad_schedule.js', array('jquery'));
wp_register_script('jquery.datepick.pack', $cd_js . '/jquery.datepick.pack.js', array('jquery'));
wp_enqueue_script('cd_ad_schedule',$cd_js."/cd_ad_schedule.js");
wp_enqueue_script('jquery.datepick.pack',$cd_js."/jquery.datepick.pack.js");

wp_register_style('redmond.datepick', $cd_css . '/redmond.datepick.css');
wp_enqueue_style('redmond.datepick',$cd_css."/redmond.datepick.css");

add_action('wp_ajax_cd_ajax_schedule', 'cd_ajax_schedule');


function cd_ad_make_schedules_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['cid']) ) {
		$cd_cid = (int)$_REQUEST['cid'];
	} else {
		$cd_cid = 0;
	}
	$op = $_GET['op'];

	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Ad Schedules', 'cd_ad_sponsor').'</h2>';

	switch ($op) {
		case "add":
			if ($_POST['action'] == "addschedule") {
				$cd_sid = $wpdb->escape($_POST['csid']);
				//$cd_pid = $wpdb->escape($_POST['cpid']);
				$cd_startdate = $wpdb->escape($_POST['startdate']);
				$cd_enddate = $wpdb->escape($_POST['enddate']);
				$cd_bid = $wpdb->escape($_POST['cbid']);
				$cd_pid = $wpdb->get_var("SELECT pid FROM cd_ad_sponsor_banners WHERE bid = $cd_bid");
				if ($cd_sid >= "1" && $cd_bid >= "1" && $cd_startdate != "" && $cd_startdate != "") {
					$bquery = "INSERT INTO cd_ad_sponsor_schedule (cid,sid,blog_id,bid,pid,impressions,startdate,enddate,sent) VALUES (null,'$cd_sid','$blog_id','$cd_bid','$cd_pid','0','$cd_startdate','$cd_enddate','0')";
					$result = $wpdb->query($bquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Banner Ad Schedule created.</p></div>';
						cd_ad_schedule_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error creating banner ad schedule.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Sponsor, Banner, and Start and End Dates are Required.</p></div>';
				}
			}
			echo '<h3>'.__('Add Schedule', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to create a new banner ad schedule. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="addschedule" id="addschedule">';
			echo '<table class="form-table">';
			echo '<tr class="form-field"><th scope="row"><label for="csid">Sponsor Name<sup class="req">*</sup></label></th>';
			echo '<td><select id="csid" name="csid" style="width:200px;" />';
			$result = cd_get_sponsor_select($cd_sid);
			if ($result == false) {
				$savestatus = 'disabled';
				echo '<option value="">None Defined</option>';
			} else {
				echo $result;
			}
			echo '</select>';
			echo '<br /><span class="description">';
			if ($result == false) {
				echo '<b>You must first define a Sponsor.</b>';
			} else {
				echo 'Select the sponsor to assign to this schedule.';
			}
			echo '</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="cbid">Banner Ad Program<sup class="req">*</sup></label></th>';
			echo '<td><select name="cbid" id="cbid" style="width:300px;">';
			echo '<option>* Select Sponsor First *</option>';
			echo '</select><span id="cd_loader"></span>';
			echo '<br /><span class="description">Select the Banner Ad to assign to this schedule.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="startdate">Start Date<sup class="req">*</sup></label></th>';
			echo '<td><input name="startdate" type="text" id="startdate" value="'.$cd_startdate.'" style="width:120px;" />';
			echo '<br /><span class="description">Select the Start Date of this ad schedule.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="enddate">End Date<sup class="req">*</sup></label></th>';
			echo '<td><input name="enddate" type="text" id="enddate" value="'.$cd_enddate.'" style="width:120px;" />';
			echo '<br /><span class="description">Select the End Date of this ad schedule.</span></td></tr>'."\n";
			echo '</table>
			<p class="submit">
			<input name="plugin_uri" type="hidden" id="plugin_uri" value="'.cd_get_plugin_dir().'" />
			<input name="site_uri" type="hidden" id="site_uri" value="'.get_bloginfo('wpurl').'" />
			<input name="action" type="hidden" id="action" value="addschedule" />
			<input name="op" type="hidden" id="op" value="add" />
			<input name="addschedule" type="submit" id="addschedule" class="button" value="Save Changes" '.$savestatus.' />
			</p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editschedule") {
				$cd_sid = $wpdb->escape($_POST['csid']);
				$cd_startdate = $wpdb->escape($_POST['startdate']);
				$cd_enddate = $wpdb->escape($_POST['enddate']);
				$cd_bid = $wpdb->escape($_POST['bid']);
				$cd_pid = $wpdb->get_var("SELECT pid FROM cd_ad_sponsor_banners WHERE bid = $cd_bid");
				$cd_exp = $wpdb->get_results("SELECT sent,enddate FROM cd_ad_sponsor_schedules WHERE cid=$cd_cid");
				$bquery = "UPDATE cd_ad_sponsor_schedule SET bid='$cd_bid',pid='$cd_pid',startdate='$cd_startdate',enddate='$cd_enddate'";
				if ($cd_exp->sent == 1) {
					if ($cd_enddate > $cd_exp->enddate) {
						// reset email notice if later end date
						$bquery .= ",sent='0'";
					}
				}
				$bquery .= " WHERE cid='$cd_cid'";
				if ($cd_sid >= "1" && $cd_bid >= "1" && $cd_startdate != "" && $cd_startdate != "") {
					$result = $wpdb->query($bquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Banner Ad Schedule updated.</p></div>';
						cd_ad_schedule_render();
						break;
					} elseif ( $result == 0 ) {
						echo '<div id="message" class="updated fade"><p>No update required.</p></div>';
						cd_ad_schedule_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error updating Banner Ad Schedule.</p></div>';
					}
				} else {
					echo '<div id="message" class="error fade"><p>Banner, Start and End Dates are Required.</p></div>';
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_schedule WHERE cid=$cd_cid");
				$cd_sid = stripslashes($result->sid);
				$cd_pid = stripslashes($result->pid);
				$cd_bid = stripslashes($result->bid);
				$cd_startdate = stripslashes($result->startdate);
				$cd_enddate = stripslashes($result->enddate);
			}
			$cd_sponsor_name=$wpdb->get_var("SELECT name FROM cd_ad_sponsor WHERE sid=$cd_sid");
			echo '<h3>'.__('Edit Schedule', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the banner ad schedule details for <b><i>'.$cd_sponsor_name.'</i></b>. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="editschedule" id="editschedule">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="cpid">Banner Ad<sup class="req">*</sup></label></th>';
			echo '<td><select name="bid" id="bid" style="width:300px;">';
			echo cd_get_schedule_select($cd_sid,$cd_bid);
			echo '</select>';
			echo '<br /><span class="description">Select the Banner Ad to assign to this schedule.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="startdate">Start Date<sup class="req">*</sup></label></th>';
			echo '<td><input name="startdate" type="text" id="startdate" value="'.$cd_startdate.'" style="width:120px;" />';
			echo '<br /><span class="description">Select the Start Date of this schedule.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="enddate">End Date<sup class="req">*</sup></label></th>';
			echo '<td><input name="enddate" type="text" id="enddate" value="'.$cd_enddate.'" style="width:120px;" />';
			echo '<br /><span class="description">Select the End Date of this schedule.</span></td></tr>'."\n";
			echo '</table>
			<p class="submit">
			<input name="plugin_uri" type="hidden" id="plugin_uri" value="'.cd_get_plugin_dir().'" />
			<input name="site_uri" type="hidden" id="site_uri" value="'.get_bloginfo('wpurl').'" />
			<input name="action" type="hidden" id="action" value="editschedule" />
			<input name="op" type="hidden" id="op" value="edit" />
			<input name="csid" type="hidden" id="csid" value="'.$cd_sid.'" />
			<input name="cid" type="hidden" id="cid" value="'.$cd_cid.'" />
			<input name="editschedule" type="submit" id="editschedule" class="button" value="Save Changes" '.$savestatus.' />
			</p></form>';

			break;

		default:
			cd_ad_schedule_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}


function cd_ad_schedule_render() {
	global $wpdb,$blog_id;
	ob_start();
	echo '<p>The following table lists all ad schedules for blog, <b><i>';
	echo bloginfo('name');
	echo '</i></b>, grouped by sponsor and sorted by earliest end date.</p>';
	echo '<div class="submit">
<a class="button" href="admin.php?page=cd_ad_schedules_menu&op=add" title="Add Sponsor Schedule">Add Sponsor Schedule
</a></div>'."\n";
	echo '<div class="cd_render">';
	echo '<table class="widefat">
	<thead><tr>
	<th scope="col">'.__('Site', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Program', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Zone', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Start Date', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('End Date', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Clicks', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Impressions', 'cd_ad_sponsor').'</th>
	</tr></thead>
	<tbody>';

	$cd_sponsors = $wpdb->get_results("SELECT sid,name FROM cd_ad_sponsor ORDER BY name ASC",OBJECT);
	if (!empty($cd_sponsors)) {
		foreach ($cd_sponsors as $sponsor) {
			$row_id='row'.$sponsor->sid;
			echo '<tr style="background-color:#FDFFBB;" class="parent" id="'.$row_id.'"><td colspan="7" style="font-size:12px;"><b><i>'.$sponsor->name.'</i></b></td></tr>';
		$squery = "SELECT cid,bid,pid,impressions,startdate,enddate FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id AND sid=$sponsor->sid ORDER BY sid,enddate ASC";
			$cd_schedule = $wpdb->get_results($squery, OBJECT);
			if (!empty($cd_schedule)) {
				$cd_date = date("Y-m-d H:i:s");
				foreach($cd_schedule as $schedule) {
					if (( $cd_date >= $schedule->startdate ) && ( $cd_date <= $schedule->enddate )) {
						echo '<tr style="background-color:#F0FFF0;" class="child-'.$row_id.'">';
					} elseif ($cd_date <= $schedule->startdate) {
						echo '<tr style="background-color:#F0F0FF;" class="child-'.$row_id.'">';
					} elseif ($cd_date >= $schedule->enddate) {
						echo '<tr style="background-color:#FFF0F0;" class="child-'.$row_id.'">';
					} else {
						echo '<tr class="child-'.$row_id.'">';
					}
					$banner = $wpdb->get_results("SELECT zone_id,name,b_url FROM cd_ad_sponsor_banners WHERE bid=$schedule->bid AND blog_id=$blog_id",OBJECT);
					$z_id = $banner[0]->zone_id;
					echo '<td><a href="admin.php?page=cd_ad_schedules_menu&op=edit&cid='.$schedule->cid.'">'.$banner[0]->name.'<div style="height:30px;width:auto;"><img src="'.$banner[0]->b_url.'" height="30px" width="auto" /></div></a></td>';
					$program = $wpdb->get_var("SELECT concat_ws(' - ',name,type,description) AS txt FROM cd_ad_sponsor_program WHERE pid=$schedule->pid");
					echo '<td>'.$program.'</td>';
					$zone = $wpdb->get_var("SELECT zone FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id AND zid=$z_id");
					echo '<td>'.$zone.'</td>';
					echo '<td>'.$schedule->startdate.'</td>';
					echo '<td>'.$schedule->enddate.'</td>';
					echo '<td class="num">'.$wpdb->get_var("SELECT Count(mid) as clicks FROM cd_ad_sponsor_clickthrough WHERE cid=$schedule->cid").'</td>';
					echo '<td class="num">'.$schedule->impressions.'</td>';
					echo '</tr>'."\n";
				}
			} else {
				echo '<tr><td colspan="7"><b>No Ad Schedules Found.</b></td></tr>';
			}
		}
	} else {
		echo '<tr><td colspan="7"><b>No Ad Schedules Found.</b></td></tr>';
	}
	echo '</tbody></table></div>'."\n";
	echo '<p>Legend: <span style="background-color:#FFF0F0;padding:4px;">Expired</span>&nbsp;<span style="background-color:#E0FFE0;padding:4px;">Running</span>&nbsp;<span style="background-color:#F0F0FF;padding:4px;">Scheduled</span></p>';
	echo '<div style="border-top:1px solid #E0E0FF;"><p>Ad Schedules allow you to specify the Sponsor Ads displayed at a particluar location (or zone) within a specified time frame. The Sponsor Ads displayed are the result of your prior definitions for the program and revenue type. The Clickthrugh and Impressions column indicate the total counts during the scheduled time period.</p>
	<p><b>Note:</b> If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Ad Schedules you define are specific to each blog. </p>';
	cd_ad_admin_footer();
	echo '</div>';

}

?>