<?php
/*
Plugin Name: Ad Sponsor
Plugin URI: http://coyotesdesigns.com/sponsor-ad-management/
Description: Easily manage sponsor ads within your WordPress Dashboard.
Author: Coyote
Author URI: http://coyotesdesigns.com
Version: 1.3.0
*/

/*  Copyright 2008-2009  coyote  (email : info@coyotesdesigns.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


global $wpdb,$blog_id;

//Make Admin Menu Structure
if ( is_admin() ) {
	//Register Ad Sponsor DB Install
	function cd_ad_sponsor_installer () {
		require_once(dirname(__FILE__).'/cd_ad_sponsor_install.php');
		cd_ad_sponsor_install();
	}
	register_activation_hook(__FILE__,'cd_ad_sponsor_installer');

	function cd_ad_sponsor_deactivate() {
		delete_option('cd_ad_sponsor_db_version');
	}
	register_deactivation_hook(__FILE__,'cd_ad_sponsor_deactivate');

	function cd_make_admin_menu() {
		add_menu_page(
			__("Ad Sponsors", 'cd_ad_sponsor'),
			__("Ad Sponsors", 'cd_ad_sponsor'),
			10,
			__FILE__,
			"cd_ad_make_management_menu",
			cd_get_plugin_dir()."/cd_ad_sponsor/images/cd_ad.png"
		);
		add_submenu_page(
			__FILE__,
			__("Manage Sponsors", 'cd_ad_sponsor'),
			__("Manage Sponsors", 'cd_ad_sponsor'),
			10,
			__FILE__,
			"cd_ad_make_management_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Programs", 'cd_ad_sponsor'),
			__("Manage Programs", 'cd_ad_sponsor'),
			10,
			"cd_ad_programs_menu",
			"cd_ad_make_programs_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Revenue", 'cd_ad_sponsor'),
			__("Manage Revenue", 'cd_ad_sponsor'),
			10,
			"cd_ad_revenue_menu",
			"cd_ad_make_revenue_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Zones", 'cd_ad_sponsor'),
			__("Manage Zones", 'cd_ad_sponsor'),
			10,
			"cd_ad_zone_menu",
			"cd_ad_make_zone_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Banners", 'cd_ad_sponsor'),
			__("Manage Banners", 'cd_ad_sponsor'),
			10,
			"cd_ads_menu",
			"cd_ad_make_ads_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Schedules", 'cd_ad_sponsor'),
			__("Manage Schedules", 'cd_ad_sponsor'),
			10,
			"cd_ad_schedules_menu",
			"cd_ad_make_schedules_menu");
		add_submenu_page(
			__FILE__,
			__("Manage Reports", 'cd_ad_sponsor'),
			__("Manage Reports", 'cd_ad_sponsor'),
			10,
			"cd_ad_reports_menu",
			"cd_ad_make_reports_menu");
		add_submenu_page(
			__FILE__,
			__("Default Options", 'cd_ad_sponsor'),
			__("Default Options", 'cd_ad_sponsor'),
			10,
			"cd_ad_options_menu",
			"cd_ad_make_options_menu");
		add_submenu_page(
			__FILE__,
			__("Excluded IPs", 'cd_ad_sponsor'),
			__("Excluded IPs", 'cd_ad_sponsor'),
			10,
			"cd_ad_excluded_menu",
			"cd_ad_make_excluded_menu");
		add_submenu_page(
			__FILE__,
			__("Uninstall", 'cd_ad_sponsor'),
			__("Uninstall", 'cd_ad_sponsor'),
			10,
			"cd_ad_sponsor/cd_ad_sponsor_uninstall.php");
	}


	function cd_ad_sponsor_dashboard_widget() {
		global $wpdb,$blog_id;
		ob_start();
		$cd_ad_sponsors_count = $wpdb->get_var("SELECT Count(sid) as sponsors FROM cd_ad_sponsor");
		$cd_ad_program_count = $wpdb->get_var("SELECT Count(pid) as programs FROM cd_ad_sponsor_program");
		$cd_ad_banner_count = $wpdb->get_var("SELECT Count(bid) as banners FROM cd_ad_sponsor_banners");
		$cd_ad_schedule_count = $wpdb->get_var("SELECT Count(cid) as ads FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id");
		$cd_ad_clicks_count = $wpdb->get_var("SELECT Count(mid) as clicks FROM cd_ad_sponsor_clickthrough WHERE blog_id=$blog_id");
		$cd_ad_impressions_count = $wpdb->get_var("SELECT Sum(impressions) FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id");
		$cd_ad_running_count = $wpdb->get_var("SELECT Count(cid) as running FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id AND (now()>=startdate AND now()<=enddate)");
		$cd_ad_pending_count = $wpdb->get_var("SELECT Count(cid) as pending FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id AND now()<=startdate");
		$cd_ad_expired_count = $wpdb->get_var("SELECT Count(cid) as expired FROM cd_ad_sponsor_schedule WHERE blog_id=$blog_id AND now()>=enddate");
		$cd_ad_excluded_count = $wpdb->get_var("SELECT Count(excludeIP) as excluded FROM cd_ad_sponsor_excluded");

		echo '<p class="sub">Overview</p><div class="table"><table>';
		echo '<tr class="first"><td class="first b"><a href="admin.php?page=cd_ad_sponsor/cd_ad_sponsor.php">'.$cd_ad_sponsors_count.'</a></td><td class="t"><a href="admin.php?page=cd_ad_sponsor/cd_ad_sponsor.php">Sponsors</a></td><td class="b">'.number_format($cd_ad_clicks_count).'</td><td class="last t">Clickthroughs</td></tr>';
		echo '<tr><td class="first b"><a href="admin.php?page=cd_ad_programs_menu">'.$cd_ad_program_count.'</a></td><td class="t"><a href="admin.php?page=cd_ad_programs_menu">Program Types</a></td><td class="b">'.number_format($cd_ad_impressions_count).'</td><td class="last t">Impressions</td></tr>';
		echo '<tr><td class="first b"><a href="admin.php?page=cd_ads_menu">'.number_format($cd_ad_banner_count).'</a></td><td class="t"><a href="admin.php?page=cd_ads_menu">Banner Ads</a></td><td class="b">'.number_format($cd_ad_running_count).'</td><td class="last t"><span class="running">Ads Running</span></td></tr>';
		echo '<tr><td class="first b"><a href="admin.php?page=cd_ad_schedules_menu">'.$cd_ad_schedule_count.'</a></td><td class="t"><a href="admin.php?page=cd_ad_schedules_menu">Schedules</a></td><td class="b">'.number_format($cd_ad_pending_count).'</td><td class="last t"><span class="pending">Ads Pending</span></td></tr>';
	echo '<tr><td class="first b"><a href="admin.php?page=cd_ad_excluded_menu">'.$cd_ad_excluded_count.'</a></td><td class="t"><a href="admin.php?page=cd_ad_excluded_menu">Excluded IPs</a></td><td class="b">'.number_format($cd_ad_expired_count).'</td><td class="last t"><span class="expired">Ads Expired</span></td></tr>';
		echo '</table></div>';
		cd_ad_admin_footer();
	}


	function cd_ad_sponsor_dashboard_add_widget() {
		if (current_user_can('install_plugins')) {
		if (function_exists('wp_add_dashboard_widget')) {
			wp_add_dashboard_widget('cd_ad_sponsor', __('Ad Sponsors v1.3.0', 'cd_ad_sponsor'), 'cd_ad_sponsor_dashboard_widget');
			}
		}
	}


//Include ad sponsor management menus
	require_once(dirname(__FILE__).'/cd_ad_sponsor_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_program_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_banner_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_schedule_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_zone_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_revenue_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_options_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_excluded_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_reports_menus.php');
	require_once(dirname(__FILE__).'/cd_ad_admin_functions.php');
	add_action('admin_menu', 'cd_make_admin_menu');
	add_action('admin_menu', 'register_cd_ad_settings' );
	add_action('wp_dashboard_setup', 'cd_ad_sponsor_dashboard_add_widget' );
}

function cd_get_plugin_dir() {
	if(!defined('WP_CONTENT_URL')) {
		define( 'WP_CONTENT_URL', get_option('siteurl').plugin_basename(dirname(__FILE__)));
	}
	return WP_CONTENT_URL.'/plugins';
}

$cd_css = cd_get_plugin_dir()."/cd_ad_sponsor/css";

wp_register_style('cd_ad_sponsor', $cd_css . '/cd_ad_sponsor.css');
wp_enqueue_style('cd_ad_sponsor',$cd_css."/cd_ad_sponsor.css");


remove_filter('the_content', 'wptexturize');
remove_filter('the_excerpt', 'wptexturize');
remove_filter('comment_text', 'wptexturize');

require_once(dirname(__FILE__).'/cd_ad_functions.php');


?>
