<?php

if (!is_admin()) {
	die ("Unauthorized.");
}
require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

global $cd_ad_sponsor_db_version;
$cd_ad_sponsor_db_version = "1.860";

function cd_ad_sponsor_install() {
	global $wpdb,$blog_id;
	global $cd_ad_sponsor_db_version;

	if ( get_option('cd_ad_sponsor_db_version') != $cd_ad_sponsor_db_version ) {

		add_option('cd_ad_sponsor_db_version', '0');
/*
		$cd_ad_sponsor_table = "cd_ad_sponsor";
		$cd_ad_sponsor_banners_table = "cd_ad_sponsor_banners";
		$cd_ad_sponsor_clickthrough_table = "cd_ad_sponsor_clickthrough";
		$cd_ad_sponsor_excluded_table = "cd_ad_sponsor_excluded";
		$cd_ad_sponsor_program_table = "cd_ad_sponsor_program";
		$cd_ad_sponsor_reports_table = "cd_ad_sponsor_reports";
		$cd_ad_sponsor_revenue_table = "cd_ad_sponsor_revenue";
		$cd_ad_sponsor_rotation_table = "cd_ad_sponsor_rotation";
		$cd_ad_sponsor_schedule_table = "cd_ad_sponsor_schedule";
		$cd_ad_sponsor_zones_table = "cd_ad_sponsor_zones";
*/

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor (
			sid int(11) NOT NULL AUTO_INCREMENT,
			`name` varchar(64) NOT NULL COMMENT 'Sponsor Name',
			`user` varchar(32) NOT NULL COMMENT 'Login user name for sponsor.',
			`password` varchar(14) NOT NULL COMMENT 'Login password for sponsor.',
			affiliate varchar(32) NOT NULL COMMENT 'Sponsor-assigned affiliate ID. CCBill, NATS, etc.',
			wmlink text NOT NULL COMMENT 'Webmaster login URL of sponsor.',
			wmref_url text NOT NULL COMMENT 'Webmaster referral URL for sponsor.',
			wmref_banner text NOT NULL COMMENT 'Referral Banner Link',
			docs_2257 text NOT NULL COMMENT 'Compliance Documentation URL',
			wm_email text NOT NULL COMMENT 'Webmater support email.',
			wmref_icq varchar(14) NOT NULL COMMENT 'Webmaster support ICQ.',
			PRIMARY KEY  (sid)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor listing';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_banners (
			bid int(11) NOT NULL AUTO_INCREMENT COMMENT 'Banner ID',
			sid int(11) NOT NULL COMMENT 'Sponsor ID',
			cid text NOT NULL COMMENT 'Category IDs for this banner',
			pid int(11) NOT NULL COMMENT 'Program ID',
			blog_id int(11) NOT NULL COMMENT 'Blog ID if WPMU, otherwise 0',
			rev_id int(11) NOT NULL COMMENT 'Revenue Type Index.',
			zone_id int(11) NOT NULL COMMENT 'Zone ID Index.',
			`name` text NOT NULL COMMENT 'Sponsor site name associated with this banner.',
			link text COMMENT 'Sponsor site banner link.',
			b_url text COMMENT 'Site or sponsor-hosted banner URL.',
			alt text COMMENT 'Banner image ALT tag and link title tag',
			s_link text COMMENT 'Script-based Ad',
			PRIMARY KEY  (bid),
			KEY sid (sid),
			KEY blog_id (blog_id),
			KEY rev_id (rev_id),
			KEY zone_id (zone_id)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor banners';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_clickthrough (
			mid int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clickthrough ID',
			cid int(11) NOT NULL COMMENT 'Schedule ID',
			blog_id int(11) NOT NULL COMMENT 'Blog ID if WPMU, otherwise 0',
			`timestamp` datetime NOT NULL COMMENT 'Date time of clickthrough.',
			visitorIP varchar(15) NOT NULL COMMENT 'Source IP address.',
			PRIMARY KEY  (mid),
			KEY `timestamp` (`timestamp`),
			KEY visitorIP (visitorIP),
			KEY blog_id (blog_id),
			KEY cid (cid)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor Ad clickthrough';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_excluded (
			aid int(11) NOT NULL AUTO_INCREMENT COMMENT 'Excluded IP Index.',
			excludeIP varchar(15) NOT NULL COMMENT 'Excluded address from Stats.',
			blog_id int(11) NOT NULL COMMENT 'Blog ID if WPMU, otherwise 0',
			description text NOT NULL COMMENT 'Excluded IP Description.',
			PRIMARY KEY  (aid),
			KEY blog_id (blog_id),
			KEY excludeIP (excludeIP)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Excluded IPs from counts';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_program (
			pid int(11) NOT NULL AUTO_INCREMENT,
			sid int(11) NOT NULL COMMENT 'Sponsor associated with this program',
			site varchar(32) NOT NULL COMMENT 'Site Name',
			`type` varchar(32) NOT NULL COMMENT 'Program Type, PPS, REV, etc.',
			`name` text NOT NULL COMMENT 'Program type name.',
			description text NOT NULL COMMENT 'Program type descripton.',
			PRIMARY KEY  (pid),
			KEY sid (sid)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor Program Types';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_reports (
			rid int(11) NOT NULL auto_increment COMMENT 'Report ID',
			sid int(11) NOT NULL COMMENT 'Sponsor ID',
			reportname varchar(128) NOT NULL,
			startdate datetime NOT NULL COMMENT 'Report Start Date',
			enddate datetime NOT NULL COMMENT 'Report End Date',
			reportdata text COMMENT 'Report Data',
			created datetime NOT NULL COMMENT 'Date Report Created',
			sent datetime default NULL COMMENT 'Date Report Sent',
			PRIMARY KEY  (rid),
			KEY sid (sid,startdate,enddate),
			KEY created (created,sent)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor Ad Reports';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_revenue (
			rev_id int(11) NOT NULL auto_increment COMMENT 'Revene Type Index',
			rid int(11) NOT NULL COMMENT 'Revenue Type ID',
			`name` varchar(64) NOT NULL COMMENT 'Revenue Type name',
			description text NOT NULL COMMENT 'Revenue Type description.',
			rate decimal(10,2) NOT NULL default '0.00',
			PRIMARY KEY  (rev_id),
			KEY rid (rid)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Revenue Types';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="INSERT INTO cd_ad_sponsor_revenue (rev_id, rid, name, description,rate) VALUES
			(1, 1, 'CPD', 'Cost Per Day', 0.00),
			(2, 2, 'CPC', 'Cost Per Click', 0.00),
			(3, 3, 'CPM', 'Cost Per 1000 Impressions', 0.00),
			(4, 4, 'OPEN', 'Open Revenue Type', 0.00),
			(5, 5, 'REF', 'Webmaster Referral', 0.00);";
		$wpdb->query($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_rotation (
			zid int(11) NOT NULL COMMENT 'Zone ID for rotation',
			bid int(11) NOT NULL COMMENT 'Banner ID used in rotation',
			blog_id int(11) NOT NULL COMMENT 'Blog Id of ad in rotation',
			KEY zid (zid),
			KEY bid (bid),
			KEY blog_id (blog_id)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Sponsor Ad rotation listing';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_schedule (
			cid int(11) NOT NULL AUTO_INCREMENT COMMENT 'Schedule Index',
			sid int(11) NOT NULL COMMENT 'Sponsor ID',
			blog_id int(11) NOT NULL COMMENT 'Blog ID if WPMU, otherwise 0',
			bid int(11) NOT NULL COMMENT 'Banner index ID',
			pid int(11) NOT NULL COMMENT 'Program ID',
			impressions int(11) NOT NULL DEFAULT '0' COMMENT 'Sponsor Ad Impression count',
			startdate datetime NOT NULL COMMENT 'Ad Start Date',
			enddate datetime NOT NULL COMMENT 'Ad End Date',
			sent tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Expiration Notice sent',
			PRIMARY KEY  (cid),
			KEY sid (sid),
			KEY startdate (startdate),
			KEY enddate (enddate),
			KEY blog_id (blog_id),
			KEY bid (bid),
			KEY pid (pid),
			KEY sent (sent)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Sponsor Ad Scheduling';";
			dbDelta($cd_ad_sql);

		$cd_ad_sql="CREATE TABLE cd_ad_sponsor_zones (
			zone_id int(11) NOT NULL AUTO_INCREMENT,
			zid int(11) NOT NULL COMMENT 'Zone ID',
			blog_id int(11) NOT NULL COMMENT 'Blog ID',
			`rows` int(2) NOT NULL DEFAULT '1' COMMENT 'Number of rows in this zone.',
			cols int(2) NOT NULL DEFAULT '1' COMMENT 'Number of columns in this zone.',
			freq int(2) NOT NULL DEFAULT '0' COMMENT 'Freqency at which Ads are inserted.',
			zone varchar(24) NOT NULL COMMENT 'Zone Name',
			description varchar(255) NOT NULL COMMENT 'Zone description.',
			def_ad text NOT NULL COMMENT 'Default Ad Placeholder URL.',
			PRIMARY KEY  (zone_id),
			KEY zid (zid),
			KEY blog_id (blog_id),
			KEY `rows` (`rows`),
			KEY cols (cols),
			KEY freq (freq),
			KEY zone (zone)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Blog Ad Zones';";
			dbDelta($cd_ad_sql);

		update_option("cd_ad_sponsor_db_version", $cd_ad_sponsor_db_version);
	}
}
?>