<?php

if (!is_admin()) {
	die ("Unauthorized.");
}


function cd_ad_make_zone_menu() {
	global $wpdb,$blog_id;
	ob_start();
	if ( isset($_REQUEST['zoneid']) && $_REQUEST['zoneid'] ) {
		$cd_zone_id = (int)$_REQUEST['zoneid'];
	} else {
		$cd_zone_id = 0;
	}
	$op = $_GET['op'];
	echo '<div class="wrap">
	<div class="icon32"><img src="'.cd_get_plugin_dir().'/cd_ad_sponsor/images/cd_ad_32.png" width="30px" height="31px" border="0" /></div>
	<h2>'.__('Manage Ad Zones', 'cd_ad_sponsor').'</h2>';

	switch ($op) {
		case "add":
			if ($_POST['action'] == "addzone") {
				$cd_zone = $wpdb->escape($_POST['zone']);
				$cd_rows = $wpdb->escape($_POST['rows']);
				$cd_cols = $wpdb->escape($_POST['cols']);
				$cd_freq = $wpdb->escape($_POST['freq']);
				$cd_zid = $wpdb->escape($_POST['zid']);
				$cd_description = $wpdb->escape($_POST['description']);
				$cd_default = $wpdb->escape($_POST['default']);
				if ($cd_rows == "" || $cd_rows <= '0') { $cd_rows='1'; }
				if ($cd_cols == "" || $cd_cols <= '0') { $cd_cols='1'; }
				if ($cd_freq == "" || $cd_freq <= '0') { $cd_freq='0'; }
				if ($cd_zid != "" && $cd_zone != "") {
					$iquery = "INSERT INTO cd_ad_sponsor_zones (zid,blog_id,rows,cols,freq,zone,description,def_ad) VALUES ($cd_zid,'$blog_id','$cd_rows','$cd_cols','$cd_freq','$cd_zone','$cd_description','$cd_default')";
					$result = $wpdb->query($iquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Zone &quot;'.$cd_zone.'&quot; created.</p></div>';
						cd_ad_zone_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error creating Zone.</p></div>';
						cd_ad_zone_render();
					}
				} else {
					echo '<div id="message" class="error fade"><p>Zone ID and Name are Required.</p></div>';
				}
			}
			echo '<h3>'.__('Add Zone', 'cd_ad_sponsor').'</h3>';
			echo '<p>Complete the following form to add a new Zone. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="addzone" id="addzone">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="zid">Zone ID<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="addzone" />
			<input name="op" type="hidden" id="op" value="add" /></th>';

			echo '<td><input name="zid" type="text" id="zid" value="'.$cd_zid.'" style="width:100px;" /><br /><span class="description">Enter a numeric Zone ID.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="zone">Zone Name<sup class="req">*</sup></label></th>
		<td><input name="zone" type="text" id="zone" value="'.$cd_zone.'" style="width:200px;" /><br /><span class="description">Enter the Name of this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="description">Description</label></th>
		<td><input name="description" type="text" id="description" value="'.$cd_description.'" style="width:400px;" /><br /><span class="description">Enter the Description of this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="rows">Number of Rows</label></th>
			<td><input name="rows" type="text" id="rows" value="1" style="width:40px;" />Default = 1<br /><span class="description">Enter the number of Rows for this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="cols">Number of Columns</label></th>
			<td><input name="cols" type="text" id="cols" value="1" style="width:40px;" />Default = 1<br /><span class="description">Enter the number of Columns for this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="freq">Ad Frequency</label></th>
			<td><input name="freq" type="text" id="freq" value="0" style="width:40px;" />Default = 0<br /><span class="description">Enter the Ad insertion Frequency for this Zone.<br /><b>Caution:</b> Only ONE Zone may have an Insertion Frequency greater than Zero (0).</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="default">Default Ad URL</label></th>
		<td><input name="default" type="text" id="default" value="'.$cd_default.'" style="width:400px;" /><br /><span class="description">Enter the Default placeholder Ad URL for ths Zone.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="addzone" type="submit" id="addzone" class="button" value="Save Changes" />
			</p></form>';
			break;

		case "edit":
			if ($_POST['action'] == "editzone") {
				$cd_zid = $wpdb->escape($_POST['zid']);
				$cd_rows = $wpdb->escape($_POST['rows']);
				$cd_cols = $wpdb->escape($_POST['cols']);
				$cd_freq = $wpdb->escape($_POST['freq']);
				$cd_zone = $wpdb->escape($_POST['zone']);
				$cd_description = $wpdb->escape($_POST['description']);
				$cd_default = $wpdb->escape($_POST['default']);
				if ($cd_rows == "" || $cd_rows <= '0') { $cd_rows='1'; }
				if ($cd_cols == "" || $cd_cols <= '0') { $cd_cols='1'; }
				if ($cd_freq == "" || $cd_freq <= '0') { $cd_freq='0'; }
				if ($cd_zid != "" && $cd_zone != "") {
					$iquery = "UPDATE cd_ad_sponsor_zones SET zid='$cd_zid',rows='$cd_rows',cols='$cd_cols',freq='$cd_freq',zone='$cd_zone', description='$cd_description', def_ad='$cd_default' WHERE zone_id=$cd_zone_id";
					$result = $wpdb->query($iquery);
					if ($result == 1) {
						echo '<div id="message" class="updated fade"><p>Zone &quot;'.$cd_zone.'&quot; updated.</p></div>';
						cd_ad_zone_render();
						break;
					} elseif ($result == 0 ) {
						echo '<div id="message" class="updated fade"><p>No Update required.</p></div>';
						cd_ad_zone_render();
						break;
					} else {
						echo '<div id="message" class="error fade"><p>Error editing Zone.</p></div>';
						cd_ad_zone_render();
					}
				} else {
					echo '<div id="message" class="error fade"><p>Zone ID and Name are Required.</p></div>';
				}
			} else {
				$result = $wpdb->get_row("SELECT * FROM cd_ad_sponsor_zones WHERE zone_id='$cd_zone_id'");
				$cd_zid = stripslashes($result->zid);
				$cd_zone = stripslashes($result->zone);
				$cd_rows = stripslashes($result->rows);
				$cd_cols = stripslashes($result->cols);
				$cd_freq = stripslashes($result->freq);
				$cd_description = stripslashes($result->description);
				$cd_default = stripslashes($result->def_ad);
			}
			echo '<h3>'.__('Edit Zone', 'cd_ad_sponsor').'</h3>';
			echo '<p>Modify the following information to change the Zone. Fields marked <sup class="req">*</sup> are required.</p>';
			echo '<form action="" method="post" name="c" id="editzone">';
			echo '<table class="form-table">';
			echo '<tr class="form-field">
			<th scope="row"><label for="zone_id">Zone ID<sup class="req">*</sup></label>
			<input name="action" type="hidden" id="action" value="editzone" />
			<input name="op" type="hidden" id="op" value="edit" />
			<input name="zoneid" type="hidden" id="zoneid" value="'.$cd_zone_id.'" /></th>';

			echo '<td><input name="zid" type="text" id="zid" value="'.$cd_zid.'" style="width:100px;" /><br /><span class="description">Enter the Zone ID.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="zone">Zone Name<sup class="req">*</sup></label></th>
		<td><input name="zone" type="text" id="zone" value="'.$cd_zone.'" style="width:200px;" /><br /><span class="description">Enter the Name of this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="description">Description</label></th>
		<td><input name="description" type="text" id="description" value="'.$cd_description.'" style="width:400px;" /><br /><span class="description">Enter the Description of Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="rows">Number of Rows</label></th>
			<td><input name="rows" type="text" id="rows" value="'.$cd_rows.'" style="width:40px;" />Default = 1<br /><span class="description">Enter the number of Rows for this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="cols">Number of Columns</label></th>
			<td><input name="cols" type="text" id="cols" value="'.$cd_cols.'" style="width:40px;" />Default = 1<br /><span class="description">Enter the number of Columns for this Zone.</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="freq">Ad Frequency</label></th>
			<td><input name="freq" type="text" id="freq" value="'.$cd_freq.'" style="width:40px;" />Default = 0<br /><span class="description">Enter the Ad insertion Frequency for this Zone.<br /><b>Caution:</b> Only ONE Zone may have an Insertion Frequency greater than Zero (0).</span></td></tr>'."\n";

			echo '<tr class="form-field"><th scope="row"><label for="default">Default Ad URL</label></th>
		<td><input name="default" type="text" id="default" value="'.$cd_default.'" style="width:400px;" /><br /><span class="description">Enter the Default placeholder Ad URL for ths Zone.</span></td></tr>'."\n";

			echo '</table>
			<p class="submit">
			<input name="editzone" type="submit" id="editzone" class="button" value="Save Changes" />
			</p></form>';
			break;

		default:
			cd_ad_zone_render();
	}
	echo '<br /><div style="clear:both;"></div></div>'."\n";
}

function cd_ad_zone_render() {
	global $wpdb,$blog_id;
	ob_start();
	echo '<p>The following table lists all currently defined Ad Zones for blog, <b><i>';
	echo bloginfo('name').'</i></b>.</p>';
	echo '<div class="submit">
	<a class="button" href="admin.php?page=cd_ad_zone_menu&op=add" title="Add Zone">Add Zone</a></div>'."\n";
	echo '<div class="cd_render">';
	echo '<table class="widefat" width="99%">
	<thead><tr>
	<th scope="col">'.__('Zone ID', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Name', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Description', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Rows', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Cols', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Freq', 'cd_ad_sponsor').'</th>
	<th scope="col">'.__('Default Ad', 'cd_ad_sponsor').'</th>
	</tr></thead>
	<tbody>';
	$cd_zone_list = $wpdb->get_results("SELECT * FROM cd_ad_sponsor_zones WHERE blog_id=$blog_id ORDER BY zid,zone ASC", OBJECT);
	if ($cd_zone_list) {
		foreach($cd_zone_list as $result) {
			echo '<tr>';
			echo '<td><a href="admin.php?page=cd_ad_zone_menu&op=edit&zoneid='.$result->zone_id.'" title="Edit Zone '.$result->zone.' details.">'.$result->zid.'</a></td>';
			echo '<td>'.$result->zone.'</td>';
			echo '<td>'.stripslashes($result->description).'</td>';
			echo '<td>'.$result->rows.'</td>';
			echo '<td>'.$result->cols.'</td>';
			echo '<td>'.$result->freq.'</td>';
			echo '<td><div style="height:30px;width:auto;"><img src="'.stripslashes($result->def_ad).'" alt="'.stripslashes($result->def_ad).'" height="30px" width="auto" /></div></td>';
			echo '</tr>'."\n";
		}
	} else {
		echo '<tr colspan="7"><td><b>No Zones Found.</b></td>';
	}
	echo '</tbody></table></div><br />';

	echo '<div style="border-top:1px solid #E0E0FF;"><p>Zones define the location or position within your theme where qualified Ads are placed. You are not limited to the number of zones you can define, however, it is recommended that you only define the minimum zones necessary to present your ads as desired within the current theme.</p>
	<p>Each Zone you create may contain one or more Ads, as defined by the Rows and Cols parameters. The default is one row by one column which equates to placing a single Ad. In addition, you can define a frequency for a zone intended for embedding within post content. For Zones <b><i>not</i></b> intended to be embedded within a post should have the frequency set to zero (0). Only one Zone may have an Ad Frequency value greater than zero.</p>
	<p><b>Note:</b> If you are using WordPress<span style="font-size:12pt;">&#181;</span>, the Zone IDs apply to the currently active blog only. This means that each blog and theme will have unique zone definitions.</p>';
	cd_ad_admin_footer();
	echo '</div>';

}

?>
