<?php
/*
Plugin Name: Youth League Registration
Plugin URI: http://vanskyhawk.com
Description: League registration and payment
Version: 0.10
Author: Brad Van Skyhawk
Author URI: http://vanskyhawk.com
Copyright: 2012, The Van Skyhawk Group, LLC
*/


define('YLR_PLUGIN_NAME',"youth-league-registration");
$ylr_script_url = get_option('home') . '/index.php?plugin=' . YLR_PLUGIN_NAME;
define('YLR_PATH',WP_PLUGIN_DIR.'/'.YLR_PLUGIN_NAME);
define('YLR_IMAGES_PATH',YLR_PATH.'/images');
define('YLR_CSS_PATH',YLR_PATH.'/css');
define('YLR_JS_PATH',YLR_PATH.'/js');
define('YLR_INCLUDES_PATH',YLR_PATH.'/includes');
define('YLR_I18N_PATH',YLR_PATH.'/i18n');
define('YLR_MODELS_PATH',YLR_PATH.'/classes/models');
define('YLR_CONTROLLERS_PATH',YLR_PATH.'/classes/controllers');
define('YLR_VIEWS_PATH',YLR_PATH.'/classes/views');
define('YLR_WIDGETS_PATH',YLR_PATH.'/classes/widgets');
define('YLR_HELPERS_PATH',YLR_PATH.'/classes/helpers');
define('YLR_URL',plugins_url($path = '/'.YLR_PLUGIN_NAME));
define('YLR_IMAGES_URL',YLR_URL.'/images');
define('YLR_CSS_URL',YLR_URL.'/css');
define('YLR_JS_URL',YLR_URL.'/js');
define('YLR_INCLUDES_URL',YLR_URL.'/includes');
define('YLR_SCRIPT_URL',$ylr_script_url);
define('YLR_CART', '_ylr_cart');

// Load the Config
//require_once(YLR_PATH . '/ylr-config.php');

$ylr_blogurl         = ((get_option('home'))?get_option('home'):get_option('siteurl'));
$ylr_siteurl         = get_option('siteurl');
$ylr_blogname        = get_option('blogname');
$ylr_blogdescription = get_option('blogdescription');

$ylr_leagues = array(
	'No League',
	'T-Ball (3-4 year olds)',
	'Rookies 5 (5 year olds)',
	'Rookies 6 (6 year olds)',
	'Pee-Wees (7-8 years old)',
	'Minors (9-10 years old)',
	'Majors (11-12 years old)',
	'Babe Ruth Prep (13 year olds)',
	'Babe Ruth (14-15 year olds)',
	'Babe Ruth (16-18 year olds)',
);
$ylr_costs = array(0, 90, 100, 100, 120, 120, 120, 145, 145, 170);
$ylr_costs = array(0, .9, 1, 1, 1.2, 1.2, 1.2, 1.45, 1.45, 1.7);

class YouthLeagueRegistration
{

	/**
	 * Setup the shortcodes and actions
	 */
	function __construct()
	{
		add_action('init', array($this, 'parse_standalone_request'));
		add_action('wp_enqueue_scripts', array($this, 'load_scripts'), 1); 
		add_shortcode('league-registration-form', array($this, 'registration_form'));
		add_shortcode('league-eligibility-form', array($this, 'eligibility_form'));
		add_shortcode('league-checkout', array($this, 'checkout'));
		session_start();
	}
	
	/**
	 * Load scripts and styles needed
	 */
	function load_scripts()
	{
  		wp_enqueue_script( 'jquery-ui-1.7.2', YLR_JS_URL . '/jquery/jquery-ui-1.7.2.custom.min.js', array('jquery') );
		wp_enqueue_script( 'ylr-registration', YLR_JS_URL . '/ylr.js', array('jquery-ui-1.7.2') );
		wp_enqueue_style( 'jquery-ui-1.7.2', YLR_CSS_URL . '/jquery/smoothness/jquery-ui-1.7.2.custom.css' );
	}
	
	function log($text)
	{
		error_log(date('r') . ': ' . $text . "\n", 3, 'brad.log');
	}
	
	/**
	 * Process and/or display registration form
	 */
	function registration_form()
	{
		if (isset($_SESSION[YLR_CART])) $_POST = $_SESSION[YLR_CART];
		if (empty($_POST)) $_POST = $this->get_cart(session_id());
		$this->display_errors();
		$this->display_registration_form();
	}
	
	/**
	 * Display checkout form
	 */
	function checkout()
	{
		$cart = $this->get_cart(session_id());
		if (empty($cart))
		{
			echo 'Your cart is empty.';
			return;
		}
		global $ylr_leagues, $ylr_costs;
		include "views/checkout.php";
	}
	
	/**
	 * Process the registration form and save the cart.
	 */
	function process_registration_form()
	{
		$this->errors = $this->validate_registration_form($_POST);

		if (empty($this->errors))
  		{
  			global $wpdb;
  			
  			// Add to cart
  			$_SESSION[YLR_CART] = $_POST;
  			$session_id = session_id();
 			$cart = serialize($_POST);
 			$table = "{$wpdb->prefix}ylr_carts";
  			$sql = $wpdb->prepare("SELECT id FROM $table WHERE session_id = %s", $session_id);
  			$id = $wpdb->get_var($sql);
  			if ($id)
  			{
  				$sql = $wpdb->prepare("UPDATE $table SET cart = %s, modified = NOW() WHERE id = %s", $cart, $id);
  			}
  			else
  			{
  				$sql = $wpdb->prepare("INSERT INTO $table (session_id, cart, created, modified) VALUES (%s, %s, NOW(), NOW())", $session_id, $cart);
  			}
  			$wpdb->query($sql);
  			header("Location: " . home_url('checkout'));
  			exit;
  		}
	}
	
	function add_records($data, $transaction)
	{
		$parent = $data['parent'];
		$players = $data['players'];
		$derby = $data['derby'];
		$txn_id = $transaction['txn_id'];
		
		$this->insert_transaction($txn_id, $transaction);
		
		// Save each player
	  	foreach ($players as $player)
  		{
  			$this->insert_player($parent, $player, $txn_id);
  		}
  		
  		// Save home run derby participants
		$names = explode(',', $derby['names']);
		if (count($names))
		{
			foreach ($names as $name)
			{
				$this->insert_derby($name, $txn_id);
			}
		}  			
	}
	
	function insert_transaction($txn_id, $transaction)
	{
		global $wpdb;
		
		$table = $wpdb->prefix . 'ylr_transactions';
		$session_id = $transaction['custom'];
		$sql = $wpdb->prepare("INSERT INTO $table (txn_id, session_id, transaction, created) VALUES (%s, %s, %s, NOW())", $txn_id, $session_id, serialize($transaction));
		return $wpdb->query($sql);		
	}
	
	function insert_derby($name, $txn_id)
	{
		global $wpdb;
		
		$table = $wpdb->prefix . 'ylr_home_runs';
		$sql = $wpdb->prepare("INSERT INTO $table (name, txn_id, created) VALUES (%s, %s, NOW())", $name, $txn_id);
		return $wpdb->query($sql);
	}
	
	function insert_player($parent, $player, $txn_id)
	{
  		global $wpdb;
  			
  		$table = $wpdb->prefix . 'ylr_players';	
		extract($parent);
		extract($player);
		
		$tmp_date = strtotime($birth_date);
		if ($tmp_date)
		{
			$birth_date = date('Y-m-d', $tmp_date);
		}
		else
		{
			$birth_date = null;
		}
		
		$sql = "INSERT INTO $table (first_name, last_name, birthdate, address, city, state, zip, day_phone, cell_phone, 
				email, school_boundary, shirt_size, pant_size, league_id, last_team, moms_name, dads_name, assistant_coach, 
				snack_bar, team_mom, umpire, score_keeping, txn_id, created, modified)
					VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %d, %s, %s, %s, %d, %d, %d, %d, %d, %s, NOW(), NOW())";
		$player = $wpdb->prepare($sql, $first_name, $last_name, $birth_date, $address, $city, $state, $zip, $home_phone, $cell_phone, 
				$email, $school_boundary, $shirt_size, $pant_size, $league_id, $last_team, $mother_name, $father_name, 
				$assistant_coach, $snack_bar, $team_mom, $umpire, $score_keeping, $txn_id);
		$return = $wpdb->query($player);
	}
	
	function validate_registration_form($values, $errors=array())
	{
		extract($values);

		if ((!isset($parent['father_name']) or empty($parent['father_name']))
			and (!isset($parent['mother_name']) or empty($parent['mother_name'])))
			$errors[] = __("Both Father's name and Mother's name can't be Blank");
		
		if(!isset($parent['address']) or empty($parent['address']))
			$errors[] = __("Address can't be Blank");
		
		if(!isset($parent['city']) or empty($parent['city']))
			$errors[] = __("City can't be Blank");
		
		if(!isset($parent['state']) or empty($parent['state']))
			$errors[] = __("State can't be Blank");
		
		if(!isset($parent['zip']) or empty($parent['zip']))
			$errors[] = __("Zip Code can't be Blank");
		
		if(!isset($parent['home_phone']) or empty($parent['home_phone']))
			$errors[] = __("Home Phone can't be Blank");  
		else if(!preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $parent['home_phone']))
			$errors[] = __("Home Phone must be in the format ###-###-####");
		
		if( isset($parent['cell_phone']) and !empty($parent['cell_phone']) and
			!preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $parent['cell_phone']))
			$errors[] = __("Cell Phone must be in the format ###-###-####");
		
		if(!isset($parent['email']) or empty($parent['email']))
			$errors[] = __("Email can't be Blank");
		
		if(!isset($parent['school_boundary']) or empty($parent['school_boundary']))
			$errors[] = __("School Boundary can't be Blank");
		
		if(!isset($parent['terms']) or empty($parent['terms']))
			$errors[] = __("Please click Agree to Terms");
		
		$index = 1;
		foreach($players as $key => $player)
		{
			$errors = $this->validate_player($index, $player, $errors);
			$index++;
		}
	
		return $errors;
	}

	function validate_player($key,$values,$errors=array())
	{
  		extract($values);
  		
		if(!isset($first_name) or empty($first_name))
			$errors[] = sprintf(__('Player #%d: First Name can\'t be Blank.'), (int)$key);

  		if(!isset($last_name) or empty($last_name))
    		$errors[] = sprintf(__('Player #%d: Last Name can\'t be Blank.'), (int)$key);

		if(!isset($birth_date) or empty($birth_date))
			$errors[] = sprintf(__('Player #%d: Birth Date can\'t be Blank.'), (int)$key);

		if(!isset($league_id) or empty($league_id))
			$errors[] = sprintf(__('Player #%d: Division can\'t be Blank.'), (int)$key);

		if(!isset($shirt_size) or empty($shirt_size))
			$errors[] = sprintf(__('Player #%d: Shirt Size can\'t be Blank.'), (int)$key);

		if(!isset($pant_size) or empty($pant_size))
			$errors[] = sprintf(__('Player #%d: Pant Size can\'t be Blank.'), (int)$key);

		return $errors;
	}
	
	function display_errors()
	{
		if (empty($this->errors)) return;
		$errors = $this->errors;
		include('views/registration-errors.php');
	}

	function display_registration_form()
	{
		include('views/registration-form.php');
	}
	
	function eligibility_form()
	{
		include('views/eligibility-form.php');
	}
	
	function get_cart($session_id = null)
	{
		global $wpdb;
		
		if (is_null($session_id)) $session_id = session_id();
		$table = $wpdb->prefix . 'ylr_carts';
		$sql = $wpdb->prepare("SELECT cart FROM $table WHERE session_id = %s", $session_id);
		$cart = $wpdb->get_var($sql);
		if ($cart)
		{
			return unserialize($cart);
		}
		return false;
	}
	
	function parse_standalone_request()
	{
		$plugin     = (isset($_REQUEST['plugin'])?$_REQUEST['plugin']:'');
		$action     = (isset($_REQUEST['action'])?$_REQUEST['action']:'');
		$controller = (isset($_REQUEST['controller'])?$_REQUEST['controller']:'');
		$page 		= (isset($_REQUEST['page'])?$_REQUEST['page']:'');
		
		if ( !empty($plugin) and $plugin == YLR_PLUGIN_NAME and !empty($controller) and !empty($action) )
		{
			if ($controller == 'players' and $action == 'add_player')
			{
				$this->add_player_form($_REQUEST['key']);
				exit;
			}
			
			if ($controller == 'registration' and $action == 'process')
			{
				$this->process_registration_form();
			}
			
			if ($controller = 'transaction' and $action == 'update')
			{
				$this->add_records($this->get_cart($_REQUEST['custom']), $_REQUEST);
				$this->log(print_r($_REQUEST, true));
				$this->log(print_r($this->get_cart($_REQUEST['custom']), true));
				$this->log('-------------------------------------------------');
			}
		}
	}
	
	function add_player_form($key, $hide_add_button = false)
	{
		include('views/player-registration-form.php');
	}
}

$ylr = new YouthLeagueRegistration();