<?php
App::uses('AppModel', 'Model');
/**
 * User Model
 *
 * @property Wedding $Wedding
 */
class User extends AppModel {

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'email' => array(
			'email' => array(
				'rule' => array('email'),
				'message' => 'Please provide a valid email address',
				'required' => true,
			),
			'isUnique' => array(
				'rule' => array('isUnique'),
				'message' => 'This email address is already registered',
				'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'password' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => 'Please provide a password',
				'required' => true,
			)
		),
		'tos' => array(
			'notEmpty' => array(
				'rule' => array('equalTo', 1),
				'message' => 'Please accept',
				'allowEmpty' => false,
			)
		)
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Wedding' => array(
			'className' => 'Wedding',
			'foreignKey' => 'user_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

/**
 * beforeSave method
 */
	public function beforeSave($options = array()) {
		if (isset($this->data[$this->alias]['password']) && !empty($this->data[$this->alias]['password'])) {
			$this->data[$this->alias]['password'] = AuthComponent::password($this->data[$this->alias]['password']);
		}
		return true;
	}

/**
 * passwordValidator method
 */
	public function passwordValidator($username = true) {
		$this->validate = array();
		if ($username) {
			$this->validator()->add('email', array(
				'email' => array(
					'rule' => array('email'),
					'message' => 'Please provide valid email address',
					'allowEmpty' => false,
					'required' => true,
				),
				'unique' => array(
					'rule' => 'isUnique',
					'message' => 'This email has already been used',
				)
			));
		}
		$this->validator()->add('password', array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => __('Password cannot be empty'),
				'required' => true,
			),
			'size' => array(
				'rule' => array('minLength', 8),
				'message' => __('Password should be at least 8 characters long')
			),
			'passwordequal' => array(
				'rule' => 'checkpasswords',
				'message' => __("Passwords don't match")
			),
		));
		$this->validator()->add('password_confirm', array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => __('Password confirmation cannot be empty'),
				'required' => true
			),
			'size' => array(
				'rule' => array('minLength', 8),
				'message' => __('Password should be at least 8 characters long')
			)
		));
		if ($username) {
			$this->validator()->add('tos', array(
				'required' => array(
					'rule' => array('notEmpty'),
					'message' => __('Please accept our Terms of Service'),
					'required' => 'create',
				),
			));
		}
	}

/**
 * checkpasswords method
 */
	public function checkpasswords() {
		return strcmp($this->data[$this->alias]['password'],$this->data[$this->alias]['password_confirm']) == 0;
	}

}
