<?php
App::uses('AppModel', 'Model');
/**
 * Wedding Model
 *
 * @property Guest $Guest
 */
class Wedding extends AppModel {

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'email' => array(
			'email' => array(
				'rule' => array('email'),
				'message' => 'Please enter a valid email address.',
			),
		),
		'email_confirm' => array(
			'email' => array(
				'rule' => array('email'),
				'message' => 'Please enter a valid email address.',
			),
			'match' => array(
				'rule' => array('fieldsMatch', 'email'),
				'message' => 'Emails must match'
			),
		),
		'password' => array(
			'length' => array(
				'rule' => array('minLength', 6),
				'message' => 'Password must be at least 6 characters',
			),
		),
		'password_confirm' => array(
			'length' => array(
				'rule' => array('minLength', 6),
				'message' => 'Password must be at least 6 characters',
			),
			'match' => array(
				'rule' => array('fieldsMatch', 'password'),
				'message' => 'Passwords must match'
			),
		),
		'bride_family_name' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => "Please enter the groom's last name",
			),
		),
		'groom_family_name' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => "Please enter the groom's last name",
			),
		),
		'wedding_date' => array(
			'date' => array(
				'rule' => array('date'),
				'message' => 'Please enter a valid date',
				'allowEmpty' => true,
			),
		),
	);

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Guest' => array(
			'className' => 'Guest',
			'foreignKey' => 'wedding_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

/**
 * beforeSave method
 */
	public function beforeSave($options = array()) {
		if (isset($this->data[$this->alias]['wedding_slug']) && empty($this->data[$this->alias]['wedding_slug'])) {
			$this->data[$this->alias]['wedding_slug'] =
				strtolower(sprintf('%s-%s-%s',
						substr($this->data[$this->alias]['bride_family_name'], 0, 3),
						substr($this->data[$this->alias]['groom_family_name'], 0, 3),
						substr(md5(time()), 0, 3)));
		}
		if (isset($this->data[$this->alias]['wedding_date'])) {
			$this->data[$this->alias]['wedding_date'] = date('Y-m-d', strtotime($this->data[$this->alias]['wedding_date']));
		}
		return true;
	}

/**
 * fieldsMatch method
 */
	public function fieldsMatch($check, $field) {
		$value = array_values($check);
		return strcasecmp($value[0], $this->data[$this->alias][$field]) === 0;
	}
}
