<?php
$states = array(
    'AL'=>'Alabama',
    'AK'=>'Alaska',
    'AZ'=>'Arizona',
    'AR'=>'Arkansas',
    'CA'=>'California',
    'CO'=>'Colorado',
    'CT'=>'Connecticut',
    'DE'=>'Delaware',
    'DC'=>'District of Columbia',
    'FL'=>'Florida',
    'GA'=>'Georgia',
    'HI'=>'Hawaii',
    'ID'=>'Idaho',
    'IL'=>'Illinois',
    'IN'=>'Indiana',
    'IA'=>'Iowa',
    'KS'=>'Kansas',
    'KY'=>'Kentucky',
    'LA'=>'Louisiana',
    'ME'=>'Maine',
    'MD'=>'Maryland',
    'MA'=>'Massachusetts',
    'MI'=>'Michigan',
    'MN'=>'Minnesota',
    'MS'=>'Mississippi',
    'MO'=>'Missouri',
    'MT'=>'Montana',
    'NE'=>'Nebraska',
    'NV'=>'Nevada',
    'NH'=>'New Hampshire',
    'NJ'=>'New Jersey',
    'NM'=>'New Mexico',
    'NY'=>'New York',
    'NC'=>'North Carolina',
    'ND'=>'North Dakota',
    'OH'=>'Ohio',
    'OK'=>'Oklahoma',
    'OR'=>'Oregon',
    'PA'=>'Pennsylvania',
    'RI'=>'Rhode Island',
    'SC'=>'South Carolina',
    'SD'=>'South Dakota',
    'TN'=>'Tennessee',
    'TX'=>'Texas',
    'UT'=>'Utah',
    'VT'=>'Vermont',
    'VA'=>'Virginia',
    'WA'=>'Washington',
    'WV'=>'West Virginia',
    'WI'=>'Wisconsin',
    'WY'=>'Wyoming',
);
$weddingTitle = sprintf('%s / %s Wedding', $wedding['Wedding']['bride_family_name'], $wedding['Wedding']['groom_family_name']);
$description = 'Click here to enter your address for our wedding';
$this->set('title_for_layout', $weddingTitle);
//$this->Html->meta('description', $description, array('inline' => false));
// for facebook
$this->Html->meta(array('property' => 'og:title', 'content' => $weddingTitle), null, array('inline' => false));
$this->Html->meta(array('property' => 'og:description', 'content' => $description), null, array('inline' => false));
$this->Html->meta(array('property' => 'og:url', 'content' => Router::url( $this->here, true )), null, array('inline' => false));
$this->Html->meta(array('property' => 'og:image', 'content' => Router::url( '/img/main-logo.png', true )), null, array('inline' => false));
?>
<section data-nekoanim="fadeIn" data-nekodelay="100" class="color4 slice">
	<div class="container">
		<?php echo $this->Form->create('Guest', array('class' => 'form-horizontal', 'labelOffset' => 3, 'autocomplete' => 'off', 'role' => 'form')); ?>
		<h1><?php echo $weddingTitle; ?></h1>
		<h3 class="text-center"><?php echo $this->Time->format('l, F d, Y', $wedding['Wedding']['wedding_date']); ?></h3>
		<div class="row">
			<p class="text-left col-sm-12">Your address and contact information are private and will not be sold or distributed to any other party.  If you wish, HandInvites can provide you additional information regarding this wedding; i.e. calendar invite, links to the couple/bridal registry, etc.</p>
		</div>

		<div class="row">
			<div class="col-sm-6">
				<?php
					echo $this->Form->hidden('wedding_id', array('value' => $wedding['Wedding']['id']));
					echo $this->Form->input('first_name', array('placeholder' => 'Your First Name'));
					echo $this->Form->input('last_name', array('placeholder' => 'Your Last Name'));
					echo $this->Form->input('envelope_line', array('placeholder' => 'Your Name on the envelope'));
					echo $this->Form->input('country_id', array('placeholder' => 'Your Country'));
					echo $this->Form->input('address', array('placeholder' => 'Your Address'));
					echo $this->Form->input('address_2', array('placeholder' => '(Optional)'));
					echo $this->Form->input('city', array('placeholder' => 'Your City/ Municipality'));
					echo $this->Form->input('state', array('options' => $states, 'empty' => '- Select State/Province -'));
					echo $this->Form->input('zip', array('placeholder' => 'Your Zip/Postal Code'));
				?>
			</div>
			<div class="col-sm-6">
				<?php
					echo $this->Form->input('email_address', array('placeholder' => 'Your Email, if you want updates'));
					echo $this->Form->input('phone_number', array('placeholder' => '(Optional)'));
				?>
				<div class="col-sm-offset-3">
				<p>Which family do you know?</p>
					<label id="GuestKnowsBride" class="checkbox-inline">
						<?php echo $this->Form->checkbox('knows_bride'); ?>
						<?php echo $wedding['Wedding']['bride_family_name']; ?>
					</label>
					<label id="GuestKnowsGroom" class="checkbox-inline">
						<?php echo $this->Form->checkbox('knows_groom'); ?>
						<?php echo $wedding['Wedding']['groom_family_name']; ?>
					</label>
				</div>
				<br>
				<div class="col-sm-offset-3">
					<div class="checkbox">
						<label id="GuestRegistryOptin">
							<?php echo $this->Form->checkbox('registry_optin'); ?>
							Send information about the WEDDING REGISTRY
						</label>
					</div>
					<div class="checkbox">
						<label id="GuestCalendarOptin">
							<?php echo $this->Form->checkbox('calendar_optin'); ?>
							Send a calendar reminder to my email
						</label>
					</div>
				</div>
				<br>
				<div class="form-group">
					<div class="col-sm-offset-3 col-sm-9">
						<?php echo $this->Form->submit('Submit', array('class' => 'btn btn-default btn-lg')); ?>
					</div>
				</div>
			</div>
		</div>
		<?php echo $this->Form->end(); ?>
	</div>
</section>
<?php $this->Html->scriptStart(array('inline' => false)); ?>
jQuery('#WeddingEmail').focus();
<?php $this->Html->scriptEnd(); ?>
