<?php
App::uses('CakeEmail', 'Network/Email');
/**
 * Email Service using SendGrid
 *
 * @author Brad Van Skyhawk
 * @version $Id$
 * @copyright Fidello Training Technologies, 3 April, 2012
 * @package default
 **/

class EmailServiceComponent extends Component {

	public $helpers = array('Html');

/**
 * EmailService object.
 *
 * @access private
 * @public object
 */
	public $cakemail;

/**
 * Layout for the View
 *
 * @public string
 * @access public
 */
	public $layout = 'default';

/**
 * Template for the view
 *
 * @public string
 * @access public
 */
	public $template = null;

/**
 * Constructor
 *
 * @param ComponentCollection $collection A ComponentCollection this component can use to lazy load its components
 * @param array $settings Array of configuration settings.
 */
	public function __construct(ComponentCollection $collection, $settings = array()) {
		$this->_controller = $collection->getController();
		parent::__construct($collection, $settings);

		// Include the class file and create EmailService instance
		$this->cakemail = new CakeEmail('mailgun');
	}

/**
 * forgotPassword method
 */
	public function forgotPassword($email, $hash) {
		$vars = array(
			'url' => Router::url(
				array(
					'controller' => 'users',
					'action' => 'password',
					$hash
				),
				true
			)
		);
		$this->_send($email, 'HandyInvites: Password recovery', 'forgot-password', $vars);
	}

/**
 * userWelcome method
 */
    public function userWelcome($user) {
        $vars = array(
            'url' => Router::url(
                array(
                    'controller' => 'users',
                    'action' => 'password',
                    $hash
                ),
                true
            )
        );
        $this->_send($user['email'], 'HandyInvites: Welcome', 'user-welcome', $vars);
    }

/**
 * guestThanks method
 */
	public function guestThanks($guest, $event) {
		$vars = compact('guest', 'event');
		$ics = Router::url(array('controller' => 'guests', 'action' => 'event', $event['slug']), true);
		$attachment = array($event['event_title'] . '.ics' => array('data' => $this->requestAction($ics, array('return'))));
		$this->_send($guest['email_address'], 'HandyInvites: Thank you', 'guest-thanks', $vars, $attachment);
	}

/**
 * Send the email to the Email Server
 *
 * @param string $email
 * @param string $subject
 * @param string $body
 */
	protected function _send($email, $subject, $template, $vars = array(), $attachment = null) {
		// Pass the site url.
		$vars['site_url'] = $this->_url();

		if ($attachment) {
			$this->cakemail->attachments($attachment);
		}

		// Format with cakemail
		$this->cakemail
			->template($template)
			->viewVars($vars)
			->subject($subject)
			->emailFormat('both')
			->to($email)
			->from('noreply@handyinvites.com')
			->send();
	}

/**
 * Build the site url
 */
	protected function _url() {
		if (env('HTTPS')) {
			$url = 'https://';
		} else {
			$url = 'http://';
		}
		if (env('HTTP_HOST') != null) {
			$host = env('HTTP_HOST');
		}

		if (env('HTTP_X_FORWARDED_HOST') != null) {
			$host = env('HTTP_X_FORWARDED_HOST');
		}
		$host = trim(preg_replace('/(?:\:.*)/', '', $host));

		$url .= $host . $this->_controller->webroot;
		return str_replace('/app/webroot', '', $url);
	}

}
