<?php
App::uses('AppController', 'Controller');
/**
 * Events Controller
 *
 * @property Event $Event
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class EventsController extends AppController {

/**
 * register method
 *
 * @return void
 */
	public function register() {
		if ($this->request->is('post')) {
			$this->Event->create();
			if ($this->Event->save($this->request->data)) {
				$this->Session->setFlash(__('Your new account has been created. We have sent you an confirmation email.'), 'alert-success');
				return $this->redirect(array('action' => 'login'));
			} else {
				$this->Session->setFlash(__('The event could not be saved. Please, try again.'), 'alert-danger');
			}
		}
	}

/**
 * login method
 */
	public function login() {
		$this->Session->setFlash('Invalid login credentials', 'alert-danger');
	}

/**
 * find method
 */
	public function find() {
		if ($this->request->is('post')) {
			$options = array(
				'conditions' => array('OR' => array(
					'OR' => array(
						sprintf("bride_family_name LIKE '%%%s%%'", $this->data['Event']['name']),
						sprintf("groom_family_name LIKE '%%%s%%'", $this->data['Event']['name']),
					),
					'event_slug' => $this->data['Event']['event']
				)),
				'contain' => array()
			);
			$events = $this->Event->find('all', $options);
			if ($events) {
				$this->set(compact('events'));
				return $this->render('list');
			} else {
				$this->Session->setFlash('Sorry. We cannot find that Event', 'alert-danger');
			}
		}
	}

/**
 * search method
 */
	public function search() {

	}

/**
 * index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Event->recursive = 0;
		$this->set('events', $this->Paginator->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_view($id = null) {
		if (!$this->Event->exists($id)) {
			throw new NotFoundException(__('Invalid event'));
		}
		$options = array('conditions' => array('Event.' . $this->Event->primaryKey => $id));
		$this->set('event', $this->Event->find('first', $options));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		if (!$this->Event->exists($id)) {
			throw new NotFoundException(__('Invalid event'));
		}
		if ($this->request->is(array('post', 'put'))) {
			if ($this->Event->save($this->request->data)) {
				$this->Session->setFlash(__('The event has been saved.'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The event could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Event.' . $this->Event->primaryKey => $id));
			$this->request->data = $this->Event->find('first', $options);
		}
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Event->id = $id;
		if (!$this->Event->exists()) {
			throw new NotFoundException(__('Invalid event'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Event->delete()) {
			$this->Session->setFlash(__('The event has been deleted.'));
		} else {
			$this->Session->setFlash(__('The event could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
