<?php
App::uses('AppController', 'Controller');
/**
 * Guests Controller
 *
 * @property Guest $Guest
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class GuestsController extends AppController {

/**
 * add method
 */
	public function add() {
		$slug = strtolower($this->params['id']);
		$event = $this->Guest->Event->findBySlug($slug);
		if (empty($event)) {
			$this->Session->setFlash('Sorry! We could not find that event.', 'alert-danger');
			return $this->redirect('/');
		}

		if ($this->request->is('post')) {
			$this->Guest->create();
			if ($this->Guest->save($this->request->data)) {
				if (!empty($this->data['Guest']['email_address'])) {
					$event = $this->Guest->Event->read(null, $this->data['Guest']['event_id']);
					$this->EmailService->guestThanks($this->data['Guest'], $event['Event']);
				}
				$this->Session->setFlash(__('Your address is added to the guest list. Thank you.'), 'alert-success');
				return $this->redirect('/');
			} else {
				$this->Session->setFlash(__('We could not save your address. Please, try again.'), 'alert-danger');
			}
		}

		$this->loadModel('State');
		$states = $this->State->find('list', array('fields' => array('State.abbrev', 'State.name', 'Country.name'), 'contain' => 'Country'));

		$this->set(compact('event', 'states'));
	}

/**
 * event method - return ics file
 */
	public function event($slug) {
		$this->layout = 'ajax';
		$event = $this->Guest->Event->findBySlug($slug);
		$this->set(compact('event'));
	}

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Guest->recursive = 0;
		$this->set('guests', $this->Paginator->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Guest->exists($id)) {
			throw new NotFoundException(__('Invalid guest'));
		}
		$options = array('conditions' => array('Guest.' . $this->Guest->primaryKey => $id));
		$this->set('guest', $this->Guest->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function register($event_id = null) {
		if ($this->request->is('post')) {
			$this->Guest->create();
			if ($this->Guest->save($this->request->data)) {
				$this->Session->setFlash(__('The guest has been saved.'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The guest could not be saved. Please, try again.'));
			}
		}
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Guest->exists($id)) {
			throw new NotFoundException(__('Invalid guest'));
		}
		if ($this->request->is(array('post', 'put'))) {
			if ($this->Guest->save($this->request->data)) {
				$this->Session->setFlash(__('The guest has been saved.'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The guest could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Guest.' . $this->Guest->primaryKey => $id));
			$this->request->data = $this->Guest->find('first', $options);
		}
		$events = $this->Guest->Event->find('list');
		$this->set(compact('events'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		$this->Guest->id = $id;
		if (!$this->Guest->exists()) {
			throw new NotFoundException(__('Invalid guest'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Guest->delete()) {
			$this->Session->setFlash(__('The guest has been deleted.'));
		} else {
			$this->Session->setFlash(__('The guest could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
