<?php
App::uses('AppModel', 'Model');
/**
 * Event Model
 *
 * @property Guest $Guest
 */
class Event extends AppModel {

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'event_title' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => "Please enter an event title",
			),
		),
		'event_date' => array(
			'date' => array(
				'rule' => array('date', 'mdy'),
				'message' => 'Please enter a valid date',
			),
		),
		'last_name' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => "Please enter a last name",
			),
		),
	);

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Guest' => array(
			'className' => 'Guest',
			'foreignKey' => 'event_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Registry' => array(
			'className' => 'Registry',
			'foreignKey' => 'event_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

/**
 * beforeSave method
 */
	public function beforeSave($options = array()) {
		if (isset($this->data[$this->alias]['slug']) && empty($this->data[$this->alias]['slug'])) {
			$this->data[$this->alias]['slug'] =
				strtolower(sprintf('%s-%s-%s',
						substr($this->data[$this->alias]['last_name'], 0, 3),
						substr($this->data[$this->alias]['co_last_name'], 0, 3),
						substr(md5(time()), 0, 3)));
		}
		if (isset($this->data[$this->alias]['event_date'])) {
			$this->data[$this->alias]['event_date'] = date('Y-m-d', strtotime($this->data[$this->alias]['event_date']));
		}
		if (isset($this->data[$this->alias]['event_start_time'])) {
			$this->data[$this->alias]['event_start_time'] = date('H:i', strtotime($this->data[$this->alias]['event_start_time']));
		}
		if (isset($this->data[$this->alias]['event_end_time'])) {
			$this->data[$this->alias]['event_end_time'] = date('H:i', strtotime($this->data[$this->alias]['event_end_time']));
		}
		return true;
	}

/**
 * afterFind method
 */
	public function afterFind($results, $primary = false) {
		foreach ($results as $key => $val) {
			if (isset($val[$this->alias]['event_date'])) {
				$results[$key][$this->alias]['event_date'] = $this->dateFormatAfterFind($val[$this->alias]['event_date']);
			}
			if (isset($val[$this->alias]['event_start_time'])) {
				$results[$key][$this->alias]['event_start_time'] = date('g:i A', strtotime($val[$this->alias]['event_start_time']));
			}
			if (isset($val[$this->alias]['event_end_time'])) {
				$results[$key][$this->alias]['event_end_time'] = date('g:i A', strtotime($val[$this->alias]['event_end_time']));
			}
            if (isset($val[$this->alias]) && empty($val[$this->alias]['event_title'])) {
                $results[$key][$this->alias]['event_title'] = sprintf('%s / %s %s', $val[$this->alias]['last_name'], $val[$this->alias]['co_last_name'], ucfirst($val[$this->alias]['event_type']));
            }
		}
		return $results;
	}

/**
 * getCounts method
 */
	public function getCounts() {
		$results = array('eventUpcoming' => 0, 'eventPast' => 0);

        // All events
        $admin = AuthComponent::user('is_admin');
        if ($admin) {
            $options = array(
                'conditions' => array(
                    'event_date > NOW()',
                ),
            );
            $results['eventUpcoming'] = $this->find('count', $options);

            $options = array(
                'conditions' => array(
                    'event_date <= NOW()',
                ),
            );
            $results['eventPast'] = $this->find('count', $options);

            return $results;
        }

		// How many events
		$userId = AuthComponent::user('id');
		if ($userId) {
			$options = array(
				'conditions' => array(
					'user_id' => $userId,
					'event_date > NOW()',
				),
			);
			$results['eventUpcoming'] = $this->find('count', $options);

			$options = array(
				'conditions' => array(
					'user_id' => $userId,
					'event_date <= NOW()',
				),
			);
			$results['eventPast'] = $this->find('count', $options);

            return $results;
		}

		return $results;
	}
}
