<?php
$dashboardLink = Router::url('/dashboard', true);
$dashboardLink = 'http://www.handyinvites.com/dashboard';
$labels = array(
	'xlsx' => 'Microsoft XLSX',
	'csv' => 'Comma Separated',
	'docx' => 'Microsoft Word',
	'pdf' => 'Adobe PDF'
);
?>
<section data-nekoanim="fadeIn" data-nekodelay="100" class="color3 slice">
	<div class="container">
		<div class="row">
			<div class="col-sm-3">
				<?php echo $this->element('user-menu'); ?>
			</div>
			<div class="col-sm-9">
				<h1>Upcoming Events</h1>

			<?php if ($events): ?>

				<?php foreach ($events as $event): ?>

					<div class="panel panel-primary">
						<div class="panel-heading">
							<div class="pull-right">
								<?php echo $this->Html->link('<i class="icon-edit"></i>Edit', array('action' => 'event', $event['Event']['id'], $event['Event']['slug']), array('class' => 'btn btn-xs', 'escape' => false)); ?>
							</div>
							<div class="panel-title"><?php echo $event['Event']['event_title']; ?></div>
  						</div>
  						<div class="panel-body">

							<dl class="dl-horizontal">
								<dt>Link:</dt>
								<dd>
									<?php
									$slug = $event['Event']['slug'];
									echo $this->element('event-link', array('slug' => $slug));
									?>
								</dd>
								<dt>Event Date:</dt>
								<dd>
									<?php echo $this->Time->format('l, F j, Y', $event['Event']['event_date']); ?>
									(<?php echo $this->Time->timeAgoInWords($event['Event']['event_date'], array('format' => 'F jS, Y', 'end' => '+3 month')); ?>)
								</dd>
								<dt>Venue:</dt>
								<dd>
									<?php if ($event['Event']['event_venue']): ?>
										<?php echo $event['Event']['event_venue']; ?>
										(<?php echo $this->Html->link('map', __('https://www.google.com/maps/place/%s', str_replace(' ', '+', $event['Event']['event_venue'])), array('target' => '_blank')); ?>)
									<?php endif;?>

								</dd>
								<dt>Guest Count:</dt>
								<dd>
									<?php echo count($event['Guest']); ?>
								</dd>
							</dl>

							<div>
								<?php
									$link = 'http://www.handyinvites.com/' . $slug;
									$fbLink = __('http://www.facebook.com/dialog/send?app_id=1462097227354459&link=%s&redirect_uri=%s', $link, $dashboardLink);
									echo $this->Html->link('<i class="icon-facebook-1"></i>Post', $fbLink, array('class' => 'btn btn-sm', 'escape' => false));
								?>
								<?php echo $this->Html->link('<i class="icon-folder"></i>Guest List', array('action' => 'guests', $event['Event']['id'], $event['Event']['slug']), array('class' => 'btn btn-default btn-sm', 'escape' => false)); ?>
								<?php echo $this->Html->link('<i class="icon-user-add"></i>Add Guest', array('action' => 'guest_add', $event['Event']['id'], $event['Event']['slug']), array('class' => 'btn btn-sm', 'escape' => false)); ?>

								<div class="btn-group">
									<button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown">
										<i class="icon-export"></i>Export Guests <span class="caret"></span>
									</button>
									<ul class="dropdown-menu" role="menu">
									<?php foreach ($labels as $format => $title): ?>
										<li><?php echo $this->Html->link($title, array('action' => 'guests', $event['Event']['id'], $event['Event']['slug'] . '.' . $format)); ?></li>
									<?php endforeach; ?>
									</ul>
								</div>

								<?php echo $this->Html->link('<i class="icon-gift"></i>Upgrade', '#', array('class' => 'btn btn-sm btn-stripe', 'escape' => false, 'data-event' => $event['Event']['event_title'])); ?>
							</div>

						</div>
					</div>
			<?php endforeach; ?>

		<?php else: ?>

			<p>You have no upcoming events.</p>
			<p><?php echo $this->Html->link('Create an Event', array('action' => 'event'), array('class' => 'btn-sm btn')); ?></p>

		<?php endif; ?>


			</div>
		</div>
	</div>
</section>
<?php echo $this->element('stripe'); ?>
