<!DOCTYPE html>
<html>
<head>
	<?php echo $this->Html->charset(); ?>
	<title>
		<?php echo $title_for_layout; ?> | Handy Invites
	</title>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<?php
		echo $this->Html->meta('icon');
		echo $this->element('favicon');
		echo $this->fetch('meta');

		// for facebook
		echo $this->Html->meta(array('property' => 'og:title', 'content' => 'HandyInvites'));
		echo $this->Html->meta(array('property' => 'og:description', 'content' => 'Send our link to your guests via Facebook, text or email and we\'ll do the rest!'));
		echo $this->Html->meta(array('property' => 'og:url', 'content' => Router::url('/', true)));
		echo $this->Html->meta(array('property' => 'og:image', 'content' => Router::url('/img/main-logo-icon.gif', true)));

		echo $this->Html->css(array(
			'/bootstrap/css/bootstrap.min',
			'http://fonts.googleapis.com/css?family=Open+Sans:300,400,600,800',
			'/js-plugin/animation-framework/animate',
			'/js-plugin/magnific-popup/magnific-popup',
			'/js-plugin/isotope/css/style',
			'/js-plugin/flexslider/flexslider',
			'/js-plugin/pageSlide/jquery.pageslide',
			'/js-plugin/owl.carousel/owl-carousel/owl.carousel',
			'/js-plugin/owl.carousel/owl-carousel/owl.theme',
			'/js-plugin/appear/nekoAnim',
			'/font-icons/custom-icons/css/custom-icons.css',
			'/font-icons/custom-icons/css/custom-icons-ie7.css',
			'layout', 'blue'
		));

		echo $this->fetch('css');
	?>
	<!--[if lt IE 9]>
	<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
	<?php echo $this->Html->script('modernizr-2.6.1.min.js'); ?>

</head>
<body data-spy="scroll" data-target="#scrollTarget" data-offset="150" class="activateAppearAnimation">

	<div id="globalWrapper" class="localscroll">

		<?php echo $this->element('site-header'); ?>

			<?php echo $this->Session->flash(); ?>
			<?php echo $this->fetch('content'); ?>

		<?php echo $this->element('site-footer'); ?>
	</div>

	<?php echo $this->Html->script(array(
		'/js-plugin/respond/respond.min',
		'/js-plugin/jquery/1.8.3/jquery.min',
		'/js-plugin/jquery-ui/jquery-ui-1.8.23.custom.min',
		'/bootstrap/js/bootstrap',
		'/js-plugin/easing/jquery.easing.1.3',
		'/js-plugin/flexslider/jquery.flexslider-min',
		'/js-plugin/isotope/jquery.isotope.min',
		'/js-plugin/neko-contact-ajax-plugin/js/jquery.form',
		'/js-plugin/neko-contact-ajax-plugin/js/jquery.validate.min',
		'/js-plugin/magnific-popup/jquery.magnific-popup.min',
		'/js-plugin/parallax/js/jquery.scrollTo-1.4.3.1-min',
		'/js-plugin/parallax/js/jquery.localscroll-1.2.7-min',
		'/js-plugin/parallax/js/jquery.stellar.min',
		'/js-plugin/appear/jquery.appear',
		'/js-plugin/pageSlide/jquery.pageslide-custom',
		'/js-plugin/jquery.sharrre-1.3.4/jquery.sharrre-1.3.4.min',
		'/js-plugin/owl.carousel/owl-carousel/owl.carousel.min',
		'custom',
	)); ?>
	<?php echo $this->fetch('script'); ?>
</body>
</html>
