<?php
$this->set('title_for_layout', 'MyGuestList');

App::import('Vendor', 'PHPExcel/PHPExcel');
//include(APP . DS . 'Vendor' . DS . 'PHPExcel' . DS . 'PHPExcel.php');

// Create new PHPExcel object
$excel = new PHPExcel();

// Set properties
$title = $guests['Event']['event_title'];
$excel->getProperties()->setCreator('HandyInvites');
$excel->getProperties()->setLastModifiedBy('HandyInvites');
$excel->getProperties()->setTitle($title);
$excel->getProperties()->setSubject($title);
$excel->getProperties()->setDescription("Guest list.");

// Add the data
$excel->setActiveSheetIndex(0);

$sheet = $excel->getActiveSheet();

// Header row
$row = 1;
$col = 0;
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'First Name');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Last Name');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Envelope Line');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Address');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Address 2');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'City');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'State');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Zip');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Email');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Phone');
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Knows ' . $guests['Event']['last_name']);
$sheet->setCellValueExplicitByColumnAndRow($col++, $row, 'Knows ' . $guests['Event']['co_last_name']);


// Data rows
$row++;
foreach ($guests['Guest'] as $guest) {
	$col = 0;
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['first_name']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['last_name']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['envelope_line']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['address']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['address_2']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['city']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['state']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['zip'], PHPExcel_Cell_DataType::TYPE_STRING);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['email_address']);
	$sheet->setCellValueExplicitByColumnAndRow($col++, $row, $guest['phone_number']);
	$sheet->setCellValueByColumnAndRow($col++, $row, $guest['knows_groom']);
	$sheet->setCellValueByColumnAndRow($col++, $row, $guest['knows_bride']);

	$row++;
}

// Rename sheet
$sheet->setTitle('Guest List');

// Save Excel 2007 file
$writer = new PHPExcel_Writer_CSV($excel);
$writer->save('php://output');
