<?php $this->Html->css('bootstrap-timepicker.min', array('inline' => false)); ?>
<?php $id = $this->Form->value('Event.id'); ?>
<section data-nekoanim="fadeIn" data-nekodelay="100" class="color3 slice">
	<div class="container">
		<div class="row">
			<div class="col-sm-3">
				<?php echo $this->element('user-menu'); ?>
			</div>
			<div class="col-sm-9">
				<?php echo $this->Form->create('Event', array('class' => 'form-horizontal', 'labelOffset' => 3, 'autocomplete' => 'off', 'role' => 'form')); ?>
				<h1><?php echo $id ? __('Edit Event') : __('New Event'); ?></h1>
					<?php
						if ($id) {
							echo $this->Form->input('id');
							echo $this->Form->hidden('slug');

							$slug = $this->data['Event']['slug'];
							$eventLink = Router::url('/', true)  . $slug;
						} else {
							echo $this->Form->hidden('slug', array('value' => 0));
							$this->request->data['Event']['slug'] = '(Automatically Generated)';
						}
						echo $this->Form->hidden('user_id', array('value' => AuthComponent::user('id')));
						echo $this->Form->hidden('event_timezone');
					?>
					<?php if (!empty($slug)): ?>
					<div class="form-group">
						<label class="col-sm-3 control-label">Event Link</label>
						<div class="col-sm-9">
							<p class="form-control-static">
								<?php echo $this->element('event-link', array('slug' => $slug)); ?>
							</p>
						</div>
					</div>
					<?php else: ?>
					<div class="form-group">
						<label class="col-sm-3 control-label">Event Link</label>
						<div class="col-sm-9">
							<p class="form-control-static">(Automatically Generated)</p>
						</div>
					</div>
					<?php endif; ?>
					<fieldset>
					<legend>Event Details</legend>
						<?php
						echo $this->Form->input('event_type', array('options' => array('wedding' => 'Wedding', 'commitment' => 'Commitment', 'anniversary' => 'Anniversary')));
						echo $this->Form->input('event_title', array('placeholder' => 'Event title (example: Jones - Smith Wedding)'));
						echo $this->Form->input('event_date', array('type' => 'text', 'placeholder' => 'Event date'));
						echo $this->Form->input('event_start_time', array('type' => 'text', 'placeholder' => 'Event start time'));
						echo $this->Form->input('event_end_time', array('type' => 'text', 'placeholder' => 'Event end time'));
						echo $this->Form->input('event_venue', array('placeholder' => 'Venue address', 'rows' => 3));
						echo $this->Form->input('event_notes', array('placeholder' => 'Any special instructions for your guests about the special day.', 'rows' => 3));
						?>
					</fieldset>
					<fieldset>
					<legend>Registrant</legend>
						<?php
							echo $this->Form->input('first_name', array('label' => 'First Name', 'placeholder' => 'First name'));
							echo $this->Form->input('last_name', array('label' => 'Last Name', 'placeholder' => 'Last name'));
						?>
					</fieldset>
					<fieldset>
					<legend>Co-Registrant</legend>
						<?php
							echo $this->Form->input('co_first_name', array('label' => 'First Name', 'placeholder' => 'First name'));
							echo $this->Form->input('co_last_name', array('label' => 'Last Name', 'placeholder' => 'Last name'));
						?>
					</fieldset>
					<fieldset>
					<legend>
						Registry Information
						<?php
						$regCount = isset($this->data['Registry']) ? count($this->data['Registry']) : 1;
						echo $this->Html->link('Add Registry', "javascript:addRegistry('#registry', $regCount, 'registry-add')", array('class' => 'btn btn-xs'));
						?>
					</legend>
						<?php for ($i = 0; $i < $regCount; $i++): ?>
							<?php echo $this->element('registry-add', array('i' => $i)); ?>
						<?php endfor; ?>
						<div id="registry"></div>
					</fieldset>
					<br>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-9">
							<?php echo $this->Form->submit('Submit', array('class' => 'btn btn-default btn-lg')); ?>
						</div>
					</div>
				</div>
				<?php echo $this->Form->end(); ?>
			</div>
		</div>
	</div>
</section>

<?php $this->Html->script(array('libs/bootstrap-timepicker.min', 'libs/jstz.min'), array('inline' => false)); ?>
<?php $this->Html->scriptStart(array('inline' => false)); ?>
var tz = jstz.determine(); // Determines the time zone of the browser client
$('#EventEventTimezone').val(tz.name());
$('#EventEventDate').datepicker({
	autoclose: true,
	todayHighlight: true
});
$('#EventEventStartTime').timepicker({defaultTime:false,showInputs:false});
$('#EventEventEndTime').timepicker({defaultTime:false,showInputs:false});
<?php $title = $this->Form->value('Event.event_title'); ?>
<?php if (empty($title)): ?>
var titleChange = true;
function updateTitle() {
	if (titleChange == false) return;
	var last1 = $('#EventLastName').val();
	var last2 = $('#EventCoLastName').val();
	var type = $('#EventEventType').val().replace(/\b[a-z]/g, function(letter) {
		return letter.toUpperCase();
	});
	$('#EventEventTitle').val(last1 + ' / ' + last2 + ' ' + type);
}
$('#EventLastName, #EventCoLastName').on('keyup', updateTitle);
$('#EventEventType').on('change', updateTitle);
$('#EventEventTitle').on('change', function() {
	titleChange = false;
});
<?php endif; ?>
<?php $this->Html->scriptEnd(); ?>
