ALTER TABLE `weddings`
  DROP `email`,
  DROP `password`;

ALTER TABLE `events` CHANGE `groom_family_name` `co_last_name` VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;
ALTER TABLE `events` CHANGE `bride_family_name` `last_name` VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;

-- move columns above

ALTER TABLE `events` ADD `first_name` VARCHAR(50) NULL DEFAULT NULL AFTER `slug`;
ALTER TABLE `events` ADD `co_first_name` VARCHAR(50) NULL DEFAULT NULL AFTER `last_name`;

ALTER TABLE `events` ADD `event_type` VARCHAR(50) NULL DEFAULT NULL AFTER `slug`, ADD `event_title` VARCHAR(255) NOT NULL AFTER `event_type`, ADD `event_location` VARCHAR(255) NOT NULL AFTER `event_title`;

ALTER TABLE `guests` CHANGE `wedding_id` `event_id` INT(11) NOT NULL;


-- default type and title
UPDATE `events` SET event_type = 'wedding', event_title = CONCAT(last_name, ' / ', co_last_name, ' Wedding')
WHERE event_type IS NULL;

-- event additional fields
ALTER TABLE `events` ADD `event_start_time` TIME NULL DEFAULT NULL AFTER `event_date`, ADD `event_end_time` TIME NULL DEFAULT NULL AFTER `event_start_time`, ADD `event_timezone` VARCHAR(50) NULL DEFAULT NULL AFTER `event_end_time`;

ALTER TABLE `events` ADD `event_notes` TEXT NULL DEFAULT NULL AFTER `event_venue`;
