<?php
/**
 *	Plugin Name: Handler List Plugin
 *	Plugin URI: http://vanskyhawk.com/handler-list
 *	Description: Show list of handlers
 *	Version: 1.1
 *	Author: Brad Van Skyhawk
 *	Author URI: http://vanskyhawk.com
 *	License: GPL2
 *
 */
class TVG_HandlerList 
{

/**
 * __construct - plugin setup
 */
 	public function __construct() {

 		add_shortcode( 'handler-list', array( $this, 'handlerList' ) );

 	}
 	
/**
 * handlerList method - shortcode
 */
	public function handlerList( $atts, $content = null ) {

		extract( shortcode_atts( array(
			//'tooltip' => 'on'
		), $atts ) );

		ob_start();
		// The Query
		$args = array(
			'post_type' => 'handler',
			'order' => 'ASC',
			'orderby' => 'title',
			'nopaging' => true
		);
		$the_query = new WP_Query( $args );
		
		// The Loop
		if ( $the_query->have_posts() ) {
			echo '<table><tr><thead><td><strong>Handlers</strong></td><td><strong>Dogs</strong></td><td><strong>Breed</strong></td><td><strong>Description</strong></td><td><strong>Photo</strong></td></thead></tr><tbody>';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$id = get_the_ID();
				echo '<tr>';
				echo '<td style="vertical-align:top">' . get_the_title()  . '</td>';
				echo '<td style="vertical-align:top">' . get_post_meta( $id, 'dogs', true ) . '</td>';
				echo '<td style="vertical-align:top">' . get_post_meta( $id, 'breed', true )  . '</td>';
				echo '<td style="vertical-align:top">' . get_post_meta( $id, 'description', true )  . '</td>';
				$image = wp_get_attachment_image_src( get_post_meta( $id, 'photo', true ) ,'thumbnail', true );
				echo '<td><img src="' . $image[0] . '"></td>';
				echo '</tr>';
			}
			echo '</tbody></table>';
		} else {
			// no posts found
		}
		/* Restore original Post Data */
		wp_reset_postdata();
		
		$content = ob_get_clean();

		return $content;

	}
	
/**
 * __getHandlers method
 */
 	protected function _getHandlers() {
	 	
 	}
}

// Start the plugin
new TVG_HandlerList();
