<?php
/**
 * Template Name: Homepage Template
 * @package Collections
 */
get_header();
$collections_homepage_query = new Collections_Homepage_Query(); ?>

<div id="main-header" role="banner">
	<div class="frame header-wrapper">
		<nav id="nav">
			<?php
			wp_nav_menu( array(
				'theme_location' => 'collections-homepage',
				'container_id'   => 'collections-nav',
				'menu_class'     => 'nav',
			) );
			?>
		</nav>
		<div class="logo-wrapper">
			<?php if ( collections_get_logo()->has_logo() ) : ?>
				<a class="custom-logo" title="<?php esc_attr_e( 'Home', 'collections' ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>"></a>
			<?php else : ?>
				<a title="<?php esc_attr_e( 'Home', 'collections' ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
				</a>
			<?php endif; ?>
			<?php if ( get_bloginfo( 'description' ) ) : ?>
				<span class="collections-tagline">
					<?php bloginfo( 'description' ); ?>
				</span>
			<?php endif; ?>
		</div>
	</div>
</div>

<section class="column-one">
	<?php foreach ( $collections_homepage_query->split_queries['left'] as $collections_type => $collections_type_query ) : ?>
		<?php get_template_part( '_homepage', 'column' ); ?>
	<?php endforeach; ?>
</section>

<section class="column-two">
	<?php foreach ( $collections_homepage_query->split_queries['right'] as $collections_type => $collections_type_query ) : ?>
		<?php get_template_part( '_homepage', 'column' ); ?>
	<?php endforeach; ?>
</section>

<?php if ( 0 === get_theme_mod( 'hide-about-section', 0 )  ) : ?>
<div class="info">
	<section class="search">
		<?php get_template_part( '_secondary-searchform' ); ?>
	</section>
	<section class="archive">
		<a href="<?php echo collections_get_stream_url(); ?>">
			<h4><?php _e( 'Archive', 'collections' ); ?></h4>
		</a>
	</section>
	<section class="about">
		<div class="collections-avatar-wrapper">
			<?php $thumb = get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); ?>
			<?php if ( '' !== $thumb ) : ?>
				<?php echo $thumb; ?>
			<?php endif; ?>
		</div>

		<?php the_content(); ?>
	</section>
</div>
<?php endif; ?>

<?php get_footer(); ?>