<?php

class CoboEnParentsController
{
  function CoboEnParentsController()
  {
    add_action( 'init', array( &$this, 'register_parent_type' ), 0 );
    add_action( 'manage_pages_custom_column', array(&$this, 'custom_columns'), 10, 2 );
    add_filter( 'manage_edit-coboenparent_columns', array(&$this, 'columns') );
    add_action( 'save_post', array(&$this, 'save_postdata') );
  }

  function register_parent_type()
  {
    register_post_type( 'coboenparent',
      array(
        'labels' => array(
          'name' => __( 'Parents' ),
          'singular_name' => __( 'Parent' ),
          'add_new_item' => __('Add New Parent'),
          'edit_item' => __('Edit Parent'),
          'new_item' => __('New Parent'),
          'view_item' => __('View Parent'),
          'search_items' => __('Search Parent'),
          'not_found' => __('No Parent found'),
          'not_found_in_trash' => __('No Parent found in Trash'),
          'parent_item_colon' => __('Parent Parent:')
        ),
        'public' => false,
        'show_ui' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'register_meta_box_cb' => array(&$this, 'add_meta_boxes'),
        'rewrite' => false,
        'supports' => array('none'),
        'menu_icon' => COBOEN_URL . "/images/coboen-16.png"
      )
    );
  }

  function columns($columns)
  {
    $columns = array(
      "cb" => "<input type=\"checkbox\" />",
      "title" => "Edit",
      "pname"  => "Name",
      "pemail"  => "Email",
      "pcity"  => "City",
      "pstate" => "State",
      "pfounder" => "Founder",
    );
    return $columns;
  }

  function custom_columns($column, $post_id)
  {
    $post = get_post($post_id);

    $_coboen_first_name  = get_post_meta( $post_id, '_coboen_first_name',  true );
    $_coboen_last_name   = get_post_meta( $post_id, '_coboen_last_name',   true );
    $_coboen_city        = get_post_meta( $post_id, '_coboen_city',        true );
    $_coboen_state       = get_post_meta( $post_id, '_coboen_state',       true );
    $_coboen_email       = get_post_meta( $post_id, '_coboen_email',       true );
    $_coboen_founder     = get_post_meta( $post_id, '_coboen_founder',     true );

    if     ("ID" == $column)    echo $post->ID;
    elseif ("pname" == $column)  echo "{$_coboen_first_name} {$_coboen_last_name}";
    elseif ("pcity" == $column)  echo $_coboen_city;
    elseif ("pstate" == $column) echo $_coboen_state;
    elseif ("pemail" == $column) echo $_coboen_email;
    elseif ("pfounder" == $column) echo $_coboen_founder?'Yes':'No';
  }

  function add_meta_boxes()
  {
    add_meta_box("coboen-parent-meta", __("Parent Options"), array(&$this, "parent_meta_box"), "coboenparent", "normal", "high");
  }

  function save_postdata($post_id)
  {
    $post = get_post($post_id);
    
    if($post->post_type == 'coboenparent')
    {
      extract($_POST);
      update_post_meta( $post_id, '_coboen_first_name',  $_coboen_first_name );
      update_post_meta( $post_id, '_coboen_last_name',   $_coboen_last_name );
      update_post_meta( $post_id, '_coboen_spouse_name', $_coboen_spouse_name );
      update_post_meta( $post_id, '_coboen_address',     $_coboen_address );
      update_post_meta( $post_id, '_coboen_city',        $_coboen_city );
      update_post_meta( $post_id, '_coboen_state',       $_coboen_state );
      update_post_meta( $post_id, '_coboen_zip_code',    $_coboen_zip_code );
      update_post_meta( $post_id, '_coboen_home_phone',  $_coboen_home_phone );
      update_post_meta( $post_id, '_coboen_other_phone', $_coboen_other_phone );
      update_post_meta( $post_id, '_coboen_email',       $_coboen_email );
      update_post_meta( $post_id, '_coboen_founder',     $_coboen_founder );
    }
  }

  function parent_meta_box()
  {
    // TODO: Add jQuery Validation to this form dude
    global $post_id;

    $_coboen_first_name  = get_post_meta( $post_id, '_coboen_first_name',  true );
    $_coboen_last_name   = get_post_meta( $post_id, '_coboen_last_name',   true );
    $_coboen_spouse_name = get_post_meta( $post_id, '_coboen_spouse_name', true );
    $_coboen_address     = get_post_meta( $post_id, '_coboen_address',     true );
    $_coboen_city        = get_post_meta( $post_id, '_coboen_city',        true );
    $_coboen_state       = get_post_meta( $post_id, '_coboen_state',       true );
    $_coboen_zip_code    = get_post_meta( $post_id, '_coboen_zip_code',    true );
    $_coboen_home_phone  = get_post_meta( $post_id, '_coboen_home_phone',  true );
    $_coboen_other_phone = get_post_meta( $post_id, '_coboen_other_phone', true );
    $_coboen_email       = get_post_meta( $post_id, '_coboen_email',       true );
    $_coboen_founder     = get_post_meta( $post_id, '_coboen_founder',     true );

    require(COBOEN_VIEWS_PATH . '/coboen-parents/form.php');
  }
}

?>
