<?php

class CoboEnStudentsController
{
  function CoboEnStudentsController()
  {
    add_action( 'init', array( &$this, 'register_student_type' ), 0 );
    add_action( 'manage_pages_custom_column', array(&$this, 'custom_columns'), 10, 2 );
    add_filter( 'manage_edit-coboenstudent_columns', array(&$this, 'columns') );
    add_action( 'save_post', array(&$this, 'save_postdata') );
  }

  function register_student_type()
  {
    register_post_type( 'coboenstudent',
      array(
        'labels' => array(
          'name' => __( 'Students' ),
          'singular_name' => __( 'Student' ),
          'add_new_item' => __('Add New Student'),
          'edit_item' => __('Edit Student'),
          'new_item' => __('New Student'),
          'view_item' => __('View Student'),
          'search_items' => __('Search Student'),
          'not_found' => __('No Student found'),
          'not_found_in_trash' => __('No Student found in Trash'),
          'student_item_colon' => __('Student Student:')
        ),
        'public' => false,
        'show_ui' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'register_meta_box_cb' => array(&$this, 'add_meta_boxes'),
        'rewrite' => false,
        'supports' => array('none'),
        'menu_icon' => COBOEN_URL . "/images/coboen-16.png"
      )
    );
  }

  function columns($columns)
  {
    $columns = array(
      "cb"     => "<input type=\"checkbox\" />",
      "title"  => "Edit",
      "sname"   => "Name",
      "sparent" => "Parent",
      "sgender" => "Gender",
      "sdob"    => "Birth Date",
      "syear"   => "School Year",
      "sgrade"  => "Grade"
    );
    return $columns;
  }

  function custom_columns($column, $post_id)
  {
    $post = get_post($post_id);
    $_coboen_parent_id  = get_post_meta( $post_id, '_coboen_parent_id',  true );
    $_coboen_first_name = get_post_meta( $post_id, '_coboen_first_name', true );
    $_coboen_last_name  = get_post_meta( $post_id, '_coboen_last_name',  true );
    $_coboen_gender     = get_post_meta( $post_id, '_coboen_gender',     true );
    $_coboen_dob        = get_post_meta( $post_id, '_coboen_dob',        true ); 
    $_coboen_year       = get_post_meta( $post_id, '_coboen_year',       true );
    $_coboen_grade      = get_post_meta( $post_id, '_coboen_grade',      true );
    $_coboen_parent_first_name = get_post_meta( $_coboen_parent_id, '_coboen_first_name', true );
    $_coboen_parent_last_name  = get_post_meta( $_coboen_parent_id, '_coboen_last_name',  true );

    if     ("ID"     == $column) echo $post->ID;
    elseif ("sname"   == $column) echo "{$_coboen_first_name} {$_coboen_last_name}";
    elseif ("sparent" == $column) echo "{$_coboen_parent_first_name} {$_coboen_parent_last_name}";
    elseif ("sgender" == $column) echo $_coboen_gender;
    elseif ("sdob"    == $column) echo $_coboen_dob;
    elseif ("syear"   == $column) echo $_coboen_year;
    elseif ("sgrade"  == $column) echo $_coboen_grade;
  }

  function add_meta_boxes()
  {
    add_meta_box("coboen-student-meta", __("Student Options"), array(&$this, "student_meta_box"), "coboenstudent", "normal", "high");
  }

  function save_postdata($post_id)
  {
    global $coboen_config;

    $post = get_post($post_id);
    
    if($post->post_type == 'coboenstudent')
    {
      extract($_POST);
      update_post_meta( $post_id, '_coboen_parent_id',  $_coboen_parent_id );
      update_post_meta( $post_id, '_coboen_first_name', stripslashes($_coboen_first_name) );
      update_post_meta( $post_id, '_coboen_last_name',  stripslashes($_coboen_last_name) );
      update_post_meta( $post_id, '_coboen_gender',     stripslashes($_coboen_gender) );
      update_post_meta( $post_id, '_coboen_dob',        stripslashes($_coboen_dob) );
      update_post_meta( $post_id, '_coboen_year',       stripslashes($_coboen_year) );
      update_post_meta( $post_id, '_coboen_grade',      stripslashes($_coboen_grade) );

      if( isset($coboen_config['show_district_info']) and $coboen_config['show_district_info'] )
        update_post_meta( $post_id, '_coboen_district', stripslashes($_coboen_district) );
    }
  }

  function student_meta_box()
  {
    // TODO: Add jQuery Validation to this form dude
    global $coboen_config, $post_id;

    $_coboen_parent_id  = get_post_meta( $post_id, '_coboen_parent_id',  true );
    $_coboen_first_name = get_post_meta( $post_id, '_coboen_first_name', true );
    $_coboen_last_name  = get_post_meta( $post_id, '_coboen_last_name',  true );
    $_coboen_gender     = get_post_meta( $post_id, '_coboen_gender',     true );
    $_coboen_dob        = get_post_meta( $post_id, '_coboen_dob',        true ); 
    $_coboen_year       = get_post_meta( $post_id, '_coboen_year',       true );
    $_coboen_grade      = get_post_meta( $post_id, '_coboen_grade',      true );

    if( isset($coboen_config['show_district_info']) and $coboen_config['show_district_info'] )
      $_coboen_district = get_post_meta( $post_id, '_coboen_district', true );

    require(COBOEN_VIEWS_PATH . '/coboen-students/form.php');
  }
}

?>
