<?php
class WafpDb
{
  var $links;
  var $clicks;
  var $transactions;
  var $payments;
  
  function WafpDb()
  {
    global $wpdb;

    $this->links        = "{$wpdb->prefix}wafp_links";
    $this->clicks       = "{$wpdb->prefix}wafp_clicks";
    $this->transactions = "{$wpdb->prefix}wafp_transactions";
    $this->payments     = "{$wpdb->prefix}wafp_payments";
  }
  
  function upgrade()
  {
    global $wpdb;
    
    $db_version = 6; // this is the version of the database we're moving to
    $old_db_version = get_option('wafp_db_version');

    if($db_version != $old_db_version)
    {
      $this->before_upgrade($old_db_version);

      $charset_collate = '';
      if( $wpdb->has_cap( 'collation' ) )
      {
        if( !empty($wpdb->charset) )
          $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
        if( !empty($wpdb->collate) )
          $charset_collate .= " COLLATE $wpdb->collate";
      }
      
      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      
      /* Create/Upgrade Clicks Table */
      $sql = "CREATE TABLE {$this->clicks} (
                id int(11) NOT NULL auto_increment,
                ip varchar(255) default NULL,
                browser varchar(255) default NULL,
                referrer varchar(255) default NULL,
                uri varchar(255) default NULL,
                robot tinyint default 0,
                first_click tinyint default 0,
                created_at datetime NOT NULL,
                link_id int(11) default NULL,
                affiliate_id int(11) default NULL,
                PRIMARY KEY  (id),
                KEY link_id (link_id),
                KEY created_at (created_at),
                KEY affiliate_id (affiliate_id)
              ) {$charset_collate};";

      dbDelta($sql);
      
      /* Create/Upgrade Friend Requests Table */
      $sql = "CREATE TABLE {$this->links} (
                id int(11) NOT NULL auto_increment,
                target_url text NOT NULL,
                image text default NULL,
                width int(11) default NULL,
                height int(11) default NULL,
                created_at datetime NOT NULL,
                PRIMARY KEY  (id)
              ) {$charset_collate};";
      
      dbDelta($sql);
      
      /* Create/Upgrade Board Posts Table */
      $sql = "CREATE TABLE {$this->transactions} (
                id int(11) NOT NULL auto_increment,
                affiliate_id int(11) NOT NULL,
                item_name varchar(255) DEFAULT NULL,
                sale_amount float(9,2) NOT NULL,
                commission_amount float(9,2) NOT NULL,
                refund_amount float(9,2) DEFAULT 0.00,
                correction_amount float(9,2) DEFAULT 0.00,
                commission_percentage int(11) DEFAULT 33,
                payment_id int(11) DEFAULT 0,
                ip_addr varchar(255) DEFAULT NULL,
                cust_email varchar(255) DEFAULT NULL,
                cust_name varchar(255) DEFAULT NULL,
                trans_num varchar(255) DEFAULT NULL,
                subscr_id varchar(255) DEFAULT NULL,
                type varchar(255) DEFAULT NULL,
                status varchar(255) DEFAULT NULL,
                response text DEFAULT NULL,
                created_at datetime NOT NULL,
                PRIMARY KEY  (id),
                KEY affiliate_id (affiliate_id),
                KEY payment_id (payment_id),
                KEY trans_num (trans_num),
                KEY created_at (created_at),
                KEY type (type)
              ) {$charset_collate};";
      
      dbDelta($sql);

      /* Create/Upgrade Board Posts Table */
      $sql = "CREATE TABLE {$this->payments} (
                id int(11) NOT NULL auto_increment,
                affiliate_id int(11) NOT NULL,
                amount float(9,2) NOT NULL,
                created_at datetime NOT NULL,
                PRIMARY KEY  (id),
                KEY created_at (created_at),
                KEY affiliate_id (affiliate_id)
              ) {$charset_collate};";
      
      dbDelta($sql);
      
      $this->after_upgrade($old_db_version);
    }
    
    /***** SAVE DB VERSION *****/
    //update_option('wafp_db_version',$db_version);
  }
  
  function before_upgrade($curr_db_version)
  {
    // Nothing here yet
  }
  
  function after_upgrade($curr_db_version)
  {
    // Nothing here yet
  }

  function create_record($table, $args, $record_created_at=true)
  {
    global $wpdb;
  
    $cols = array();
    $vars = array();
    $values = array();
  
    $i = 0;
    foreach($args as $key => $value)
    {  
      $cols[$i] = $key;
      if(is_float($value))
        $vars[$i] = '%f';
      else if(is_int($value))
        $vars[$i] = '%d';
      else
        $vars[$i] = '%s';
      $values[$i] = $value;
      $i++;
    }
  
    if($record_created_at)
    {
      $cols[$i] = 'created_at';
      $vars[$i] = 'NOW()';
    }
  
    if(empty($cols))
      return false;
  
    $cols_str = implode(',',$cols);
    $vars_str = implode(',',$vars);
  
    $query = "INSERT INTO {$table} ( {$cols_str} ) VALUES ( {$vars_str} )";
    $query = $wpdb->prepare( $query, $values );

    $query_results = $wpdb->query($query);
  
    if($query_results)
      return $wpdb->insert_id;
    else
      return false;
  }
  
  function update_record( $table, $id, $args )
  {
    global $wpdb;
  
    if(empty($args) or empty($id))
      return false;
  
    $set = '';
    $values = array();
    foreach($args as $key => $value)
    {
      if(empty($set))
        $set .= ' SET';
      else
        $set .= ',';
  
      $set .= " {$key}=";
  
      if(is_float($value))
        $set .= "%f";
      else if(is_int($value))
        $set .= "%d";
      else
        $set .= "%s";
  
      $values[] = $value;
    }
  
    $values[] = $id;
    $query = "UPDATE {$table}{$set} WHERE id=%d";
  
    $query = $wpdb->prepare( $query, $values );
  
    return $wpdb->query($query);
  }
  
  function delete_records($table, $args)
  {
    global $wpdb;
    extract(WafpDb::get_where_clause_and_values( $args ));

    $query = "DELETE FROM {$table}{$where}";
    $query = $wpdb->prepare($query, $values);

    return $wpdb->query($query);
  }
  
  function get_count($table, $args=array())
  {
    global $wpdb;
    extract(WafpDb::get_where_clause_and_values( $args ));
    
    $query = "SELECT COUNT(*) FROM {$table}{$where}";
    $query = $wpdb->prepare($query, $values);
    return $wpdb->get_var($query);
  }
  
  function get_where_clause_and_values( $args )
  {
    $where = '';
    $values = array();
    foreach($args as $key => $value)
    {
      if(!empty($where))
        $where .= ' AND';
      else
        $where .= ' WHERE';
  
      $where .= " {$key}=";
  
      if(is_float($value))
        $where .= "%f";
      else if(is_int($value))
        $where .= "%d";
      else
        $where .= "%s";
  
      $values[] = $value;
    }
    
    return compact('where','values');
  }
  
  function get_one_record($table, $args=array())
  {
    global $wpdb;

    extract(WafpDb::get_where_clause_and_values( $args ));

    $query = "SELECT * FROM {$table}{$where} LIMIT 1";
    $query = $wpdb->prepare($query, $values);
    return $wpdb->get_row($query);
  }
  
  function get_records($table, $args=array(), $order_by='', $limit='')
  {
    global $wpdb;

    extract(WafpDb::get_where_clause_and_values( $args ));
  
    if(!empty($order_by))
      $order_by = " ORDER BY {$order_by}";
  
    if(!empty($limit))
      $limit = " LIMIT {$limit}";
  
    $query = "SELECT * FROM {$table}{$where}{$order_by}{$limit}";
    $query = $wpdb->prepare($query, $values);
    return $wpdb->get_results($query);
  }
}
?>
