<?php
/*
Plugin Name: Student Enrollment
Plugin URI: http://codeboiler.com
Description: Code Boiler Enrollment Plugin for Parents and students
Version: 1.1.20
Author: CodeBoiler
Author URI: http://codeboiler.com
Text Domain: cobo-enrollment
Copyright: 2010, Caseproof, LLC
*/

define('COBOEN_PLUGIN_NAME',"cobo-enrollment");
$coboen_script_url = get_option('home') . '/index.php?plugin=' . COBOEN_PLUGIN_NAME;
define('COBOEN_PATH',WP_PLUGIN_DIR.'/'.COBOEN_PLUGIN_NAME);
define('COBOEN_IMAGES_PATH',COBOEN_PATH.'/images');
define('COBOEN_CSS_PATH',COBOEN_PATH.'/css');
define('COBOEN_JS_PATH',COBOEN_PATH.'/js');
define('COBOEN_INCLUDES_PATH',COBOEN_PATH.'/includes');
define('COBOEN_I18N_PATH',COBOEN_PATH.'/i18n');
define('COBOEN_MODELS_PATH',COBOEN_PATH.'/classes/models');
define('COBOEN_CONTROLLERS_PATH',COBOEN_PATH.'/classes/controllers');
define('COBOEN_VIEWS_PATH',COBOEN_PATH.'/classes/views');
define('COBOEN_WIDGETS_PATH',COBOEN_PATH.'/classes/widgets');
define('COBOEN_HELPERS_PATH',COBOEN_PATH.'/classes/helpers');
define('COBOEN_URL',plugins_url($path = '/'.COBOEN_PLUGIN_NAME));
define('COBOEN_IMAGES_URL',COBOEN_URL.'/images');
define('COBOEN_CSS_URL',COBOEN_URL.'/css');
define('COBOEN_JS_URL',COBOEN_URL.'/js');
define('COBOEN_INCLUDES_URL',COBOEN_URL.'/includes');
define('COBOEN_SCRIPT_URL',$coboen_script_url);

// Load the Config
require_once(COBOEN_PATH . '/cobo-config.php');

// More Global variables
global $coboen_blogurl;
global $coboen_siteurl;
global $coboen_blogname;
global $coboen_blogdescription;

$coboen_blogurl         = ((get_option('home'))?get_option('home'):get_option('siteurl'));
$coboen_siteurl         = get_option('siteurl');
$coboen_blogname        = get_option('blogname');
$coboen_blogdescription = get_option('blogdescription');

require_once(COBOEN_CONTROLLERS_PATH . "/CoboEnParentsController.php");
require_once(COBOEN_CONTROLLERS_PATH . "/CoboEnStudentsController.php");

global $coboen_parents_controller;
global $coboen_students_controller;

$coboen_parents_controller  = new CoboEnParentsController();
$coboen_students_controller = new CoboEnStudentsController();

add_action('wp_enqueue_scripts', 'coboen_load_scripts', 1); 
add_action('admin_enqueue_scripts', 'coboen_load_scripts', 1); 
add_shortcode('coboen-enrollment', 'coboen_enrollment_form');
add_shortcode('coboen-status', 'coboen_status');
add_action('init', 'coboen_parse_standalone_request');
add_action( 'admin_menu', 'coboen_menu' );

function coboen_menu()
{
  add_options_page( 'Enrollment Status', 'Enrollment Status', 'administrator', 'coboen_status', 'coboen_status' );
  add_options_page( 'Student CSV', 'Student CSV', 'administrator', 'coboen_student_csv', 'coboen_student_csv' );
}

function coboen_status()
{
  global $wpdb;

  $sql = "SELECT COUNT(meta_key) as num_students, meta_value as grade FROM $wpdb->postmeta WHERE meta_key=%s GROUP BY meta_value";
  $sql = $wpdb->prepare($sql, '_coboen_grade');

  $results = $wpdb->get_results($sql);

?>
<h2>Enrollment Status</h2>

<table>
  <tr><td><strong><?php _e('Grade'); ?></strong></td><td>&nbsp;</td><td><strong><?php _e('# Enrollments'); ?></strong></td></tr>
<?php

  foreach($results as $result)
  {
?>
  <tr><td><strong><?php echo $result->grade; ?></strong></td><td>&nbsp;</td><td><?php echo $result->num_students; ?></td></tr>
<?php
  }
?>
</table>
<?php
}

/**
 * Generate a CSV file with all of current student data.
 */
function coboen_student_csv()
{
  global $wpdb;
   
  $csv_data = array();
  
  $sql_parent = "SELECT ID FROM $wpdb->posts WHERE post_type=%s";
  $sql_meta = "SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=%s";
  $sql_date = "SELECT post_date FROM $wpdb->posts WHERE ID=%s";
  $sql_id = "SELECT post_id FROM $wpdb->postmeta WHERE meta_key='_coboen_parent_id' AND meta_value=%s";
  
  $sql = $wpdb->prepare($sql_parent, 'coboenparent');
  $parents = $wpdb->get_col($sql);
  foreach ($parents as $parent_id)
  {
    // Build parent list
    $sql = $wpdb->prepare($sql_meta, $parent_id);
    $key = $wpdb->get_col($sql);
    $val = $wpdb->get_col(null, 1);
    $parent_data = array_merge(array('_coboen_id' => $parent_id), array_combine($key, $val));
    
    // Find the students
    $sql = $wpdb->prepare($sql_id, $parent_id);
    $student_ids = $wpdb->get_col($sql);
    if ($student_ids)
    {
      foreach ($student_ids as $id)
      {
      	// get enrollment date
      	$sql = $wpdb->prepare($sql_date, $id);
      	$enroll_date = $wpdb->get_var($sql);
      	
        // Build student list
        $sql = $wpdb->prepare($sql_meta, $id);
        $key = $wpdb->get_col($sql);
        $val = $wpdb->get_col(null, 1);
        $student_data = array_merge(array('_coboen_id' => $id), array_combine($key, $val));
        $student_data['_coboen_enrollment_date'] = $enroll_date;
        
        $csv_data[] = array('Parent' => $parent_data, 'Student' => $student_data);
      }
    }
  }
  
  if (count($csv_data) == 0)
  {
    echo 'No Students found.';
    return;
  }
  
  // Output the CSV file
  $file_name = 'StudentData.csv';
  $i = 0;
  $parent_keys = array('_coboen_id', '_coboen_first_name', '_coboen_last_name', '_coboen_spouse_name', '_coboen_address', '_coboen_city', '_coboen_state', '_coboen_zip_code', '_coboen_home_phone', '_coboen_other_phone', '_coboen_email', '_coboen_founder');
  $student_keys = array('_coboen_id', '_coboen_first_name', '_coboen_last_name', '_coboen_gender', '_coboen_dob', '_coboen_year', '_coboen_grade', '_coboen_district', '_coboen_enrollment_date');
  foreach ($csv_data as $csv)
  {
    // CSV header
    if (!$i)
    {
      $i++;
      $csv_file = '"' . str_replace('_coboen', 'parent', implode('","', $parent_keys)) . '","' . str_replace('_coboen', 'student', implode('","', $student_keys)) . '"' . "\n";
    }

    $parent = array();
    foreach ($parent_keys as $p)
    {
      $parent[$p] = isset($csv['Parent'][$p]) ? $csv['Parent'][$p] : '';
    }
    $student = array();
    foreach ($student_keys as $s)
    {
      $student[$s] = isset($csv['Student'][$s]) ? $csv['Student'][$s] : '';
    }
    
    $csv_file .= '"' . str_replace('_coboen', 'parent', implode('","', $parent)) . '","' . str_replace('_coboen', 'student', implode('","', $student)) . '"' . "\n";
  }
  
  $file_name = 'StudentData.csv';
  header("Content-type: application/octet-stream");
  if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE"))
  {
    header('Content-Disposition: attachment; filename="'.$file_name.'"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
  }
  else
  {
    header('Content-Disposition: attachment; filename="'.$file_name.'"');
    header('Pragma: no-cache');
  }
  header('Expires: 0');
  echo $csv_file;
  
  /*
  echo '<h2>Student Data Export</h2>', '<p>Click to select the data below. Press Ctrl+C to copy the data and then paste it into a new Excel file.</p>';
  echo '<pre id="pre" style="background: white; border 1px solid #ddd; clear: both; height: 240px; overflow: auto; padding: 10px; width: 90%" onclick="containerSelect(this)">', $csv_file, '</pre>';
  */
}

//register_activation_hook(COBOEN_PATH."/coboen-enrollment.php", 'coboen_install' );

/*
function coboen_install()
{
*/
  /*
  global $wpdb;
  $db_version = 1; // this is the version of the database we're moving to
  $old_db_version = get_option('coboen_db_version');

  $students_table = $wpdb->prefix . "coboen_students";

  $charset_collate = '';
  if( $wpdb->has_cap( 'collation' ) )
  {
    if( !empty($wpdb->charset) )
      $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
    if( !empty($wpdb->collate) )
      $charset_collate .= " COLLATE $wpdb->collate";
  }

  if($db_version != $old_db_version)
  {
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

    /* Create/Upgrade Friends Table */
    /*
    $sql = "CREATE TABLE {$students_table} (
             id int(11) NOT NULL auto_increment,
             user_id int(11) NOT NULL,
             first_name varchar(255) NOT NULL,
             last_name varchar(255) NOT NULL,
             gender varchar(255) NOT NULL,
             dob date NOT NULL,
             year varchar(255) NOT NULL,
             grade varchar(255) NOT NULL,
             created_at datetime NOT NULL,
             PRIMARY KEY  (id),
             KEY user_id (user_id)
    ) {$charset_collate};";

    dbDelta($sql);
  }

  /***** SAVE DB VERSION *****/
  /*
  delete_option('coboen_db_version');
  add_option('coboen_db_version',$db_version);
  */
/*
}
*/

function coboen_load_scripts()
{
  wp_enqueue_style( 'jquery-ui-1.7.2', COBOEN_CSS_URL . '/jquery/smoothness/jquery-ui-1.7.2.custom.css' );
  wp_enqueue_script( 'jquery-ui-1.7.2', COBOEN_JS_URL . '/jquery/jquery-ui-1.7.2.custom.min.js', array('jquery') );
  wp_enqueue_script( 'coboen-enrollment', COBOEN_JS_URL . '/coboen-enrollment.js', array('jquery-ui-1.7.2') );
}

function coboen_parse_standalone_request()
{
  $plugin     = (isset($_REQUEST['plugin'])?$_REQUEST['plugin']:'');
  $action     = (isset($_REQUEST['action'])?$_REQUEST['action']:'');
  $controller = (isset($_REQUEST['controller'])?$_REQUEST['controller']:'');
  $page = (isset($_REQUEST['page'])?$_REQUEST['page']:'');

  if( !empty($plugin) and
      $plugin == COBOEN_PLUGIN_NAME and 
      !empty($controller) and
      !empty($action) )
  {
    if($controller=='students')
    {
      if($action=='add_student')
        coboen_add_student_form($_POST['key']);
    }
    exit;
  }
  
  if ($page == 'coboen_student_csv')
  {
    coboen_student_csv();
    exit;
  }
}

function coboen_add_student_form($key, $hide_add_button=false, $params=array())
{
    global $coboen_config;
?>
<div id="student-row-<?php echo $key; ?>" style="border: 1px solid #555555; margin: 5px 0 0 0; padding: 5px 10px 10px 10px; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px;">
<script type="text/javascript">
  jQuery(document).ready(function() {
    jQuery("#coboen-datepicker-<?php echo $key; ?>").datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, defaultDate: '-4y' });
  });
</script>

  <div style="float: right;<?php echo ($key==1)?" display: none;":''; ?>"><a href="javascript:coboen_remove_tag('#student-row-<?php echo $key; ?>')"><img src="<?php echo COBOEN_IMAGES_URL; ?>/remove.png" /></a></div>
  <div style="font-size: 14px; font-weight: bold;"><?php _e('Player'); echo ($key==1)?'':" #{$key}"; ?></div>
  <table valign="top" style="width: 100%"> 
    <tr>
      <th valign="top" align="right"><?php _e('First Name'); ?>:</th> 
      <td valign="top" align="center" class="required">*</td> 
      <td valign="top"><input type="text" name="students[<?php echo $key; ?>][first_name]" id="students[<?php echo $key; ?>][first_name]" size="15" maxlength="30" value="<?php echo $params['first_name']; ?>"></td> 
    </tr>
    <tr>
      <th valign="top" align="right"><?php _e('Last Name'); ?>:</th> 
      <td valign="top" align="center" class="required">*</td> 
      <td><input type="text" name="students[<?php echo $key; ?>][last_name]" id="students[<?php echo $key; ?>][last_name]" size="15" maxlength="30" value="<?php echo $params['last_name']; ?>"></td> 
    </tr>
    <tr>
      <th valign="top" align="right"><?php _e('Gender'); ?>:</th> 
      <td valign="top" align="center" class="required">*</td> 
      <td><select name="students[<?php echo $key; ?>][gender]"$ id="students[<?php echo $key; ?>][gender]"> 
              <option value="0">-- Select --</option> 
              <option value="Female"<?php echo ((isset($params['gender']) and $params['gender'] == 'Female')?" selected=true":''); ?>>Female</option> 
              <option value="Male"<?php echo ((isset($params['gender']) and $params['gender'] == 'Male')?" selected=true":''); ?>>Male</option> 
          </select> 
      </td> 
    </tr>
    <tr>
      <th valign="top" align="right"><?php _e('Birth Date'); ?>:</th> 
      <td valign="top" align="center" class="required">*</td> 
      <td><input type="text" name="students[<?php echo $key; ?>][dob]" id="coboen-datepicker-<?php echo $key; ?>" id="students[<?php echo $key; ?>][dob]" size="12" maxlength="30" value="<?php echo $params['dob']; ?>"></td> 
    </tr>
  </table>
</div>
<?php
  if(!$hide_add_button)
  {
?>
<div id="coboen-new-student" style="margin-top: 4px;"><a href="javascript:coboen_add_student('<?php echo COBOEN_SCRIPT_URL; ?>',<?php echo (int)$key + 1; ?>);">+ <?php _e('Add a Player'); ?></a></div>
<?php
  }
}

function coboen_enrollment_form()
{
  if(isset($_POST['action']) and $_POST['action'] == 'process')
    coboen_process_enrollment_form();
  else
    coboen_display_enrollment_form();
}

function coboen_display_enrollment_form()
{
  global $coboen_blogname, $coboen_config;
  $this_uri = str_replace( '%7E', '~', $_SERVER['REQUEST_URI']);
?>
<h2><?php echo $coboen_blogname; ?> Registration Form</h2>
<h3>Parent/Guardian Information</h3>
<p><?php echo $coboen_config['enrollment_text'] ?></p>
<form action="<?php echo $this_uri; ?>" method="POST">
<input type="hidden" name="action" value="process" />
<table border="0" cellpadding="3"> 
  <tr> 
    <th valign="top" align="right">Parent First Name:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_first_name" id="coboen_first_name" size="30" maxlength="30" value="<?php echo $_POST['coboen_first_name']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Parent Last Name:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_last_name" id="coboen_last_name" size="30" maxlength="30" value="<?php echo $_POST['coboen_last_name']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Spouse (if applicable):</th> 
    <td valign="top" align="center" class="required"></td> 
    <td valign="top"><input type="text" name="coboen_spouse_name" id="coboen_spouse_name" size="30" maxlength="45" value="<?php echo $_POST['coboen_spouse_name']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Street Address:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_address" id="coboen_address" size="30" maxlength="45" value="<?php echo $_POST['coboen_address']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">City:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_city" id="coboen_city" size="30" maxlength="45" value="<?php echo $_POST['coboen_city']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">State:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_state" id="coboen_state" size="3" maxlength="2" value="<?php echo (isset($_POST['coboen_state'])?$_POST['coboen_state']:''); ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Zip Code:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_zip_code" id="coboen_zip_code" size="12" maxlength="10" value="<?php echo $_POST['coboen_zip_code']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Home Phone:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_home_phone" id="coboen_home_phone" size="20" maxlength="15" value="<?php echo $_POST['coboen_home_phone']; ?>">&nbsp;(###-###-####)</td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Other Phone:</th> 
    <td valign="top" align="center" class="required"></td> 
    <td valign="top"><input type="text" name="coboen_other_phone" id="coboen_other_phone" size="20" maxlength="15" value="<?php echo $_POST['coboen_other_phone']; ?>">&nbsp;(###-###-####)</td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Email Address:</th> 
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="text" name="coboen_email" id="coboen_email" size="30" maxlength="45" value="<?php echo $_POST['coboen_email']; ?>"></td> 
  </tr> 
  <tr> 
    <th valign="top" align="right">Re-enter Email Address:</th> 
    <td valign="top" align="center" class="required"></td> 
    <td valign="top"><input type="text" name="coboen_email_confirm" id="coboen_email_confirm" size="30" maxlength="45" value="<?php echo $_POST['coboen_email_confirm']; ?>"></td> 
  </tr> 
  <tr>
<?php if( isset($coboen_config['terms_page_id']) and $coboen_config['terms_page_id'] > 0 ) {
        $terms_url = get_permalink($coboen_config['terms_page_id']);
?>
    <th valign="top" align="right">Accept <a href="<?php echo $terms_url; ?>" target="_blank">Terms &amp; Conditions</a>:</th> 
<?php } else { ?>
    <th valign="top" align="right">Accept Terms &amp; Conditions:</th> 
<?php } ?>
    <td valign="top" align="center" class="required">*</td> 
    <td valign="top"><input type="checkbox" name="coboen_accept" id="coboen_accept" class="hand"><label for="accept" class="answer" >&nbsp;(A check mark indicates agreement)</label></td> 
  </tr> 
</table> 

<div id="student-table" border="0"> 
<?php

if(isset($_POST['students']) and is_array($_POST['students']))
{
  $index = 1;
  foreach($_POST['students'] as $key => $student)
  {
    if($index >= count($_POST['students']))
      coboen_add_student_form($index, false, $student);
    else
      coboen_add_student_form($index, true, $student);

    $index++;
  }
}
else
  coboen_add_student_form(1);
?>
</div>
<br/>
<input type="submit" value="Submit" name="Enter Lottery" />
</form>
<?php
}

function coboen_validate_enrollment_form($values,$errors=array())
{
  extract($values);

  if(!isset($coboen_first_name) or empty($coboen_first_name))
    $errors[] = __("First Name can't be Blank");

  if(!isset($coboen_last_name) or empty($coboen_last_name))
    $errors[] = __("Last Name can't be Blank");
  
  if(!isset($coboen_address) or empty($coboen_address))
    $errors[] = __("Address can't be Blank");

  if(!isset($coboen_city) or empty($coboen_city))
    $errors[] = __("City can't be Blank");

  if(!isset($coboen_state) or empty($coboen_state))
    $errors[] = __("State can't be Blank");

  if(!isset($coboen_zip_code) or empty($coboen_zip_code))
    $errors[] = __("Zip Code can't be Blank");

  if(!isset($coboen_home_phone) or empty($coboen_home_phone))
    $errors[] = __("Home Phone can't be Blank");
  else if(!preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $coboen_home_phone))
    $errors[] = __("Home Phone must be in the format ###-###-####");

  if( isset($coboen_other_phone) and
      !empty($coboen_other_phone) and
      !preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $coboen_other_phone))
    $errors[] = __("Other Phone must be in the format ###-###-####");

  if(!isset($coboen_email) or empty($coboen_email))
    $errors[] = __("Email can't be Blank");

  if($coboen_email != $coboen_email_confirm)
    $errors[] = __("Email Address doesn't match the Email Address Confirmation");

  if(!isset($coboen_accept) or empty($coboen_accept))
    $errors[] = __("You must Accept the Terms & Conditions");

  $index = 1;
  foreach($students as $key => $student)
  {
    $errors = coboen_validate_student($index,$student,$errors);
    $index++;
  }

  return $errors;
}

function coboen_validate_student($key,$values,$errors=array())
{
  global $coboen_config;

  extract($values);

  if(!isset($first_name) or empty($first_name) or !$grade)
    $errors[] = sprintf(__('Player #%d: First Name can\'t be Blank.'), (int)$key);

  if(!isset($last_name) or empty($last_name) or !$grade)
    $errors[] = sprintf(__('Player #%d: Last Name can\'t be Blank.'), (int)$key);

  if(!isset($gender) or empty($gender) or !$grade)
    $errors[] = sprintf(__('Player #%d: Gender can\'t be Blank.'), (int)$key);

  if(!isset($dob) or empty($dob) or !$grade)
    $errors[] = sprintf(__('Player #%d: Birth Date can\'t be Blank.'), (int)$key);

  return $errors;
}

function coboen_display_errors($errors)
{
?>
<h3 style="color: red;"><?php _e('There were some errors on your Enrollment Form:'); ?></h3>
<ul class="coboen_errors" style="color: red;">
<?php
foreach($errors as $error)
{
?>
  <li><?php echo $error; ?></li>
<?php
}
?>
</ul>
<?php
}

function coboen_create_student($parent_id, $student)
{
  global $wpdb, $coboen_config;

  extract($student);

  $student_id = wp_insert_post(array('post_title' => "{$first_name} {$last_name}", 'post_type' => 'coboenstudent', 'post_status' => 'publish', 'comment_status' => 'closed'));

  update_post_meta( $student_id, '_coboen_parent_id',  $parent_id );
  update_post_meta( $student_id, '_coboen_first_name', $first_name );
  update_post_meta( $student_id, '_coboen_last_name',  $last_name );
  update_post_meta( $student_id, '_coboen_gender',     $gender );
  update_post_meta( $student_id, '_coboen_dob',        $dob );
  update_post_meta( $student_id, '_coboen_year',       $year );
  update_post_meta( $student_id, '_coboen_grade',      $grade );

  if( isset($coboen_config['show_district_info']) and $coboen_config['show_district_info'] )
    update_post_meta( $student_id, '_coboen_district', $district );
}

function coboen_process_enrollment_form()
{
  global $wpdb;
  $errors = coboen_validate_enrollment_form($_POST);

  if(count($errors) > 0)
  {
    coboen_display_errors($errors);
    coboen_display_enrollment_form();
  }
  else // Process the Form!
  {
    //$random_password = generate_random_password();
    $random_password = wp_generate_password();

    extract($_POST);

    $parent_id = wp_insert_post(array('post_title' => "{$coboen_first_name} {$coboen_last_name}", 'post_type' => 'coboenparent', 'post_status' => 'publish', 'comment_status' => 'closed'));

    update_post_meta( $parent_id, '_coboen_first_name',  $wpdb->escape($coboen_first_name));
    update_post_meta( $parent_id, '_coboen_last_name',   $wpdb->escape($coboen_last_name));
    update_post_meta( $parent_id, '_coboen_spouse_name', $wpdb->escape($coboen_spouse_name));
    update_post_meta( $parent_id, '_coboen_address',     $wpdb->escape($coboen_address));
    update_post_meta( $parent_id, '_coboen_city',        $wpdb->escape($coboen_city));
    update_post_meta( $parent_id, '_coboen_state',       $wpdb->escape($coboen_state));
    update_post_meta( $parent_id, '_coboen_zip_code',    $wpdb->escape($coboen_zip_code));
    update_post_meta( $parent_id, '_coboen_home_phone',  $wpdb->escape($coboen_home_phone));
    update_post_meta( $parent_id, '_coboen_other_phone', $wpdb->escape($coboen_other_phone));
    update_post_meta( $parent_id, '_coboen_email',       $wpdb->escape($coboen_email));

    foreach($students as $student)
      coboen_create_student($parent_id, $student);

    send_email_notifications($_POST);
    coboen_display_thank_you();
  }
}

function send_email_notifications($userdata)
{
  global $coboen_blogname, $coboen_config;

  extract($userdata);

  $enrollment_info =<<<ENROLLMENT_INFO
First name: {$coboen_first_name}
Last Name: {$coboen_last_name}
Spouse Name: {$coboen_spouse_name}
Address: {$coboen_address}
City: {$coboen_city}
State: {$coboen_state}
Zip Code: {$coboen_zip_code}
Home Phone: {$coboen_home_phone}
Other Phone: {$coboen_other_phone}
Email: {$coboen_email}

ENROLLMENT_INFO;

  $index = 1;
  foreach($students as $student)
  {
    extract($student);
    $enrollment_info .=<<<ENROLLMENT_INFO

Player {$index}:
  First Name: {$first_name}
  Last Name: {$last_name}
  Gender: {$gender}
  Birth Date: {$dob}
ENROLLMENT_INFO;

  if(isset($coboen_config['show_district_info']) and $coboen_config['show_district_info']) {
    $enrollment_info .= "\n  Home District: {$district}\n";
  }
  
    $index++;
  }

/**** The Parent's Email ****/
  if(isset($coboen_config['from_email']) and $coboen_config['from_email'])
    $email_from = $coboen_config['from_email'];
  else
  {
    $admin_email = get_option('admin_email');
    $email_from    = "{$coboen_blogname} <{$admin_email}>";
  }

  $email_to = "{$coboen_first_name} {$coboen_last_name} <$coboen_email>";

  $email_subject = "Your Enrollment Information Was Successfully Received!";
  $email_body    =<<<EMAIL_BODY
{$coboen_first_name},

Congratulations! Successfully Your enrollment information has been received. A representative from Prospect Ridge Academy will be contacting you within 48 hours. Thank you.

We received the following information:

{$enrollment_info}

Thanks,

The {$coboen_blogname} Team
EMAIL_BODY;

/**** The Admin's Email ****/
  //$email_from    = "{$coboen_blogname} <{$admin_email}>";

  if(isset($coboen_config['to_email']) and $coboen_config['to_email'])
    $admin_email_to = $coboen_config['to_email'];
  else
    $admin_email_to = get_option('admin_email');

  $admin_email_subject = "A Parent Just Enrolled in the {$coboen_blogname} Lottery";
  $admin_email_body    =<<<EMAIL_BODY
A Parent just filled out the enrollment form on the {$coboen_blogname} Website.

We received the following information:

{$enrollment_info}

Thanks,

The {$coboen_blogname} Website
EMAIL_BODY;

  wp_mail( $email_to, $email_subject, $email_body, "From: {$email_from}\r\n\\" );
  wp_mail( $admin_email_to, $admin_email_subject, $admin_email_body, "From: {$admin_email_from}\r\n\\" );
}

function coboen_display_thank_you()
{
?>
<h2>Thanks For Enrolling</h2>
<p>Your enrollment information has been received. A representative from Prospect Ridge Academy will be contacting you within 48 hours. Thank you.
<?php
}

function pr($var)
{
  echo '<pre>';
  print_r($var);
  echo '</pre>';
}
?>
