<?php
/*
Plugin Name: Document Links Widget
Plugin URI: http://ransomdesign.com/
Version: 2.0.2
Author: Lorie Ransom
Description: Lists the documents in your media library as links, allowing site visitors to download your PDFs, Word Documents, ZIP Archives or other document types. Useful for offering white papers and technical documents on your blog or website.

/*  Copyright 2011  Lorie Ransom  (email :lorie@ransomdesign.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*General Description: This plugin finds all attachments in the database and displays those files in the Document Links administration panel, divided into four categories: PDF, Word Docs, ZIP archives and Other. The user can then chose which files they want to show up in the widget. In addition, the widget control allows the user to hide or show the main categories. 

The widget class extends the WordPress WP_Widget class, which automatically creates a multiwidget. The use of this built-in WordPress class means this plugin only works with WordPress versions 2.8 and later. 


/*------------------------------------------*/
/*-------------------Plugin-----------------*/
/*------------------------------------------*/


/**********************
*  BEGIN CLASS
***********************/
		
if (!class_exists("RD_Document_Links")){
	class RD_Document_Links{
		
		/**************************/
		/*  File type options	  */
		/**************************/
		
		//this array lists the mime types for the files you don't want to show. 
		//the default setting removes only image files, and is used to filter the results shown in the "Other" category.
		
		var $imageFiles	= array('image/jpeg', 'image/gif', 'image/png');			
		
		var $adminOptionsName = "rdDocumentLinksAdminOptions";	//var for new database option to store individual document information
		var $documentIconOptionsName = "rdDocumentIconOption"; 	//var for db option to store show or not show document icons
		var $listOrderOptionsName = "rdDocumentListOrderOption"; //var for db option storing ascending or descending list order
		
		
		function RD_Document_Links(){ 
		   // constructor		
		}
		

		/**
		 * For debugging
		 */
		function print_r2($val){
        	echo '<pre>';
        	print_r($val);
        	echo  '</pre>';
		}
		
		function rd_process_post_data(){
			$attachmentsInfoRows = $this->rd_query_db();
			
			/*ascending or desc order*/
			
			if (isset($_POST['update_RD_Document_Links'])){			
					if(($_POST['order'])=='ascending'){
						$listOrderOptions['display_order'] = "ascending";
						$this->sortOrder = 'ASC';
					}else{
						$listOrderOptions['display_order'] = "descending";
						$this->sortOrder = 'DESC';
					}
				update_option($this->listOrderOptionsName, $listOrderOptions);
			}
			
			/*show or hide icon*/
			
			$iconOptions = $this->rd_get_icons_option();//get icon option from DB. Returns a key value pair?
			if (isset($_POST['update_RD_Document_Links'])){
				if (isset($_POST['show_icons'])){
					$iconOptions['icons_yes'] = "true";
				}else{
					$iconOptions['icons_yes'] = "false";
				}
				update_option($this->documentIconOptionsName, $iconOptions);
			}
			
			/*check for checkbox selection*/

			if(isset($_POST['update_RD_Document_Links'])){
				if (!isset($_POST['update_nnc_RD_Document_Links'])) die("I'm sorry, you didn't send any credentials. Please refresh the page and try again."); //new line check for nonce
					if (!wp_verify_nonce($_POST['update_nnc_RD_Document_Links'],'update_nnc_RD_Document_Links')) die("I'm sorry, you didn't send the right credentials. Please refresh the page and try again."); //nonce verification
						
						for($i = 0; $i < count($attachmentsInfoRows); $i++){
							$fileInfo = $attachmentsInfoRows[$i];
							$adminOptions['showfile_'.$fileInfo['id']] = isset($_POST['showfile_'.$fileInfo['id']]) ? 'true' : 'false';
						}
			?><div class="updated"><p><strong><?php _e("Settings Updated.", "RD_Document_Links");?></strong></p>
			  </div><?php
			  update_option($this->adminOptionsName, $adminOptions);
			}
		}
				
		/**
		 *  create a new row 'rdDocumentLinksAdminOptions' on the option table that stores the selected document's id, title, guid mime type and post date
		 */
		function rd_get_admin_options(){

			$attachmentsInfo = $this->rd_query_db(); 			
			$rdFilesChecked = array();
			
			for($i = 0; $i < count( $attachmentsInfo ); $i++){
				$row = $attachmentsInfo[$i];
				$key = 'showfile_'.$row['id'];
				$value = 'true';
				$rdFilesChecked[$key] = $value;
			}
			//  Test if options have changed. Load new options or populate with the initial values			 
			$adminOptions = get_option($this->adminOptionsName);
			if(!empty( $adminOptions ) ) {
				foreach($adminOptions as $key => $option){
					$rdFilesChecked[$key] = $option;
				}
			}
			//  Update the options
			update_option($this->adminOptionsName, $rdFilesChecked);
			return $rdFilesChecked; //return the stored options
			}
			
		
		/**
		 * getter for the checkbox icon option
		 */
   		function rd_get_icons_option(){
      		return get_option($this->documentIconOptionsName);
    	}
    	
    	
    	/**
		 * getter for the list order radio buttons
        **/

    	function rd_get_list_order(){
    		return get_option($this->listOrderOptionsName);
    	}
    	
    	
    	
    	
    	/**
		 *  find the id, title, url mime type and date of each attachment. Return a 2D array of attachments
		 */
		function rd_query_db(){
			global $wpdb;
			$sortOrder;	
			$order = $this->rd_get_list_order();	
			if($order){
				if ($order['display_order'] == 'ascending'){
					$sortOrder = 'ASC';
				}else{
					$sortOrder = 'DESC';
				}
			}
			$result= $wpdb->get_results("SELECT ID, post_title, guid, post_mime_type, post_date FROM ".$wpdb->posts." WHERE post_type = 'attachment' ORDER BY post_date ".$sortOrder, ARRAY_N);
			$attachmentsInfo = array();
			$imageFiles = $this->imageFiles;
			if ($result){
				foreach($result as $file){
					// adds keys to each value before pushing it into the new array
					$fileInfo = array('id'=>$file[0], 'title'=>$file[1], 'guid'=>$file[2], 'mimetype'=>$file[3], 'date'=>$file[4]);
					$rowMimeType = $fileInfo['mimetype'];
					//don't add image files to the array
					if(in_array($rowMimeType, $imageFiles)){
						continue;
					}else{
						array_push($attachmentsInfo, $fileInfo);
					}
				}
			//returns a 2D array
			return $attachmentsInfo;
			}
		}


		/**
		 *  html for admin panel grid displaying checkboxes
		 */
		function rd_print_attachment_lists($attachmentsInfo){
			?><div class="rd-doc-container">
				
				<div class="rd-doc-list">
					<div>
						<h4><strong>PDF Documents:</strong></h4>
						<ul><?php $this->rd_sort_attachments_by_type($attachmentsInfo, 'application/pdf');?></ul>
					</div>
					<div>
						<h4><strong>Word Documents:</strong></h4>
						<ul><?php $this->rd_sort_attachments_by_type($attachmentsInfo, 'application/msword');?></ul>
					</div>			
					<div>
						<h4><strong>ZIP Archives:</strong></h4>
						<ul><?php $this->rd_sort_attachments_by_type($attachmentsInfo, 'application/zip');?></ul>
					</div>
					<div class="rd-dim">
						<h4><strong>Other Files:</strong></h4>
						<p class="rd-small">(Images not included)</p>
						<ul><?php $this->rd_sort_attachments_by_type($attachmentsInfo);?></ul>
					</div>
				</div>
			</div>
			
			<?php
		}

		function rd_sort_attachments_by_type($attachmentsInfo, $mimeType=null){
			$adminOptions = $this->rd_get_admin_options();
			$isFileFound = false;
			$definedDocumentsArray = array('application/pdf', 'application/msword', 'application/zip');
			
			for($i = 0; $i < count($attachmentsInfo); $i++){			
				$fileInfo = $attachmentsInfo[$i];
				$rowMimeType = $fileInfo['mimetype'];
				if($mimeType != null){
					// if the file is not one of the defined types, and not an image, then list it
					if($rowMimeType == $mimeType){
						$isFileFound = true;
						$this->rd_display_attachment_name($fileInfo, $adminOptions);
					}
				}else{
				if(!in_array($rowMimeType, $definedDocumentsArray)){
					$isFileFound = true;
					$this->rd_display_attachment_name($fileInfo, $adminOptions);
					}
				}
			}
			//output message if there are no files in the category
			if(!$isFileFound){
				?><li class="rd-none"><?php _e('None available.')?><br><?php _e('Upload files to your Media')?><br><?php _e('Library to see them here.')?></li><?php ;
			}
		}
		/**
		*  reformat the date in a more reader-friendly format
		*/
		function rd_format_date($date){
    		$formatDate = date('F d\, Y',strtotime($date));
    		return $formatDate;
    	}
		
		/**
		*  output the file names and checkboxes in the admin menu
		*/
 		function rd_display_attachment_name($fileInfo, $adminOptions){
 		
			$documentId = 'showfile_'.$fileInfo['id'];//create variable for reuse of the document id
			$documentTitle = 'showfile_'.$fileInfo['title']; //create variable for reuse of the document title
			$extension = 'showfile_'.$fileInfo['guid'];
			$date = $this->rd_format_date($fileInfo['date']);
/* 			$date = substr($fileInfo['date'], 0, -9); */
			$ext = pathinfo($extension, PATHINFO_EXTENSION);
		
			echo '<li><label for="'; //begin checkbox label 
			echo $documentId; //label 'for' value
			echo '"><input type="checkbox" id="';
			echo $documentId; //end label, start input type
			echo '" name="';
			//test option value from the DB, check if it's true
			
			echo $documentId;//name 
			echo '" value="true"'; 
			if ($adminOptions['showfile_'.$fileInfo['id']]=="true"){
				_e('checked="checked"', "RD_Document_Links");
			}
			echo '}/></label> ';
			echo $fileInfo['title'];						//the document name that appears next to the checkbox
			echo '<span>  (.'.$ext.')  </span><span class="rd-date">'.$date.'</span> </li>';
		}
	
	
		/**
		 *  option for asc or desc order
 		**/
		function rd_print_order_radio_buttons($listOrderOptions){
			?>
			<div class="rd-doc-order clear">
			<h4><strong>Document Order (by post date)</strong></h4>
				<input 
					type="radio" 
					name="order"
					value="ascending" 
					<?php 
					if ($listOrderOptions['display_order']=="ascending"){
						_e('checked="checked"', "RD_Document_Links");
					}?>/> Ascending
				<br/><br/>
				<input 
					type="radio" 
					name="order"
					value="descending" 
					<?php 
					if ($listOrderOptions['display_order']=="descending"){
						_e('checked="checked"', "RD_Document_Links");
					}?>/> Descending
			</div><?php
		}
		
		
		/**
		 *  option to show or hide file icons next to the links
		 */
		function rd_print_icon_checkbox(){
		
			$iconOptions = $this->rd_get_icons_option();
			
			?>
			<div class="rd-showicon-field">
			<h4><strong>Document Icon</strong></h4>
				<p>You can choose to show a small file icon next to the file links.</p>
				<p>
					
					<input 
						type="checkbox" 
						name="show_icons" 
						id="radio_one" 
						<?php
						if ($iconOptions['icons_yes']=="true"){
							_e('checked="checked"', "RD_Document_Links");
						}
						?>
						/>
						<label for="radio"><strong> Show icons </strong></label>
					</p>
			</div>
			<?php
		}
		
		/**
		*  display the admin panel
		*/
		function rd_print_admin_page(){
		
			if(isset($_POST['update_RD_Document_Links'])){
				$this->rd_process_post_data();
			}
			
			$iconOptions = $this->rd_get_icons_option();
			$adminOptions = $this->rd_get_admin_options();
			$attachmentsInfoRows = $this->rd_query_db(); 
			$listOrderOptions = $this->rd_get_list_order();
			
			?>
				<div class="wrap">
					<h2>Document Links Widget</h2>
					<div class="rd-admin-intro">
						<p>This is a <strong>two-part</strong> plugin that requires you to define your settings in both</p> <ol><li>This admin panel</li><li>The Document Links widget control panel</li></ol>
						<p>Please refer to the <a href="http://ransomdesign.com/doclinks/">Document Links Widget home page</a> for additional information.</p>
					</div>
					<h3>Instructions</h3>
					<p><strong>General description: </strong>The Document Links Widget allows you to provide download links to your Media Library files within your sidebar. This can be used for sharing white papers, instructions manuals, presentations or just general file sharing. You must have a Widget-enabled theme installed to use this plugin.</p>  
					<p><strong>File selection: </strong>Below is a list of all the files in your Media Library. Selecting or deselecting the files here gives you granular control over which files appear within each category. Use the Widget control panel to hide or show the categories.</p>
					<p><strong>File names: </strong>To change the title of a file, edit the file name in your Media Library.</p>
					<p><strong>Order: </strong>Display the results by upload date in ascending or descending order.</p>
					<p><strong>File link icons: </strong> Selecting the show icons checkbox automatically places file icons next to the document links.</p>
					<h3>Files Available</h3>
					<form method="post" action="<?php echo $_SERVER["REQUEST_URI"];?>"
						<?php
							if ( function_exists('wp_nonce_field') )
							wp_nonce_field('RD_Document_Links_update_options');
						?>
						<?php echo $this->rd_print_attachment_lists($attachmentsInfoRows);?>
						<?php echo $this->rd_print_order_radio_buttons($listOrderOptions);?>
						<?php echo $this->rd_print_icon_checkbox($iconOptions);?>					
						<div class="rd-clear"></div>
						<div class="submit">
							<input name="update_nnc_RD_Document_Links" type="hidden" value="<?php echo wp_create_nonce('update_nnc_RD_Document_Links'); ?>" /><?php //new line: Generate Nonce ?>
							<input class="button-primary" type="submit" name="update_RD_Document_Links" value="<?php _e('Update Settings', 'RD_Document_Links') ?>"/>
						</div>
					</form>
				</div>
			<?php
		}
		
		/**
		*  display the admin panel
		*/
		function init(){
			$this->rd_get_admin_options();
		}	
	}
}

/**********************
*  END CLASS
***********************/


/**
*  check if class exists, set it to a variable
*/

if (class_exists("RD_Document_Links")) {
	$rd_documentLinks = new RD_Document_Links();
}


/**
*  load css for the optional document icons
*/
function rd_load_widget_css(){
	global $rd_documentLinks;
    $iconOptions = $rd_documentLinks->rd_get_icons_option();
	//css for adding icons to the document links
	if($iconOptions['icons_yes'] == 'true'){
		echo '<link type="text/css" rel="stylesheet" href="' .WP_PLUGIN_URL.'/document-links-widget/css/rd-documentlinks-styles.css"/>' . "\n";
	}else{
		echo '<!--no stylsheet loading-->';
	}
}


/**
*  load css for the admin panel
*/
function rd_load_admin_css(){
	echo '<link type="text/css" rel="stylesheet" href="' .WP_PLUGIN_URL.'/document-links-widget/css/rd-documentlinks-admin-styles.css"/>' . "\n";
}



/**
*  load the admin panel
*/
if(!function_exists("RD_Document_Links_ap")){
	function RD_Document_Links_ap(){
		global $rd_documentLinks;
		if (!isset($rd_documentLinks)){
			return;
		}
		if (function_exists('add_menu_page')){
			add_menu_page('Document Links', 'Document Links', 'administrator', basename(__FILE__), array(&$rd_documentLinks, 'rd_print_admin_page'));
		}
	}
}


/**
*  Actions and Filters
*/
if (isset($rd_documentLinks)) {
	//Actions
	add_action('activate_rd-documentlinks-plugin/rd-documentlinks-plugin.php', array(&$rd_documentLinks, 'init'));
	add_action('admin_menu', 'RD_Document_Links_ap');
	add_action('wp_head', 'rd_load_widget_css');
	add_action('admin_head', 'rd_load_admin_css');
	//Filters
}

/*------------------------------------------*/
/*------------------Widget------------------*/
/*------------------------------------------*/

/**
*  check WordPress version. Only 2.8 and above support the WP_Widget class
*/
global $wp_version;
if((float)$wp_version >= 2.8){

	class RD_Document_Links_Widget extends WP_Widget {
		
		/**
		*  Constructor
		*/
		function RD_Document_Links_Widget() {
			$widget_options = array('classname' => 'rd_doclinks_widget', 'description' => __('Document Links Widget by ransomdesign.com.'));
			$this->WP_Widget('rddocumentlinkswidget', __('Document Links'), $widget_options);	
		}
		
		/**
		*  display widget
		*/
		function widget($args,$instance) {
			global $rd_documentLinks;
			extract($args);
			
			$title = apply_filters('widget_title', empty( $instance['title'] ) ? __( 'Document Links' ) : $instance['title'], $instance, $this->id_base);	
	
			$other = $instance['othercheck'] ? '1' : '0';
			
			// lookup table of mimetype to ischecked in widget panel
			$widgetCheckLookup = array('application/pdf' => $instance['pdfcheck'], 'application/msword' => $instance['doccheck'], 'application/zip' => $instance['zipcheck']);			
		
			echo $before_widget;
			
			if ( $title ){
				echo $before_title . $title . $after_title;
			}
	
			// set up variables that hold checkbox option values from db
			$devOptions = $rd_documentLinks->rd_get_admin_options();
			$rows = $rd_documentLinks->rd_query_db();
			
			
			echo '<ul class="rd_doclinks">';
			for($i = 0; $i < count($rows); $i++){
				$row = $rows[$i];
				$isAdminSelected = $devOptions['showfile_'.$row['id']]=="true";
				if (!$isAdminSelected){
					continue;
				}
				$rowMimetype = $row['mimetype'];
				$isOther = !array_key_exists($rowMimetype, $widgetCheckLookup);
							
				if ((!$isOther && $widgetCheckLookup[$rowMimetype]) || ($isOther && $other)){
						echo '<li><a href="';
						echo $row['guid'];
						echo '" title="';
						echo $row['title'];
						echo '">';
						echo $row['title'];
						echo '</a></li>';
				}		
			}
			echo '</ul>';
			echo $after_widget;
		}
		
		/**
		*  update saved values
		*/
		function update($new_instance, $old_instance) {
			$instance = $old_instance;
			$instance['pdfcheck'] = !empty($new_instance['pdfcheck']) ? 1 : 0;
			$instance['doccheck'] = !empty($new_instance['doccheck']) ? 1 : 0;
			$instance['zipcheck'] = !empty($new_instance['zipcheck']) ? 1 : 0;
			$instance['othercheck'] = !empty($new_instance['othercheck']) ? 1 : 0;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		/**
		*  widget control form
		*/
		function form($instance) {
			// title field variables
			$instance = wp_parse_args( (array) $instance, array( 'title' => '') );
			$title = esc_attr( $instance['title'] );
			// start radio button variables
			$pdfCheck = isset($instance['pdfcheck']) ? (bool) $instance['pdfcheck'] : true;
			$docCheck = isset($instance['doccheck']) ? (bool) $instance['doccheck'] : true;
			$zipCheck = isset($instance['zipcheck']) ? (bool) $instance['zipcheck'] : true;
			$otherCheck = isset($instance['othercheck']) ? (bool) $instance['othercheck'] : true;
			
			?>
			<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
			<?php
			// checkbox form starts here
			echo "\r\n"?>
			<p><?php _e('To hide or show individual files within these categories, use the plug-in admnistration panel.')?></p>
			</p>
				<input 
					type="checkbox" 
					class="checkbox" 
					id="<?php echo $this->get_field_id('pdfcheck'); ?>" 
					name="<?php echo $this->get_field_name('pdfcheck'); ?>"
					value="true"
					<?php checked( $pdfCheck ); ?> />
					<label for="<?php echo $this->get_field_id('pdfcheck'); ?>">
					<?php _e( 'Show PDFs' ); ?></label>
					<br />
			<p>
			</p>
				<input 
					type="checkbox" 
					class="checkbox" 
					id="<?php echo $this->get_field_id('doccheck'); ?>" 
					name="<?php echo $this->get_field_name('doccheck'); ?>"
					value="true"
					<?php checked( $docCheck ); ?> />		
					<label for="<?php echo $this->get_field_id('doccheck'); ?>">
					<?php _e( 'Show Word Docs' ); ?></label>
					<br />
			<p>
			</p>
				<input 
					type="checkbox" 
					class="checkbox" 
					id="<?php echo $this->get_field_id('zipcheck'); ?>" 
					name="<?php echo $this->get_field_name('zipcheck'); ?>"
					value="true"
					<?php checked( $zipCheck ); ?> />
					<label for="<?php echo $this->get_field_id('zipcheck'); ?>">
					<?php _e( 'Show ZIP Archives' ); ?></label>
					<br />
			<p>
			</p>
				<input 
					type="checkbox" 
					class="checkbox" 
					id="<?php echo $this->get_field_id('othercheck'); ?>" 
					name="<?php echo $this->get_field_name('othercheck'); ?>"
					value="true"
					<?php checked( $otherCheck ); ?> />
					<label for="<?php echo $this->get_field_id('othercheck'); ?>">
					<?php _e( 'Show Other' ); ?></label>
					<br />
			</p>
			<?php
		}
	}// end class
	
		/* register widget when loading the WP core */
		add_action('widgets_init', 'rd_register_widgets');
	
		function rd_register_widgets(){
			register_widget('RD_Document_Links_Widget');
		}
}
?>