<style>

.schedule-table .titleRowSt {
	color:#fff;
	font-weight:bold;
	background-color:#CD8C31;
	padding:1px 0 1px 4px;
	border-right:1px solid #06562D;
	border-bottom:1px solid #06562D;
	}

.schedule-table .title-row {
	color:#fff;
	font-weight:bold;
	background-color:#999;
	padding:1px 0 1px 4px;
	border-right:1px solid #666;
	border-bottom:1px solid #666;
	}

.schedule-table td.time-change {
	background-color: pink;
	}

.schedule-table tr.past {
	color: gray;
	}

.schedule-table td.error {
	padding:10px;
	border:1px solid #ddd;
	}

.schedule-table td {
	font-size:11px;
	background-color:#eee;
	border-right:1px solid #ddd;
	border-bottom:1px solid #ddd;
	padding:1px 2px 1px 4px;
	}

.schedule-table td img {
	border:0;
	vertical-align:middle;
	}

.schedule-table .cancelled {
   color: red;
   text-decoration: line-through;
}

.schedule-table .makeup {
   color: purple;
}

.schedule-date {
	font-weight:bold;
	font-size:13px;
	color:#333;
	margin-top: 10px;
	/*margin-bottom:-10px;*/
	}

</style>

<h2><?php echo $division_name; ?> - <?php echo $team_name ?> Schedule</h2>

<?php if ($division_name == 'Rookies (6 year olds)'): ?>
<p><a href="http://dcx8bc82x9c73.cloudfront.net/wp-content/uploads/2013/05/Rookie-6-Tournament-Schedule.pdf">Rookie 6 Tournament Schedule.</a>  Closing Ceremonies will be on 6/15</p>
<?php elseif ($division_name == 'Pee-Wees'): ?>
<p>Crossover games begin on 6/10 and continue through 6/14! Closing Ceremonies will be on 6/15</p>
<?php elseif ($division_name == 'Minors'): ?>
<p>Crossover games begin on 6/11 and continue through 6/14! Closing Ceremonies will be on 6/15</p>
<?php elseif ($division_name == 'Majors'): ?>
<p>The Major Division Single Elimination Tournament play begins on 6/10 and continues through 6/14! Closing Ceremonies will be on 6/15</p>
<? endif; ?>

<table class="schedule-table" width="100%" cellpadding="2" cellspacing="1" border="0">
<thead>
<tr>
	<td class="title-row">Game Time</td>
	<td class="title-row">Home Team</td>
	<td class="title-row">Away Team</td>
	<td class="title-row">Field</td>
	<td class="title-row">Calendar</td>
</tr>
</thead>
<tbody>
<?php
foreach ($games as $game):
   $textDate = date('l, F jS', strtotime($game['game_time']));
   if ($saveDate != $textDate)
   {
      $dayBreak = true;
      $saveDate = $textDate;
   }
?>

<?php if ($game['makeup']): ?>
<tr class="makeup">
<?php elseif ($game['cancelled']): ?>
<tr class="cancelled">
<?php elseif (strtotime($game['game_time']) < time()): ?>
<tr class="past">
<?php else: ?>
<tr>
<?php endif; ?>
	<?php if ($game['time_change']): ?>
	<td class="time-change">
	<?php else: ?>
	<td>
	<?php endif; ?>
	<?php if ($game['makeup']) echo '<strong>' ?>
	<?php if ($game['away_team'] != 'Bye') echo date('D, m/d/y g:i a', strtotime($game['game_time'])); ?>
	<?php if ($game['makeup']) echo '</strong>' ?>
	</td>
	<td><?php echo $game['home_team'] ?></td>
	<td><?php echo $game['away_team'] ?></td>
	<td>
	<?php if ($game['cancelled']): ?>
           CANCELED
        <?php else: ?>
           <?php echo $game['field'] ?>
           <?php if ($game['game_type']) echo sprintf(' (%s)', $game['game_type']); ?>
           <?php if ($game['notes']) echo sprintf('<br>[<strong>%s</strong>]', $game['notes']); ?>
	   <?php if ($game['makeup']) echo ' <strong>(MAKE-UP)</strong>' ?>
           <?php //if ($game['address_link']) echo $html->link($html->image('map_go.png', array('border'=>0)), $game['Field']['address_link'], array(), false, false); ?>
           <br/>
           <?php if ($game['address']) echo $game['address']; ?>
           <?php if ($game['playoff']): ?>
           <strong>Home with be determined by a coin flip.</strong>
           <?php endif; ?>
        <?php endif; ?>
	</td>
	<td align="center">
		<?php
		$date = new DateTime($game['game_time']);
		$d = $date->format('Ymd');
		$st = $date->format('His');
		if (empty($game['game_type']))
		{
			$date->add(new DateInterval('PT2H'));
			$details = null;
		}
		else
		{
			$date->add(new DateInterval('PT1H30M'));
			$details = $game['game_type'];
		}
		$et = $date->format('His');

		$text = $game['home_team'] . ' vs ' . $game['away_team'];
		$dates = sprintf('%sT%s/%sT%s', $d, $st, $d, $et);
		echo '<a href="http://www.google.com/calendar/event?action=TEMPLATE&text=' . $text . '&dates=' . $dates . '&details=' . $details . '&location=' . urlencode($game['field']) . '&trp=false&sprop=http%3A%2F%2Frivertonbaseball.org%2F&sprop=name:Riverton%20Baseball" target="_blank"><img src="//www.google.com/calendar/images/ext/gc_button1.gif" border=0></a>';
		?>
	</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>