<?php
/*
Plugin Name: Youth League Registration
Plugin URI: http://vanskyhawk.com
Description: League registration and payment
Version: 0.10
Author: Brad Van Skyhawk
Author URI: http://vanskyhawk.com
Copyright: 2012, The Van Skyhawk Group, LLC
*/


define('YLR_PLUGIN_NAME',"youth-league-registration");
define('YLR_SCHEDULES', 'yrl-schedules');
define('YLR_STANDINGS', 'yrl-standings');
$ylr_script_url = get_option('home') . '/index.php?plugin=' . YLR_PLUGIN_NAME;
define('YLR_PATH',WP_PLUGIN_DIR.'/'.YLR_PLUGIN_NAME);
define('YLR_IMAGES_PATH',YLR_PATH.'/images');
define('YLR_CSS_PATH',YLR_PATH.'/css');
define('YLR_JS_PATH',YLR_PATH.'/js');
define('YLR_INCLUDES_PATH',YLR_PATH.'/includes');
define('YLR_I18N_PATH',YLR_PATH.'/i18n');
define('YLR_MODELS_PATH',YLR_PATH.'/classes/models');
define('YLR_CONTROLLERS_PATH',YLR_PATH.'/classes/controllers');
define('YLR_VIEWS_PATH',YLR_PATH.'/classes/views');
define('YLR_WIDGETS_PATH',YLR_PATH.'/classes/widgets');
define('YLR_HELPERS_PATH',YLR_PATH.'/classes/helpers');
define('YLR_URL',plugins_url($path = '/'.YLR_PLUGIN_NAME));
define('YLR_IMAGES_URL',YLR_URL.'/images');
define('YLR_CSS_URL',YLR_URL.'/css');
define('YLR_JS_URL',YLR_URL.'/js');
define('YLR_INCLUDES_URL',YLR_URL.'/includes');
define('YLR_SCRIPT_URL',$ylr_script_url);
define('YLR_CART', '_ylr_cart');

// Load the Config
//require_once(YLR_PATH . '/ylr-config.php');

$ylr_blogurl         = ((get_option('home'))?get_option('home'):get_option('siteurl'));
$ylr_siteurl         = get_option('siteurl');
$ylr_blogname        = get_option('blogname');
$ylr_blogdescription = get_option('blogdescription');

$ylr_leagues = array(
	'No League',
	'T-Ball (3-4 year olds)',
	'Rookies 5 (5 year olds)',
	'Rookies 6 (6 year olds)',
	'Pee-Wees (7-8 years old)',
	'Minors (9-10 years old)',
	'Majors (11-12 years old)',
	'Babe Ruth Prep (13 year olds)',
	'Babe Ruth (14-15 year olds)',
	'Babe Ruth (16-18 year olds)',
);
$ylr_costs = array(0, 90, 100, 100, 120, 120, 120, 145, 145, 170);

class YouthLeagueRegistration
{

	/**
	 * Setup the shortcodes and actions
	 */
	function __construct()
	{
		add_action('init', array($this, 'parse_standalone_request'));
		add_action('wp_enqueue_scripts', array($this, 'load_scripts'), 1);
		add_shortcode('league-registration-form', array($this, 'registration_form'));
		add_shortcode('tournament-registration-form', array($this, 'tournament_form'));
		add_shortcode('league-eligibility-form', array($this, 'eligibility_form'));
		add_shortcode('league-checkout', array($this, 'checkout'));
		add_shortcode('league-thisweek', array($this, 'thisweek'));
		add_shortcode('league-schedule', array($this, 'schedule'));
		add_shortcode('league-standings', array($this, 'standings'));

//		add_rewrite_rule('/all-schedules/(\d+)/?\??(.*)$', '/all-schedules/?yrl-schedules=$1~$2');
		session_start();
	}

	/**
	 * Load scripts and styles needed
	 */
	function load_scripts()
	{
  		//wp_enqueue_script( 'jquery-ui-1.7.2', YLR_JS_URL . '/jquery/jquery-ui-1.7.2.custom.min.js', array('jquery') );
		wp_enqueue_script( 'ylr-registration', YLR_JS_URL . '/ylr.js' );
		wp_enqueue_style( 'jquery-ui-1.7.2', YLR_CSS_URL . '/jquery/smoothness/jquery-ui-1.7.2.custom.css' );
	}

	function log($text)
	{
		error_log(date('r') . ': ' . $text . "\n", 3, 'brad.log');
	}

	function standings()
	{
		global $wpdb;

		$league_table = "{$wpdb->prefix}ylr_leagues League";
		$league = isset($_REQUEST[YLR_STANDINGS]) ? $_REQUEST[YLR_STANDINGS] : null;
		$league_id = $wpdb->get_var("SELECT id FROM $league_table WHERE slug = '$league'");
		if ($league)
		{
			$division_list = array(
				4 => array(
					'PeeWee Purple' => array('reds', 'a-s', 'marlins', 'pirates', 'angels', 'yankees', 'rockies', 'red-sox', 'd-backs'),
					'PeeWee Silver' => array('dodgers', 'phillies', 'twins', 'giants', 'tigers', 'mariners', 'astros', 'cardinals', 'indians'),
				),
				5 => array(
					'Minor Purple' => array('indians', 'angels', 'astros', 'd-backs', 'twins', 'rays', 'cubs'),
					'Minor Silver' => array('dodgers', 'reds', 'pirates', 'yankees', 'cardinals', 'tigers', 'orioles'),
				),
			);
			$team_table = "{$wpdb->prefix}ylr_teams Team";
			if (isset($division_list[$league_id]))
			{
				foreach ($division_list[$league_id] as $label => $teams)
				{
					$slugs = implode("','", $teams);
					$sql = $wpdb->prepare("SELECT * FROM $team_table WHERE league_id = $league_id AND slug IN ('$slugs') ORDER BY wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, tiebreaker, name");
					$divisions[$label] = $wpdb->get_results($sql, ARRAY_A);
				}
			}
			else
			{
				$sql = $wpdb->prepare("SELECT * FROM $team_table WHERE league_id = $league_id ORDER BY wins/(wins+loses+ties) DESC, wins DESC, loses, ties DESC, tiebreaker, name");
				$divisions[$league] = $wpdb->get_results($sql, ARRAY_A);
			}
			include "views/team-standings.php";
		}
		else
		{
			// List of leagues
			$this->division_list(YLR_STANDINGS, 2);
		}
	}

	function schedule()
	{
		global $wpdb;

		$league_table = "{$wpdb->prefix}ylr_leagues League";
		$team_table = "{$wpdb->prefix}ylr_teams Team";
		$game_table = "{$wpdb->prefix}ylr_games Game";
		$field_table = "{$wpdb->prefix}ylr_fields Field";
		$home_table = "{$wpdb->prefix}ylr_teams Home";
		$away_table = "{$wpdb->prefix}ylr_teams Away";

		// show schedules
		$schedule_url = isset($_REQUEST[YLR_SCHEDULES]) ? $_REQUEST[YLR_SCHEDULES] : null;
		if ($schedule_url)
		{
			@list($division, $team) = explode('~', $schedule_url);
			$division_id = $wpdb->get_var("SELECT id FROM $league_table WHERE slug = '$division'");
			if ($team)
			{
				$sql = $wpdb->prepare("
					SELECT Game.id, IFNULL(Home.name, Game.home_team) home_team, IFNULL(Away.name, Game.away_team) away_team, Game.game_time, Field.name field, Game.game_type, Game.notes
					FROM $game_table
						LEFT JOIN $field_table ON (Field.id = Game.field_id)
						LEFT JOIN $home_table ON (Home.team_id = Game.home_team AND Home.league_id = Game.league_id)
						LEFT JOIN $away_table ON (Away.team_id = Game.away_team AND Away.league_id = Game.league_id)
					WHERE Game.league_id = '$division_id' AND (Home.slug = '$team' OR Away.slug = '$team')
					ORDER BY Game.game_time
				");
				$games = $wpdb->get_results($sql, ARRAY_A);
				$division_name = $wpdb->get_var("SELECT name, id FROM $league_table WHERE slug = '$division'");
				$division_id = $wpdb->get_var(null, 1);
				$team_name = $wpdb->get_var("SELECT CONCAT(name, ' (', coach, ')') FROM $team_table WHERE slug = '$team' AND league_id = '$division_id'");
				include "views/team-schedule.php";
			}
			else
			{
				$teams = $wpdb->get_results("SELECT slug, CONCAT(name, ' (', coach, ')') name FROM $team_table WHERE league_id = '$division_id' ORDER BY name", ARRAY_A);
				$division_name = $wpdb->get_var("SELECT name FROM $league_table WHERE slug = '$division'");
				$url_key = YLR_SCHEDULES;
				include "views/team-list.php";
			}
		}
		else
		{
			// List of leagues
			$this->division_list(YLR_SCHEDULES);
		}

	}

	function division_list($url_key, $min_division = 0)
	{
		global $wpdb;
		$league_table = "{$wpdb->prefix}ylr_leagues League";
		if ($min_division)
		{
			$divisions = $wpdb->get_results("SELECT * FROM $league_table WHERE id > $min_division", ARRAY_A);
		}
		else
		{
			$divisions = $wpdb->get_results("SELECT * FROM $league_table", ARRAY_A);
		}
		include "views/division-list.php";
	}

	function thisweek()
	{
		global $wpdb;

		$game = "{$wpdb->prefix}ylr_games Game";
		$field = "{$wpdb->prefix}ylr_fields Field";
		$league = "{$wpdb->prefix}ylr_leagues League";
		$home = "{$wpdb->prefix}ylr_teams Home";
		$away = "{$wpdb->prefix}ylr_teams Away";
		$sql = $wpdb->prepare("
			SELECT Game.id, League.name league, League.slug, Home.name home_team, Home.slug home_slug, Game.home_team home_id, Away.name away_team, Away.slug away_slug, Game.away_team away_id, Game.game_time, Field.name field, Game.game_type, Game.notes
			FROM $game
				LEFT JOIN $league ON (League.id = Game.league_id)
				LEFT JOIN $field ON (Field.id = Game.field_id)
				LEFT JOIN $home ON (Home.team_id = Game.home_team AND Home.league_id = Game.league_id)
				LEFT JOIN $away ON (Away.team_id = Game.away_team AND Away.league_id = Game.league_id)
			WHERE WEEK(Game.game_time) = WEEK(CURRENT_DATE())
			AND Game.game_time >= CURRENT_DATE()
			ORDER BY Game.league_id, Game.game_time
		");
		$games = $wpdb->get_results($sql, ARRAY_A);
		if (empty($games))
		{
			$sql = $wpdb->prepare("
				SELECT Game.id, League.name league, League.slug, Home.name home_team, Home.slug home_slug, Game.home_team home_id, Away.name away_team, Away.slug away_slug, Game.away_team away_id, Game.game_time, Field.name field, Game.game_type, Game.notes
				FROM $game
					LEFT JOIN $league ON (League.id = Game.league_id)
					LEFT JOIN $field ON (Field.id = Game.field_id)
					LEFT JOIN $home ON (Home.team_id = Game.home_team AND Home.league_id = Game.league_id)
					LEFT JOIN $away ON (Away.team_id = Game.away_team AND Away.league_id = Game.league_id)
				WHERE WEEK(Game.game_time) = WEEK(CURRENT_DATE()) + 1
				AND Game.game_time >= CURRENT_DATE()
				ORDER BY Game.league_id, Game.game_time
			");
			$games = $wpdb->get_results($sql, ARRAY_A);
		}
		if (!empty($games))
			include "views/this-week.php";
	}

	/**
	 * Process and/or display registration form
	 */
	function registration_form()
	{
		if (isset($_SESSION[YLR_CART])) $_POST = $_SESSION[YLR_CART];
		if (empty($_POST)) $_POST = $this->get_cart(session_id());
		$this->display_errors();
		$this->display_registration_form();

		if (isset($_GET['emailtest']))
		{
			$this->confirmation_email('brad@vanskyhawk.com');
		}
	}

	/**
	 * Process and/or display tournament form
	 */
	function tournament_form()
	{
		if (isset($_SESSION[YLR_CART])) $_POST = $_SESSION[YLR_CART];
		if (empty($_POST)) $_POST = $this->get_cart(session_id());
		$this->display_tournament_errors();
		$this->display_tournament_form();

		if (isset($_GET['emailtest']))
		{
			$team = array('team_name' => 'Riverton', 'coach_name' => 'Brad Van Skyhawk', 'email' => 'brad@vanskyhawk.com', 'phone' => '8019491202', 'division' => '9/10U');
			$this->tournament_confirmation_email($team);
		}
	}

	/**
	 * Display checkout form
	 */
	function checkout()
	{
		$cart = $this->get_cart(session_id());
		if (empty($cart))
		{
			echo 'Your cart is empty.';
			return;
		}
		global $ylr_leagues, $ylr_costs;
		include "views/checkout.php";
	}

	/**
	 * Process the registration form and save the cart.
	 */
	function process_registration_form()
	{
		$this->errors = $this->validate_registration_form($_POST);

		if (empty($this->errors))
  		{
  			global $wpdb;

  			// Add to cart
  			$_SESSION[YLR_CART] = $_POST;
  			$session_id = session_id();
 			$cart = serialize($_POST);
 			$table = "{$wpdb->prefix}ylr_carts";
  			$sql = $wpdb->prepare("SELECT id FROM $table WHERE session_id = %s", $session_id);
  			$id = $wpdb->get_var($sql);
  			if ($id)
  			{
  				$sql = $wpdb->prepare("UPDATE $table SET cart = %s, modified = NOW() WHERE id = %s", $cart, $id);
  			}
  			else
  			{
  				$sql = $wpdb->prepare("INSERT INTO $table (session_id, cart, created, modified) VALUES (%s, %s, NOW(), NOW())", $session_id, $cart);
  			}
  			$wpdb->query($sql);
  			header("Location: " . home_url('checkout'));
  			exit;
  		}
	}

	/**
	 * Process the tournament form and save the cart.
	 */
	function process_tournament_form()
	{
		$this->errors = $this->validate_tournament_form($_POST);

		if (empty($this->errors))
  		{
  			global $wpdb;

  			// Add to cart
  			$_SESSION[YLR_CART] = $_POST;
  			$session_id = session_id();
 			$cart = serialize($_POST);
 			$table = "{$wpdb->prefix}ylr_carts";
  			$sql = $wpdb->prepare("SELECT id FROM $table WHERE session_id = %s", $session_id);
  			$id = $wpdb->get_var($sql);
  			if ($id)
  			{
  				$sql = $wpdb->prepare("UPDATE $table SET cart = %s, modified = NOW() WHERE id = %s", $cart, $id);
  			}
  			else
  			{
  				$sql = $wpdb->prepare("INSERT INTO $table (session_id, cart, created, modified) VALUES (%s, %s, NOW(), NOW())", $session_id, $cart);
  			}
  			$wpdb->query($sql);
  			header("Location: " . home_url('checkout'));
  			exit;
  		}
	}

	function add_records($data, $transaction)
	{
		$txn_id = $transaction['txn_id'];
		$this->insert_transaction($txn_id, $transaction);

		if (isset($data['parent']))
		{
			$parent = $data['parent'];
			$players = $data['players'];
			$derby = $data['derby'];

			// Save each player
		  	foreach ($players as $player)
	  		{
	  			$this->insert_player($parent, $player, $txn_id);
	  		}

	  		// Save home run derby participants
			$names = explode(',', $derby['names']);
			if (count($names))
			{
				foreach ($names as $name)
				{
					if (!empty($name)) $this->insert_derby($name, $txn_id);
				}
			}

			// Send confirmation email
			$this->confirmation_email($parent['email']);
		}
		else
		{
			// Tournament transaction
			$this->insert_tournament($data['team']);
			$this->tournament_confirmation_email($data['team']);
		}
	}

	function insert_tournament($team)
	{
		global $wpdb;

		$table = $wpdb->prefix . 'ylr_tournaments';
		$sql = $wpdb->prepare("INSERT INTO $table (team_name, coach_name, coach_email, coach_phone, division, created, modified) VALUES (%s, %s, %s, %s, %s, NOW(), NOW())", $team['team_name'], $team['coach_name'], $team['email'], $team['phone'], $team['division']);
		return $wpdb->query($sql);
	}

	function confirmation_email($email)
	{
		$subject = 'Riverton Baseball Registration Confirmation';
		include('views/confirmation-email.php');
		$headers[] = 'From: Riverton Baseball <contact@rivertonbaseball.org>';
		$headers[] = 'Bcc: contact@rivertonbaseball.org';
		$headers[] = 'Bcc: brad@vanskyhawk.com';

		add_filter('wp_mail_content_type',create_function('', 'return "text/html";'));
		wp_mail( $email, $subject, $message, $headers, $attachments );
	}

	function tournament_confirmation_email($team)
	{
		$subject = 'Riverton Baseball Tournament Registration Confirmation';
		include('views/tournament-confirmation-email.php');
		$headers[] = 'From: Riverton Baseball <contact@rivertonbaseball.org>';
		$headers[] = 'Bcc: contact@rivertonbaseball.org';
		$headers[] = 'Bcc: brad@vanskyhawk.com';

		add_filter('wp_mail_content_type',create_function('', 'return "text/html";'));
		wp_mail( $team['email'], $subject, $message, $headers, $attachments );
	}

	function insert_transaction($txn_id, $transaction)
	{
		global $wpdb;

		$table = $wpdb->prefix . 'ylr_transactions';
		$session_id = $transaction['custom'];
		$sql = $wpdb->prepare("INSERT INTO $table (txn_id, session_id, transaction, created) VALUES (%s, %s, %s, NOW())", $txn_id, $session_id, serialize($transaction));
		return $wpdb->query($sql);
	}

	function insert_derby($name, $txn_id)
	{
		global $wpdb;

		$table = $wpdb->prefix . 'ylr_home_runs';
		$sql = $wpdb->prepare("INSERT INTO $table (name, txn_id, created) VALUES (%s, %s, NOW())", $name, $txn_id);
		return $wpdb->query($sql);
	}

	function insert_player($parent, $player, $txn_id)
	{
  		global $wpdb;

  		$table = $wpdb->prefix . 'ylr_players';
		extract($parent);
		extract($player);

		$tmp_date = strtotime($birth_date);
		if ($tmp_date)
		{
			$birth_date = date('Y-m-d', $tmp_date);
		}
		else
		{
			$birth_date = null;
		}

		$sql = "INSERT INTO $table (first_name, last_name, jersey_name, birthdate, address, city, state, zip, day_phone, cell_phone,
				email, school_boundary, shirt_size, pant_size, league_id, last_team, moms_name, dads_name, assistant_coach,
				snack_bar, team_mom, umpire, score_keeping, txn_id, created, modified)
					VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %d, %s, %s, %s, %d, %d, %d, %d, %d, %s, NOW(), NOW())";
		$player = $wpdb->prepare($sql, $first_name, $last_name, strtoupper($last_name), $birth_date, $address, $city, $state, $zip, $home_phone, $cell_phone,
				$email, $school_boundary, $shirt_size, $pant_size, $league_id, $last_team, $mother_name, $father_name,
				$assistant_coach, $snack_bar, $team_mom, $umpire, $score_keeping, $txn_id);
		@error_log(date('r') . ': ' . $player . "\n", 3, 'player.log');

		$return = $wpdb->query($player);
	}

	function validate_registration_form($values, $errors=array())
	{
		extract($values);

		if ((!isset($parent['father_name']) or empty($parent['father_name']))
			and (!isset($parent['mother_name']) or empty($parent['mother_name'])))
			$errors[] = __("Both Father's name and Mother's name can't be Blank");

		if(!isset($parent['address']) or empty($parent['address']))
			$errors[] = __("Address can't be Blank");

		if(!isset($parent['city']) or empty($parent['city']))
			$errors[] = __("City can't be Blank");

		if(!isset($parent['state']) or empty($parent['state']))
			$errors[] = __("State can't be Blank");

		if(!isset($parent['zip']) or empty($parent['zip']))
			$errors[] = __("Zip Code can't be Blank");

		if(!isset($parent['home_phone']) or empty($parent['home_phone']))
			$errors[] = __("Home Phone can't be Blank");
		else if(!preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $parent['home_phone']))
			$errors[] = __("Home Phone must be in the format ###-###-####");

		if( isset($parent['cell_phone']) and !empty($parent['cell_phone']) and
			!preg_match('/^\d\d\d-\d\d\d-\d\d\d\d$/', $parent['cell_phone']))
			$errors[] = __("Cell Phone must be in the format ###-###-####");

		if(!isset($parent['email']) or empty($parent['email']))
			$errors[] = __("Email can't be Blank");

		if(!isset($parent['school_boundary']) or empty($parent['school_boundary']))
			$errors[] = __("School Boundary can't be Blank");

		if(!isset($parent['terms']) or empty($parent['terms']))
			$errors[] = __("Please click Agree to Terms");

		$index = 1;
		foreach($players as $key => $player)
		{
			$errors = $this->validate_player($index, $player, $errors);
			$index++;
		}

		return $errors;
	}

	function validate_tournament_form($values, $errors=array())
	{
		extract($values);

		if (!isset($team['team_name']) or empty($team['team_name']))
			$errors[] = __("Team name can't be Blank");

		if (!isset($team['coach_name']) or empty($team['coach_name']))
			$errors[] = __("Coach name can't be Blank");

		if (!isset($team['email']) or empty($team['email']))
			$errors[] = __("Email can't be Blank");

		if (isset($team['email']) and !empty($team['email']) and
			!preg_match("/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/", $team['email']))
			$errors[] = __("Please enter a valid email address");

		if (!isset($team['phone']) or empty($team['phone']))
			$errors[] = __("Phone can't be Blank");

		if (!isset($team['division']) or empty($team['division']))
			$errors[] = __("Division can't be Blank");

		return $errors;
	}

	function validate_player($key,$values,$errors=array())
	{
  		extract($values);

		if(!isset($first_name) or empty($first_name))
			$errors[] = sprintf(__('Player #%d: First Name can\'t be Blank.'), (int)$key);

  		if(!isset($last_name) or empty($last_name))
    		$errors[] = sprintf(__('Player #%d: Last Name can\'t be Blank.'), (int)$key);

		if(!isset($birth_date) or empty($birth_date))
			$errors[] = sprintf(__('Player #%d: Birth Date can\'t be Blank.'), (int)$key);

		if(isset($birth_date) and strtotime($birth_date) == false)
			$errors[] = sprintf(__('Player #%d: Birth Date is not a valid date. Try mm/dd/yyyy.'), (int)$key);

		if(!isset($league_id) or empty($league_id))
			$errors[] = sprintf(__('Player #%d: Division can\'t be Blank.'), (int)$key);

		if(!isset($shirt_size) or empty($shirt_size))
			$errors[] = sprintf(__('Player #%d: Shirt Size can\'t be Blank.'), (int)$key);

		if(!isset($pant_size) or empty($pant_size))
			$errors[] = sprintf(__('Player #%d: Pant Size can\'t be Blank.'), (int)$key);

		return $errors;
	}

	function display_errors()
	{
		if (empty($this->errors)) return;
		$errors = $this->errors;
		include('views/registration-errors.php');
	}

	function display_registration_form()
	{
		include('views/registration-form.php');
	}

	/**
	 * Tournament registration errors
	 */
	function display_tournament_errors()
	{
		if (empty($this->errors)) return;
		$errors = $this->errors;
		include('views/tournament-errors.php');
	}

	/**
	 * Tournament registration form
	 */
	function display_tournament_form()
	{
		include('views/tournament-form.php');
	}

	function eligibility_form()
	{
		include('views/eligibility-form.php');
	}

	function get_cart($session_id = null)
	{
		global $wpdb;

		if (is_null($session_id)) $session_id = session_id();
		$table = $wpdb->prefix . 'ylr_carts';
		$sql = $wpdb->prepare("SELECT cart FROM $table WHERE session_id = %s", $session_id);
		$cart = $wpdb->get_var($sql);
		if ($cart)
		{
			return unserialize($cart);
		}
		return false;
	}

	function parse_standalone_request()
	{
		$plugin     = (isset($_REQUEST['plugin'])?$_REQUEST['plugin']:'');
		$action     = (isset($_REQUEST['action'])?$_REQUEST['action']:'');
		$controller = (isset($_REQUEST['controller'])?$_REQUEST['controller']:'');
		$page 		= (isset($_REQUEST['page'])?$_REQUEST['page']:'');

		if ( !empty($plugin) and $plugin == YLR_PLUGIN_NAME and !empty($controller) and !empty($action) )
		{
			if ($controller == 'players' and $action == 'add_player')
			{
				$this->add_player_form($_REQUEST['key']);
				exit;
			}

			if ($controller == 'registration' and $action == 'process')
			{
				$this->process_registration_form();
			}

			if ($controller == 'tournament' and $action == 'process')
			{
				$this->process_tournament_form();
			}

			if ($controller == 'transaction' and $action == 'update')
			{
				$this->add_records($this->get_cart($_REQUEST['custom']), $_REQUEST);
				$this->log(print_r($_REQUEST, true));
				$this->log(print_r($this->get_cart($_REQUEST['custom']), true));
				$this->log('-------------------------------------------------');
			}
		}


	}

	function add_player_form($key, $hide_add_button = false)
	{
		include('views/player-registration-form.php');
	}
}

if (!function_exists('pr'))
{
function pr($s)
{
	echo '<pre>';
	print_r($s);
	echo '</pre>';
}
}

$ylr = new YouthLeagueRegistration();
