<?php
App::uses('AppController', 'Controller');

class UsersController extends AppController {

	public $scaffold;
	
	public function beforeFilter()
	{
	   parent::beforeFilter();
	   $this->Auth->allow(array('register', 'all'));
	}
	
   /**
     * Log into the system.
     * Take information from the user and have it validated and handle it accordingly
     */
   public function login()
   { 
		// Loads the class
		App::uses('Browscap', 'Lib');

	   // The Browscap class is in the phpbrowscap namespace, so import it
//	   use phpbrowscap\Browscap;

      if ($this->request->is('post')) 
      {
         if ($this->Auth->login()) 
         {
         	$this->User->id = $this->Auth->user('id');
         	$user['last_login'] = date('Y-m-d h:i:s');
         	$user['browser'] = $_SERVER['HTTP_USER_AGENT'];
         	// Create a new Browscap object (loads or creates the cache)
			$bc = new Browscap(TMP);
			// Get information about the current browser's user agent
         	$user['browser_detail'] = serialize($bc->getBrowser(null, true));
         	$this->User->save($user);
            return $this->redirect($this->Auth->redirect());
         } 
         else 
         {
            $this->request->data['User']['password'] = null;
            $this->Session->setFlash(__('Username or password is incorrect'), 'default', array(), 'auth');
         }
      }
   }

   /**
     * Logout of the system.
     */
   public function logout()
   {
      $this->Session->setFlash('You have successfully logged out.');
      $this->redirect($this->Auth->logout());
   }

   /**
    * Change password
    */
	public function change_password() {
	    $id = $this->Auth->user('id');
	    $this->User->id = $id;
	    if (!$this->User->exists()) {
	      throw new NotFoundException(__('Invalid profile'));
	    }
	    if ($this->request->is('post') || $this->request->is('put')) {
	      if ($this->User->save($this->request->data)) {
	        $this->Session->setFlash(__('Your new password has been saved'));
	        $this->redirect('/');
	      } else {
	        $this->Session->setFlash(__('Your password could not be saved. Please, try again.'));
	        unset($this->request->data['User']['password']);
	        unset($this->request->data['User']['password_confirmation']);
	      }
	    } else {
	    $this->request->data['User']['id'] = $id;
	  }
	}
  
	/**
	  *  
	  */
	public function profile() {
		$id = $this->Auth->user('id');
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid profile'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->User->save($this->request->data)) {
				$this->Session->setFlash(__('Your profile has been saved'));
				$this->redirect('/');
			} else {
				$this->Session->setFlash(__('Your profile could not be saved. Please, try again.'));
			}
		} else {
			$this->request->data = $this->User->read(null, $id);
		}
	   	$this->set('teams', $this->User->Team->find('list', array('order' => 'name')));
	}
	
	/**
    * register method
    *
    * @return void
    */
   public function register() {
      if ($this->Auth->user('id'))
      {
         return $this->redirect('profile');
      }
	   	if ($this->request->is('post')) {
	   		$this->User->create();
	   		if ($this->User->save($this->request->data)) {
	   			$this->Session->setFlash(__('Your account has been created'));
	   			$this->redirect(array('action' => 'login'));
	   		} else {
	   			$this->Session->setFlash(__('Your account could not be created. Please, try again.'));
	   		}
	   	}
	   	$this->set('teams', $this->User->Team->find('list', array('order' => 'name')));
   }
   
   public function all()
   {
   	return $this->User->find('list');
   }


}
