<?php
App::uses('AppModel', 'Model');
/**
 * Practice Model
 *
 * @property Statement $Statement
 */
class Practice extends AppModel {
/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';
	
	public $belongsTo = array('User');

	public function saveWeek($user_id, $data)
	{
		foreach ($data as $date => $items)
        {
            $conditions = array('user_id' => $user_id, 'practice_date' => $date);
            if (array_sum($items) > 0)
            {
        		$items['practice_date'] = $date;
				$items['user_id'] = $user_id;
				$record = $this->find('first', compact('conditions'));
                if (empty($record))
                {
	              	$this->create();
	              	$record['Practice'] = $items;
               	}
               	else
               	{
		       		$this->id = $record['Practice']['id'];
					$record['Practice'] = array_merge($record['Practice'], $items);
               	}
               	$this->save($record);
            }
            else
            {
               $this->deleteAll($conditions);
            }
        }
	}

	public function getWeek($user_id, $week)
	{
		$conditions = array('user_id' => $user_id, 'WEEK(practice_date)' => $week);
		$data = $this->find('all', compact('conditions'));
		foreach ($data as $day)
		{
			$results[$day['Practice']['practice_date']] = $day['Practice'];
		}
		return $results;
	}

	public function getReportMonth($month, $team_id = null)
	{
		$fields = array(
			'User.name', 'User.team_id',
			'SUM(Practice.juggles) juggles',
			'SUM(Practice.touches) touches',
			'SUM(Practice.agility) agility',
			'SUM(Practice.fitness) fitness',
			'SUM(Practice.dash) dash',
			'SUM(Practice.dribble) dribble',
			'SUM(Practice.gk_throws) gk_throws',
			'SUM(Practice.gk_footwork) gk_footwork',
			'SUM(Practice.watch) watch',
			);
		$conditions = array('User.team_id > 0', 'MONTH(practice_date)' => $month);
		if ($team_id)
		{
			$conditions['User.team_id'] = $team_id;
		}
		$group = array(1, 2);
		$order = array('User.team_id', 'User.name');
		$data = $this->find('all', compact('fields', 'conditions', 'group', 'order'));
		return $data;
	}

}
