<?php
echo $this->Html->script('jquery.numeric', array('inline' => false));
echo $this->Html->scriptBlock("jQuery(function($){ $('.skills').numeric({ decimal: false, negative: false }); findTotals() })" , array('inline' => false));
if (empty($year))
{
   $year = date('Y');
}
$dformat = 'Y-m-d';
$today = date($dformat);
?>

<div class="games index">
<?php echo $this->Form->create('Practice', array('url' => array('action' => 'weekly', $week))); ?>
<fieldset>

<legend>
   <?php
      $start = date('F Y', strtotime($year . "W" . sprintf("%02d", $week) . 1));
      $end = date('F Y', strtotime($year . "W" . sprintf("%02d", $week) . 7));
      if ($start == $end)
      {
         echo $start;
      }
      else
      {
         echo $start, ' - ', $end;
      }
   ?>
</legend>
	<p>
	<?php if ($week == 1): ?>
		<?php echo $this->Html->link('< Previous Week', array('action' => 'weekly', 52)) ?>
	<?php else: ?>
		<?php echo $this->Html->link('< Previous Week', array('action' => 'weekly', $week-1)) ?>
	<?php endif; ?>
	<?php if ($week < date('W')): ?>
		| <?php echo $this->Html->link('This Week', array('action' => 'weekly')); ?> |
		<?php if ($week == 52): ?>
			<?php echo $this->Html->link('Next Week >', array('action' => 'weekly', 1)) ?>
		<?php else: ?>
			<?php echo $this->Html->link('Next Week >', array('action' => 'weekly', $week+1)) ?>
		<?php endif; ?>
	<?php endif; ?>
	</p>
	
	<script type="text/javascript">
		<!--
		document.write("<p>Mouse over a skill for more information.</p>")
		//-->
	</script>
	<noscript>See the table below for more information about each skill.</noscript>
	
   <table>
      <tr valign="top">
      <th>&nbsp;</th>
      <?php for ($d = 1; $d <= 7; $d++): ?>
         <?php $nowtime = strtotime($year . "W" . sprintf("%02d", $week) . $d); ?>
         <th><?php echo date('M j<\b\r>D', $nowtime) ?></th>
      <?php endfor; ?>
      <th>Total</th>
      </tr>

   <?php $tabindex = 1; ?>
   <?php foreach($skills as $skill): ?>
      <tr valign="top">
         <td nowrap><div class="tips" title="<?php echo $skill['Skill']['description'] ?>"><?php echo $skill['Skill']['name'] ?></div></td>
         <?php for ($d = 1; $d <= 7; $d++): ?>
            <?php $nowtime = strtotime($year . "W" . sprintf("%02d", $week) . $d); ?>
            <?php $now = date($dformat, $nowtime); ?>

            <?php if ($today == $now): ?>
               <td class="today">
            <?php else: ?>
               <td class="normal">
            <?php endif; ?>
            <?php if ($now > $today): ?>
               -
            <?php else: ?>
               <?php echo $this->Form->input($now . '.' . $skill['Skill']['fieldname'], array('type' => 'text', 'label' => false, 'class' => $skill['Skill']['fieldname'] . ' skills', 'style' => 'width: 60px', 'tabindex' => ($d*10)+$tabindex)) ?>
            <?php endif; ?>
            </td>
         <?php endfor; ?>
         <td class="normal total">&nbsp;</td>
         <?php $tabindex++; ?>
      </tr>

   <?php endforeach; ?>

   </table>
   </fieldset>
   <?php echo $this->Form->end('Submit'); ?>
   
   <noscript>
   <table>
   <tr><th>Skill</th><th>Description</th></tr>
   <tr><td>Juggles</td><td>Enter the total number of juggles performed or keep track of the amount of time you juggled and multiply it by the average number of juggles you did in that time period.  Example: if you juggle 100 times in one minute and you juggle for 30 minutes you multiply 100x30 and record a total of 3000 juggles for that day.</td></tr>
<tr><td>Touches</td><td>This can include touches on top of the ball with each foot (like the PPR testing) or hitting the ball against a solid surface using BOTH feet or using a soccer tool like the ones that have the ball in a net and you hold it with your hand.  Enter the total number of touches you perform  or keep track of the amount of time you touched the ball and multiply it by the average number of touches you did in that time period.  Example: if you touched the ball 100 times in one minute and you do this for 30 minutes you multiply 100x30 and record a total of 3000 touches for that day.</td></tr>
<tr><td>20 YD Agility</td><td>Put 3 cones or objects 5 yds apart from each other.  Start in the middle cone.  Sprint to the cone to the right then back to the furthest cone to the left and back to the middle.  Each time you complete this exercise you record that and 1pt. </td></tr>
<tr><td>300 YD Fitness</td><td>Put 2 cones 25 yds apart.  Start at the first cone and run AROUND the second cone and back to the first.  Continue running around the cones without stopping.  Once you run around the first cone 6 times you stop.  Record 1pt for each time you complete the exercise.</td></tr>
<tr><td>40 YD Dash</td><td>Put two cones 40 yds apart.  Start at the first cone and spring 40 yds to the second cone.  Record one point for each time you sprint 40 yds.</td></tr>
<tr><td>Speed Dribble</td><td>Place one code 10 yds from the first flag or any tall object.  From the first flag put a second flag 5 yds diagonally.  Then go directly straight and put another flag 5 yds.  Go back to the first flag and put another flag directly straight from that one 5 yds apart.  So there is a total of 4 flags (2 flags in a straight line that are 5 yds apart then 2 flags 5 yds apart diagonally).  Start from the cone and dribble AROUND each flag and then back again through the flags and return to the cone.  Record 1pt for each time you return to the cone.</td></tr>
<tr><td>GK Throws</td><td>Throw the ball to the ground from waist level.  Making sure to catch the ball using the proper "W" hand position that is standard for GK's.  Each time the ball hits your hands you count that as 1pt.</td></tr>
<tr><td>GK Footwork</td><td>Place 3 cones in a triangle shape.  Start on the cone to your left.  Side shuffle to the cone on your right.  Then sprint forward to the 3rd cone.  Then back peddle back to the first cone.  Record 1pt for each time you return back to the first cone.</td></tr>
<tr><td>Time Watching Professional Matches</td><td>Enter the amount of time in minutes you spent watching professional matches.</td></tr>
   </table>
   </noscript>
   
</div>