jQuery(function($){
  $('input:enabled:visible:first:not(:radio)').focus();
  $('.today:first').find('input:enabled:first').focus();
  $('.tips').bt({
	fill: '#f0f0f0',
    cornerRadius: 10,
    strokeWidth: 0,
    shadow: true,
    shadowOffsetX: 3,
    shadowOffsetY: 3,
    shadowBlur: 8,
    shadowColor: 'rgba(0,0,0,.9)',
    shadowOverlap: false,
    noShadowOpts: {strokeStyle: '#999', strokeWidth: 2},
    width: 300,
  });
  $('.skills').blur(function(){
	 findTotals(); 
  });
  $('#team_filter').change(function(e){
  	goto();
	e.preventDefault();
  });
  $('#month_filter').change(function(e){
  	goto();
	e.preventDefault();
  });

});

function goto()
{
	team = $('#team_filter').val();
	month = $('#month_filter').val();
	url = '';
	if (team > 0)
	{
		url += '/team_id:' + team;
	}
	if (month > 0)
	{
		url += '/month:' + month;
	}
	window.location = home_url + 'practices/report' + url;
}

function findTotals() {
    $("tbody tr").each(function() {
        row_total = 0; 
        $("td:not(.total) input:text",this).each(function() {
           row_total += Number($(this).val());
        }); 
        $(".total",this).html(addCommas(row_total));
    });
}

function addCommas(nStr)
{
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + ',' + '$2');
	}
	return x1 + x2;
}
