<?php
App::uses('AppController', 'Controller');
/**
 * Weddings Controller
 *
 * @property Wedding $Wedding
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class WeddingsController extends AppController {

/**
 * register method
 *
 * @return void
 */
	public function register() {
		if ($this->request->is('post')) {
			$this->Wedding->create();
			if ($this->Wedding->save($this->request->data)) {
				$this->Session->setFlash(__('Your new account has been created. We have sent you an confirmation email.'), 'alert-success');
				return $this->redirect(array('action' => 'login'));
			} else {
				$this->Session->setFlash(__('The wedding could not be saved. Please, try again.'), 'alert-danger');
			}
		}
	}

/**
 * login method
 */
	public function login() {
		$this->Session->setFlash('Invalid login credentials', 'alert-danger');
	}

/**
 * find method
 */
	public function find() {
		$options = array(
			'conditions' => array('OR' => array(
				'OR' => array(
					sprintf("bride_family_name LIKE '%%%s%%'", $this->data['Wedding']['name']),
					sprintf("groom_family_name LIKE '%%%s%%'", $this->data['Wedding']['name']),
				),
				'wedding_slug' => $this->data['Wedding']['wedding']
			))
		);
		$wedding = $this->Wedding->find('first', $options);
		if ($wedding) {
			return $this->redirect('/' . $wedding['Wedding']['wedding_slug']);
		}
		$this->Session->setFlash('Sorry. We cannot find that Wedding ID', 'alert-danger');
	}

/**
 * search method
 */
	public function search() {

	}

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Wedding->recursive = 0;
		$this->set('weddings', $this->Paginator->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Wedding->exists($id)) {
			throw new NotFoundException(__('Invalid wedding'));
		}
		$options = array('conditions' => array('Wedding.' . $this->Wedding->primaryKey => $id));
		$this->set('wedding', $this->Wedding->find('first', $options));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Wedding->exists($id)) {
			throw new NotFoundException(__('Invalid wedding'));
		}
		if ($this->request->is(array('post', 'put'))) {
			if ($this->Wedding->save($this->request->data)) {
				$this->Session->setFlash(__('The wedding has been saved.'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The wedding could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Wedding.' . $this->Wedding->primaryKey => $id));
			$this->request->data = $this->Wedding->find('first', $options);
		}
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		$this->Wedding->id = $id;
		if (!$this->Wedding->exists()) {
			throw new NotFoundException(__('Invalid wedding'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Wedding->delete()) {
			$this->Session->setFlash(__('The wedding has been deleted.'));
		} else {
			$this->Session->setFlash(__('The wedding could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
