<?php
$states = array(
	'AL'=>'Alabama',
	'AK'=>'Alaska',
	'AZ'=>'Arizona',
	'AR'=>'Arkansas',
	'CA'=>'California',
	'CO'=>'Colorado',
	'CT'=>'Connecticut',
	'DE'=>'Delaware',
	'DC'=>'District of Columbia',
	'FL'=>'Florida',
	'GA'=>'Georgia',
	'HI'=>'Hawaii',
	'ID'=>'Idaho',
	'IL'=>'Illinois',
	'IN'=>'Indiana',
	'IA'=>'Iowa',
	'KS'=>'Kansas',
	'KY'=>'Kentucky',
	'LA'=>'Louisiana',
	'ME'=>'Maine',
	'MD'=>'Maryland',
	'MA'=>'Massachusetts',
	'MI'=>'Michigan',
	'MN'=>'Minnesota',
	'MS'=>'Mississippi',
	'MO'=>'Missouri',
	'MT'=>'Montana',
	'NE'=>'Nebraska',
	'NV'=>'Nevada',
	'NH'=>'New Hampshire',
	'NJ'=>'New Jersey',
	'NM'=>'New Mexico',
	'NY'=>'New York',
	'NC'=>'North Carolina',
	'ND'=>'North Dakota',
	'OH'=>'Ohio',
	'OK'=>'Oklahoma',
	'OR'=>'Oregon',
	'PA'=>'Pennsylvania',
	'RI'=>'Rhode Island',
	'SC'=>'South Carolina',
	'SD'=>'South Dakota',
	'TN'=>'Tennessee',
	'TX'=>'Texas',
	'UT'=>'Utah',
	'VT'=>'Vermont',
	'VA'=>'Virginia',
	'WA'=>'Washington',
	'WV'=>'West Virginia',
	'WI'=>'Wisconsin',
	'WY'=>'Wyoming',
);
$id = $this->Form->value('Guest.id');
?>
<section data-nekoanim="fadeIn" data-nekodelay="100" class="color3 slice">
	<div class="container">
		<div class="row">
			<div class="col-sm-3">
				<?php echo $this->element('user-menu'); ?>
			</div>
			<div class="col-sm-9">
				<?php echo $this->Form->create('Guest', array('class' => 'form-horizontal', 'labelOffset' => 3, 'autocomplete' => 'off', 'role' => 'form')); ?>

				<h1>
				<?php if ($id): ?>
					Edit Guest
					<?php echo $this->Form->input('id'); ?>
				<?php else: ?>
					Add Guest
				<?php endif; ?>
				</h1>

					<?php
					echo $this->Form->hidden('wedding_id', array('value' => $wedding['Wedding']['id']));
					echo $this->Form->input('first_name', array('placeholder' => 'First Name'));
					echo $this->Form->input('last_name', array('placeholder' => 'Last Name'));
					echo $this->Form->input('envelope_line', array('placeholder' => 'Name on the envelope'));
					echo $this->Form->input('address', array('placeholder' => 'Address'));
					echo $this->Form->input('address_2', array('placeholder' => '(Optional)'));
					echo $this->Form->input('city', array('placeholder' => 'City'));
					echo $this->Form->input('state', array('options' => $states, 'empty' => '- Select State -'));
					echo $this->Form->input('zip', array('placeholder' => 'Zip Code'));
					echo $this->Form->input('email_address', array('placeholder' => 'Email address'));
					echo $this->Form->input('phone_number', array('placeholder' => '(Optional)'));
					?>
					<div class="col-sm-offset-3">
						<p>Which family do you know?</p>
						<label id="GuestKnowsBride" class="checkbox-inline">
							<?php echo $this->Form->checkbox('knows_bride'); ?>
							<?php echo $wedding['Wedding']['bride_family_name']; ?>
						</label>
						<label id="GuestKnowsGroom" class="checkbox-inline">
							<?php echo $this->Form->checkbox('knows_groom'); ?>
							<?php echo $wedding['Wedding']['groom_family_name']; ?>
						</label>
					</div>
					<br>
					<div class="col-sm-offset-3">
						<div class="checkbox">
							<label id="GuestRegistryOptin">
								<?php echo $this->Form->checkbox('registry_optin'); ?>
								Send information about the WEDDING REGISTRY
							</label>
						</div>
						<div class="checkbox">
							<label id="GuestCalendarOptin">
								<?php echo $this->Form->checkbox('calendar_optin'); ?>
								Send a calendar reminder to my email
							</label>
						</div>
					</div>
					<br>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-9">
							<?php echo $this->Form->submit('Submit', array('class' => 'btn btn-default btn-lg')); ?>
						</div>
					</div>
				</div>
				<?php echo $this->Form->end(); ?>
			</div>
		</div>
	</div>
</section>
<?php $this->Html->scriptStart(array('inline' => false)); ?>
jQuery('#GuestFirstName').focus();
<?php $this->Html->scriptEnd(); ?>
