
<?php foreach ($divisions as $label => $teams): ?>
	<h3><?php echo $label ?></h3>

	<table class="schedule-table" cellpadding="2" cellspacing="1" border="0">
	<thead>
	<tr>
		<td class="title-row" width="150">Team</td>
		<td class="title-row" width="50" align="center">Wins</td>
		<td class="title-row" width="50" align="center">Loses</td>
		<td class="title-row" width="50" align="center">Ties</td>
		<td class="title-row" width="50" align="center">Win Pct.</td>
		<td class="title-row" width="50" align="center">GB</td>
	</tr>
	</thead>
	<tbody>
	<?php $wins = 0; ?>
	<?php foreach ($teams as $t): ?>
		<?php if ($wins == 0)
		{
		   $wins = $t['wins'];
		   $loses = $t['loses'] + $t['ties'];
		   $gb = 0;
		}
		else 
		{
		  $gb = ($wins - $t['wins'] + ($t['loses'] + $t['ties']) - $loses) / 2;
		}
		$wp = sprintf("%0.3f", $t['wins'] / ($t['wins'] + $t['loses'] + $t['ties']));
		?>
		<tr>
			<td><?php echo $t['name']; ?> (<?php echo $t['coach'] ?>)</td>
			<td align="center"><?php echo $t['wins']; ?></td>
			<td align="center"><?php echo $t['loses']; ?></td>
			<td align="center"><?php echo empty($t['ties']) ? '' : $t['ties']; ?></td>
			<td align="center"><?php echo $wp ?></td>
			<td align="center"><?php echo $gb ? $gb : '-'; ?></td>
		</tr>
	<?php endforeach; ?>
	</tbody>
	</table>
<?php endforeach; ?>
