<?php
    // The list node
    function listItemCallback($node, $html) {
       $date = strtotime($node['Document']['visible_until']);
       $day = 60 * 60 * 24;
       if ($node['Document']['visible'])
       {
          $status = 'Visible';
       }
       else if ($date + $day > time())
       {
          $status = 'Visible until ' . date('M d, Y', $date);
       }
       else
       {
          $status = 'Not Visible expired on ' . date('M d, Y', $date);
       }
        $editLink = $html->link($node['Document']['description'] . ' (' . $status . ')', 
           array('action' => 'edit', 'id' => $node['Document']['id']),
           array('title' => 'Edit'));
        
        return '<div class="list-item">' . $editLink . '</div>';
    }

    echo
	$navigation->create(array(
	        'Delete' => '#Delete', 
	    ), array('id' => 'list-toolbar')),	
	$list->create($documents, array('model' => 'Document', 'class' => 'list selectable-list'));
?>

<div id="new-document">
    <h3>Add a new document</h3>
    <?php echo 
        $form->create('Document', array('action' => 'create', 'type' => 'file')),
        $form->input('description', array('between' => '<br />', 'tabindex' => '1')),
        $form->input('File', array('type' => 'file', 'between' => '<br />', 'tabindex' => '2')),
         "<p><small>$uploadLimits.</small></p>",
         '<p>If <em>Visible</em> is checked this document will appear on the client side, if not checked will appear until the <em>Visible Until</em> date.</p>',
        $form->input('visible', array('tabindex' => '3')),
        $form->input('visible_until', array('tabindex' => '4')),
        $cms->submit('Upload'),
        $form->end();
    ?>
</div>