<?php
/**
 *	Plugin Name: Vimeo Album Plugin
 *	Plugin URI: http://vanskyhawk.com/vimeo-album
 *	Description: Read albums from vimeo, display in gallery. Click to view.
 *	Version: 1.1
 *	Author: Brad Van Skyhawk
 *	Author URI: http://vanskyhawk.com
 *	License: GPL2
 *
 */

define('TVG_VERSION', '1.0');
define('TVG_PLUGIN_NAME', "tvg-vimeo-albums");
$tvg_script_url = get_option('home') . '/index.php?plugin=' . TVG_PLUGIN_NAME;
define('TVG_PATH',WP_PLUGIN_DIR.'/'.TVG_PLUGIN_NAME);
define('TVG_IMAGES_PATH', TVG_PATH.'/images');
define('TVG_CSS_PATH', TVG_PATH.'/css');
define('TVG_JS_PATH', TVG_PATH.'/js');
define('TVG_INCLUDES_PATH', TVG_PATH.'/includes');
define('TVG_VIEWS_PATH', TVG_PATH.'/views');
define('TVG_WIDGETS_PATH', TVG_PATH.'/widgets');
define('TVG_URL', plugins_url($path = '/'.TVG_PLUGIN_NAME));
define('TVG_IMAGES_URL', TVG_URL.'/images');
define('TVG_CSS_URL', TVG_URL.'/css');
define('TVG_JS_URL', TVG_URL.'/js');
define('TVG_INCLUDES_URL', TVG_URL.'/includes');
define('TVG_SCRIPT_URL',$tvg_script_url);

// Include the vimeo access library
if ( !class_exists( 'phpVimeo' ) ) {
	include_once( TVG_INCLUDES_PATH . '/vimeo.php' );
}

class TVG_VimeoAlbums {

 /**
  * __construct - plugin setup
  */
 	public function __construct() {

 		add_action( 'admin_menu', array( $this, 'adminMenu' ) );
 		add_shortcode( 'vimeo-albums', array( $this, 'videoShortcode' ) );
 		add_filter( 'wp_title', array( $this, 'videoTitle' ), 10, 2 );
 		//add_action('init', array( $this, 'add_my_rule' ) );
 		add_action('wp_enqueue_scripts', array( $this, 'loadScripts' ), 1);

 	}

 	public function loadScripts() {
	 	wp_enqueue_style( 'tgv-bxslider-css', TVG_CSS_URL.'/jquery.bxslider.css', array(), TVG_VERSION );
	 	wp_enqueue_style( 'tgv-stylesheet', TVG_CSS_URL.'/styles.css', array(), TVG_VERSION );
	 	wp_enqueue_script( 'tvg-bxslider-js', TVG_JS_URL.'/jquery.bxslider.min.js', array('jquery'), TVG_VERSION );
	 	wp_enqueue_script( 'tvg-script-js', TVG_JS_URL.'/video-filter.js', array('jquery'), TVG_VERSION );
 	}

    function add_my_rule()
    {
 //       global $wp;
 //       $wp->add_query_var('args');

//		add_rewrite_rule('video-list/(.+?)/?$','index.php?pagename=video-list&v=$matches[1]', 'top');
//        add_rewrite_rule('^video-list/([^/]*)/?','index.php?pagename=video-list&v=$matches[1]','top');
//        add_rewrite_rule('/test\/(.*)','index.php?pagename=video-list&args=$matches[1]','top');
    }


/**
 * adminMenu method
 */
 	public function adminMenu() {
		add_options_page(
			'Vimeo Album',
			'Vimeo Album',
			'manage_options',
			'tvg-vimeo-album',
			array($this, 'adminOptions')
		);
 	}

/**
 * adminOptions method
 */
	public function adminOptions() {

		if( !current_user_can( 'manage_options' ) ) {
			wp_die( 'You do not have the correct permissions to access this page.' );
		}

		if( isset( $_POST['tvgva_form_submitted'] ) ) {

			$hidden_field = esc_html( $_POST['tvgva_form_submitted'] );

			// save the options
			if( $hidden_field == 'Y' ) {

				$options['tvgva_username'] = esc_html( $_POST['tvgva_username'] );
				$options['tvgva_consumer_key'] = esc_html( $_POST['tvgva_consumer_key'] );
				$options['tvgva_consumer_secret'] = esc_html( $_POST['tvgva_consumer_secret'] );
				$options['tvgva_token'] = esc_html( $_POST['tvgva_token'] );
				$options['tvgva_token_secret'] = esc_html( $_POST['tvgva_token_secret'] );
				$options['tvgva_member_page'] = esc_html( $_POST['tvgva_member_page'] );
				$options['last_updated'] = time();

				update_option( 'tvgva_options', $options );
			}
		}

		// get the options
		$options = get_option( 'tvgva_options' );

		$tvgva_username = '';
		$tvgva_consumer_key = '';
		$tvgva_consumer_secret = '';
		$tvgva_token = '';
		$tvgva_token_secret = '';
		$tvgva_member_page = '';
		if( $options != '' ) {
			extract($options);
		}

		require( TVG_VIEWS_PATH . '/admin/admin_options.php' );
 	}

/**
 * shortcodeAlbum method
 */
	public function videoShortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(
			//'tooltip' => 'on'
		), $atts ) );

		ob_start();
		
		$options = get_option( 'tvgva_options' );

		if (isset($_GET['v'])) {
			$video = $this->__getVideoInfo($_GET['v']);
			require( TVG_VIEWS_PATH . '/shortcode/video_detail.php' );
		} else {
			$albumList = $this->__getAlbumList();
			$tags = $this->__extractTags($albumList);
			require( TVG_VIEWS_PATH . '/shortcode/video_list.php' );
		}

		$content = ob_get_clean();

		return $content;

	}

/**
 * change the title of the page for videos
 */
 	public function videoTitle( $title, $sep ) {
 		if ( isset( $_GET['v']) ) {
	 		return $_GET['v'] . ' ' . $sep . ' ';
 		}
	 	return $title;
 	}

/**
 * __extractTags method
 */
 	private function __extractTags($albums) {
 		foreach ($albums as $aid => $album) {
	 		foreach ($album['videos'] as $video) {
		 		if (count($video['tags'])) {
			 		foreach($video['tags'] as $tag) {
			 			$key = str_replace(array('(', ')'), array('-', '-'), $tag->normalized);
				 		$results[$key] = $tag->_content;
			 		}
		 		}
	 		}
 		}
 		uasort($results, array($this, '__array_cmp'));
 		return $results;
 	}

/**
 * __array_cmp method
 */
 	private function __array_cmp($a, $b)
 	{
    	$a = preg_replace('@^(a|an|the) @', '', $a);
		$b = preg_replace('@^(a|an|the) @', '', $b);
		return strcasecmp($a, $b);
	}


/**
 * __vimeoConnect method
 */
	private function __vimeoConnect() {
		$options = get_option( 'tvgva_options' );
		extract( $options );
		$this->vimeo = new phpVimeo( $tvgva_consumer_key, $tvgva_consumer_secret, $tvgva_token, $tvgva_token_secret );
		$this->vimeo->enableCache(phpVimeo::CACHE_FILE, TVG_PATH . '/cache', 300);
	}

/**
 * __vimeoCall method - make a call to the API
 */
	private function __vimeoCall($func, $params = array()) {
		if (empty($this->vimeo)) {
			$this->__vimeoConnect();
		}
		return $this->vimeo->call($func, $params);
	}

/**
 * __getVideoInfo
 */
	private function __getVideoInfo($videoId) {
		$result = $this->__vimeoCall('vimeo.videos.getInfo', array('video_id' => $videoId));
		$video['id'] = $result->video[0]->id;
		$video['privacy'] = $result->video[0]->privacy;
		$video['title'] = $result->video[0]->title;
		$video['description'] = $result->video[0]->description;
		return $video;
	}

/**
 * __getAlbumList method
 *
 * @return $list array
 */
	private function __getAlbumList() {
		$results = $this->__vimeoCall('vimeo.albums.getAll');
		$list = array();
		$titles = array();
		if ($results) {
			foreach ($results->albums->album as $album) {
				$titles[] = $album->title;
				if (strpos($album->title, '|') === false) {
					$t = $album->title;
				} else {
					list($d, $t) = explode('|', $album->title);				
				}
				$list[$album->id]['title'] = $album->title;
				$list[$album->id]['title_short'] = $t;
				$list[$album->id]['description'] = $album->description;
				$list[$album->id]['id'] = $album->id;

				$videos = $this->__vimeoCall('vimeo.albums.getVideos', array('album_id' => $album->id, 'full_response' => true));
				foreach ($videos->videos->video as $video) {
					$list[$album->id]['videos'][$video->id]['title'] = $video->title;
					$list[$album->id]['videos'][$video->id]['description'] = $video->description;
					$list[$album->id]['videos'][$video->id]['privacy'] = $video->privacy;
					$list[$album->id]['videos'][$video->id]['thumbnails'] = $video->thumbnails->thumbnail;
					$list[$album->id]['videos'][$video->id]['tags'] = $video->tags->tag;
				}
			}
		}

		// sort by title
		array_multisort($list, $titles);
		return $list;
	}

/**
 * __getList method
 */
 	private function __tagList($tags) {
 		if (empty($tags)) {
	 		return '';
 		}
	 	foreach ($tags as $tag) {
		 	$result[] = str_replace(array('(', ')'), array('-', '-'), $tag->normalized);
	 	}
	 	return implode(' ', $result);
 	}

 }


// Start the plugin
new TVG_VimeoAlbums();

// debug function
if ( ! function_exists( 'pr' )) {
 	function pr($s) { echo '<pre>'; print_r($s); echo '</pre>'; }
}

if ( ! function_exists( 'tvg_slugify' ) ) {
function tvg_slugify($text)
{
	// replace non letter or digits by -
	$text = preg_replace('~[^\\pL\d]+~u', '-', $text);

	// trim
	$text = trim($text, '-');

	// transliterate
	$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

	// lowercase
	$text = strtolower($text);

	// remove unwanted characters
	$text = preg_replace('~[^-\w]+~', '', $text);

	if (empty($text)) {
		return 'n-a';
	}

	return $text;
}
}