<?php
App::uses('CakeEmail', 'Network/Email');
/**
 * Email Service using SendGrid
 *
 * @author Brad Van Skyhawk
 * @version $Id$
 * @copyright Fidello Training Technologies, 3 April, 2012
 * @package default
 **/

class EmailServiceComponent extends Component {

	public $helpers = array('Html');

/**
 * EmailService object.
 *
 * @access private
 * @public object
 */
	public $cakemail;

/**
 * Layout for the View
 *
 * @public string
 * @access public
 */
	public $layout = 'default';

/**
 * Template for the view
 *
 * @public string
 * @access public
 */
	public $template = null;

/**
 * Constructor
 *
 * @param ComponentCollection $collection A ComponentCollection this component can use to lazy load its components
 * @param array $settings Array of configuration settings.
 */
	public function __construct(ComponentCollection $collection, $settings = array()) {
		$this->_controller = $collection->getController();
		parent::__construct($collection, $settings);

		// Include the class file and create EmailService instance
		$this->cakemail = new CakeEmail('mailgun');
	}

/**
 * forgot_password method
 */
	public function forgot_password($email, $hash) {
		$vars = array(
			'url' => Router::url(
				array(
					'controller' => 'users',
					'action' => 'password',
					$hash
				),
				true
			)
		);
		$this->_send($email, 'HandyInvites: Password recovery', 'forgot-password', $vars);
	}

/**
 * Send the email to the Email Server
 *
 * @param string $email
 * @param string $subject
 * @param string $body
 */
	protected function _send($email, $subject, $template, $vars = array()) {
		// Pass the site url.
		$vars['site_url'] = $this->_url();

		// Format with cakemail
		$this->cakemail
			->template($template)
			->viewVars($vars)
			->subject($subject)
			->emailFormat('both')
			->to($email)
			->from('noreply@handyinvites.com')
			->send();
	}

/**
 * Build the site url
 */
	protected function _url() {
		if (env('HTTPS')) {
			$url = 'https://';
		} else {
			$url = 'http://';
		}
		if (env('HTTP_HOST') != null) {
			$host = env('HTTP_HOST');
		}

		if (env('HTTP_X_FORWARDED_HOST') != null) {
			$host = env('HTTP_X_FORWARDED_HOST');
		}
		$host = trim(preg_replace('/(?:\:.*)/', '', $host));

		$url .= $host . $this->_controller->webroot;
		return str_replace('/app/webroot', '', $url);
	}

}
